/*
 * Decompiled with CFR 0.152.
 */
package com.netease.lava.webrtc;

import android.annotation.TargetApi;
import android.graphics.Matrix;
import android.opengl.GLES20;
import android.opengl.GLES30;
import com.netease.lava.webrtc.GlGenericDrawer;
import com.netease.lava.webrtc.GlShader;
import com.netease.lava.webrtc.GlTextureFrameBuffer;
import com.netease.lava.webrtc.GlUtil;
import com.netease.lava.webrtc.JavaI420Buffer;
import com.netease.lava.webrtc.JniCommon;
import com.netease.lava.webrtc.Logging;
import com.netease.lava.webrtc.ThreadUtils;
import com.netease.lava.webrtc.VideoFrame;
import com.netease.lava.webrtc.VideoFrameDrawer;
import com.netease.lava.webrtc.YuvHelper;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import javax.annotation.Nullable;

public class YuvConverter {
    private static final String FRAGMENT_SHADER = "uniform vec2 xUnit;\nuniform vec4 coeffs;\n\nvoid main() {\n  gl_FragColor.r = coeffs.a + dot(coeffs.rgb,\n      sample(tc - 1.5 * xUnit).rgb);\n  gl_FragColor.g = coeffs.a + dot(coeffs.rgb,\n      sample(tc - 0.5 * xUnit).rgb);\n  gl_FragColor.b = coeffs.a + dot(coeffs.rgb,\n      sample(tc + 0.5 * xUnit).rgb);\n  gl_FragColor.a = coeffs.a + dot(coeffs.rgb,\n      sample(tc + 1.5 * xUnit).rgb);\n}\n";
    private final ThreadUtils.ThreadChecker threadChecker = new ThreadUtils.ThreadChecker();
    private final GlTextureFrameBuffer i420TextureFrameBuffer = new GlTextureFrameBuffer(6408);
    private final ShaderCallbacks shaderCallbacks = new ShaderCallbacks();
    private final GlGenericDrawer drawer = new GlGenericDrawer("uniform vec2 xUnit;\nuniform vec4 coeffs;\n\nvoid main() {\n  gl_FragColor.r = coeffs.a + dot(coeffs.rgb,\n      sample(tc - 1.5 * xUnit).rgb);\n  gl_FragColor.g = coeffs.a + dot(coeffs.rgb,\n      sample(tc - 0.5 * xUnit).rgb);\n  gl_FragColor.b = coeffs.a + dot(coeffs.rgb,\n      sample(tc + 0.5 * xUnit).rgb);\n  gl_FragColor.a = coeffs.a + dot(coeffs.rgb,\n      sample(tc + 1.5 * xUnit).rgb);\n}\n", this.shaderCallbacks);
    private static final String TAG = "YuvConverter";
    private boolean isGles3;
    private int srcWidth;
    private int srcHeight;
    @Nullable
    private int[] downloadPboIds;
    private int m_FrameIndex;
    private boolean is_clear;

    public YuvConverter() {
        this.threadChecker.detachThread();
        this.isGles3 = false;
        this.srcWidth = 0;
        this.srcHeight = 0;
        this.m_FrameIndex = 0;
        this.is_clear = true;
        Logging.d(TAG, "create");
    }

    public VideoFrame.I420Buffer convert(VideoFrame.TextureBuffer inputTextureBuffer) {
        this.threadChecker.checkIsOnValidThread();
        int frameWidth = inputTextureBuffer.getWidth();
        int frameHeight = inputTextureBuffer.getHeight();
        int stride = (frameWidth + 7) / 8 * 8;
        int uvHeight = (frameHeight + 1) / 2;
        int totalHeight = frameHeight + uvHeight;
        ByteBuffer i420ByteBuffer = JniCommon.nativeAllocateByteBuffer(stride * totalHeight);
        int viewportWidth = stride / 4;
        Matrix renderMatrix = new Matrix();
        renderMatrix.preTranslate(0.5f, 0.5f);
        renderMatrix.preScale(1.0f, -1.0f);
        renderMatrix.preTranslate(-0.5f, -0.5f);
        this.i420TextureFrameBuffer.setSize(viewportWidth, totalHeight);
        GLES20.glBindFramebuffer((int)36160, (int)this.i420TextureFrameBuffer.getFrameBufferId());
        GlUtil.checkNoGLES2Error("glBindFramebuffer");
        this.updateShaderIfNeeded(inputTextureBuffer.getType(), frameWidth, frameHeight);
        this.shaderCallbacks.setPlaneY();
        VideoFrameDrawer.drawTexture(this.drawer, inputTextureBuffer, renderMatrix, frameWidth, frameHeight, 0, 0, viewportWidth, frameHeight);
        this.shaderCallbacks.setPlaneU();
        VideoFrameDrawer.drawTexture(this.drawer, inputTextureBuffer, renderMatrix, frameWidth, frameHeight, 0, frameHeight, viewportWidth / 2, uvHeight);
        this.shaderCallbacks.setPlaneV();
        VideoFrameDrawer.drawTexture(this.drawer, inputTextureBuffer, renderMatrix, frameWidth, frameHeight, viewportWidth / 2, frameHeight, viewportWidth / 2, uvHeight);
        GLES20.glReadPixels((int)0, (int)0, (int)this.i420TextureFrameBuffer.getWidth(), (int)this.i420TextureFrameBuffer.getHeight(), (int)6408, (int)5121, (Buffer)i420ByteBuffer);
        GlUtil.checkNoGLES2Error("YuvConverter.convert");
        GLES20.glBindFramebuffer((int)36160, (int)0);
        boolean yPos = false;
        int uPos = 0 + stride * frameHeight;
        int vPos = uPos + stride / 2;
        i420ByteBuffer.position(0);
        i420ByteBuffer.limit(0 + stride * frameHeight);
        ByteBuffer dataY = i420ByteBuffer.slice();
        i420ByteBuffer.position(uPos);
        int uvSize = stride * (uvHeight - 1) + stride / 2;
        i420ByteBuffer.limit(uPos + uvSize);
        ByteBuffer dataU = i420ByteBuffer.slice();
        i420ByteBuffer.position(vPos);
        i420ByteBuffer.limit(vPos + uvSize);
        ByteBuffer dataV = i420ByteBuffer.slice();
        ByteBuffer dataByteBufferU = JniCommon.nativeAllocateByteBuffer(stride * uvHeight / 2);
        ByteBuffer dataByteBufferV = JniCommon.nativeAllocateByteBuffer(stride * uvHeight / 2);
        YuvHelper.copyPlane(dataU, stride, dataByteBufferU, stride / 2, stride / 2, uvHeight);
        YuvHelper.copyPlane(dataV, stride, dataByteBufferV, stride / 2, stride / 2, uvHeight);
        dataByteBufferU.position(0);
        dataByteBufferV.position(0);
        return JavaI420Buffer.wrap(frameWidth, frameHeight, dataY, stride, dataByteBufferU, stride / 2, dataByteBufferV, stride / 2, () -> {
            JniCommon.nativeFreeByteBuffer(i420ByteBuffer);
            JniCommon.nativeFreeByteBuffer(dataByteBufferU);
            JniCommon.nativeFreeByteBuffer(dataByteBufferV);
        });
    }

    public void release() {
        Logging.d(TAG, "release");
        this.threadChecker.checkIsOnValidThread();
        this.drawer.release();
        this.i420TextureFrameBuffer.release();
        this.clearPBO();
        this.threadChecker.detachThread();
    }

    public void setOpenGles3(boolean isGles3) {
        this.isGles3 = isGles3;
    }

    public boolean isOpenGles3() {
        return this.isGles3;
    }

    public VideoFrame.I420Buffer wrapConvert(VideoFrame.TextureBuffer inputTextureBuffer) {
        return this.convert(inputTextureBuffer);
    }

    @TargetApi(value=26)
    public VideoFrame.I420Buffer convert2(VideoFrame.TextureBuffer inputTextureBuffer) {
        this.threadChecker.checkIsOnValidThread();
        this.is_clear = false;
        int frameWidth = inputTextureBuffer.getWidth();
        int frameHeight = inputTextureBuffer.getHeight();
        int stride = (frameWidth + 7) / 8 * 8;
        int uvHeight = (frameHeight + 1) / 2;
        int totalHeight = frameHeight + uvHeight;
        ByteBuffer i420ByteBuffer = JniCommon.nativeAllocateByteBuffer(stride * totalHeight);
        int viewportWidth = stride / 4;
        boolean isUpdate = false;
        if (this.srcWidth != frameWidth || this.srcHeight != frameHeight) {
            isUpdate = true;
            this.srcWidth = frameWidth;
            this.srcHeight = frameHeight;
            if (this.downloadPboIds == null) {
                this.downloadPboIds = new int[2];
                for (int i = 0; i < 2; ++i) {
                    this.downloadPboIds[i] = 0;
                }
            }
            if (this.downloadPboIds[0] != 0) {
                GLES30.glDeleteBuffers((int)2, (int[])this.downloadPboIds, (int)0);
            }
            GLES30.glGenBuffers((int)2, (int[])this.downloadPboIds, (int)0);
            int imgByteSize = viewportWidth * totalHeight * 4;
            GLES30.glBindBuffer((int)35051, (int)this.downloadPboIds[0]);
            GLES30.glBufferData((int)35051, (int)imgByteSize, null, (int)35041);
            GLES30.glBindBuffer((int)35051, (int)this.downloadPboIds[1]);
            GLES30.glBufferData((int)35051, (int)imgByteSize, null, (int)35041);
            GLES30.glBindBuffer((int)35051, (int)0);
        }
        int index = this.m_FrameIndex % 2;
        int nextIndex = (index + 1) % 2;
        Matrix renderMatrix = new Matrix();
        renderMatrix.preTranslate(0.5f, 0.5f);
        renderMatrix.preScale(1.0f, -1.0f);
        renderMatrix.preTranslate(-0.5f, -0.5f);
        this.i420TextureFrameBuffer.setSize(viewportWidth, totalHeight);
        GLES30.glBindFramebuffer((int)36160, (int)this.i420TextureFrameBuffer.getFrameBufferId());
        GlUtil.checkNoGLES2Error("glBindFramebuffer");
        this.shaderCallbacks.setPlaneY();
        VideoFrameDrawer.drawTexture(this.drawer, inputTextureBuffer, renderMatrix, frameWidth, frameHeight, 0, 0, viewportWidth, frameHeight);
        this.shaderCallbacks.setPlaneU();
        VideoFrameDrawer.drawTexture(this.drawer, inputTextureBuffer, renderMatrix, frameWidth, frameHeight, 0, frameHeight, viewportWidth / 2, uvHeight);
        this.shaderCallbacks.setPlaneV();
        VideoFrameDrawer.drawTexture(this.drawer, inputTextureBuffer, renderMatrix, frameWidth, frameHeight, viewportWidth / 2, frameHeight, viewportWidth / 2, uvHeight);
        int imgByteSize = this.i420TextureFrameBuffer.getWidth() * this.i420TextureFrameBuffer.getHeight() * 4;
        GLES30.glBindBuffer((int)35051, (int)this.downloadPboIds[index]);
        GLES30.glReadPixels((int)0, (int)0, (int)this.i420TextureFrameBuffer.getWidth(), (int)this.i420TextureFrameBuffer.getHeight(), (int)6408, (int)5121, (int)0);
        GLES30.glBindBuffer((int)35051, (int)this.downloadPboIds[nextIndex]);
        ByteBuffer mapped = (ByteBuffer)GLES30.glMapBufferRange((int)35051, (int)0, (int)imgByteSize, (int)1);
        if (!isUpdate) {
            i420ByteBuffer.position(0);
            i420ByteBuffer.put(mapped);
        }
        GLES30.glUnmapBuffer((int)35051);
        GLES30.glBindBuffer((int)35051, (int)0);
        GLES30.glBindFramebuffer((int)36160, (int)0);
        ++this.m_FrameIndex;
        GLES30.glFlush();
        GlUtil.checkNoGLES2Error("YuvConverter.convert2");
        if (isUpdate) {
            JniCommon.nativeFreeByteBuffer(i420ByteBuffer);
            return this.convert(inputTextureBuffer);
        }
        boolean yPos = false;
        int uPos = 0 + stride * frameHeight;
        int vPos = uPos + stride / 2;
        i420ByteBuffer.position(0);
        i420ByteBuffer.limit(0 + stride * frameHeight);
        ByteBuffer dataY = i420ByteBuffer.slice();
        i420ByteBuffer.position(uPos);
        int uvSize = stride * (uvHeight - 1) + stride / 2;
        i420ByteBuffer.limit(uPos + uvSize);
        ByteBuffer dataU = i420ByteBuffer.slice();
        i420ByteBuffer.position(vPos);
        i420ByteBuffer.limit(vPos + uvSize);
        ByteBuffer dataV = i420ByteBuffer.slice();
        ByteBuffer dataByteBufferU = JniCommon.nativeAllocateByteBuffer(stride * uvHeight / 2);
        ByteBuffer dataByteBufferV = JniCommon.nativeAllocateByteBuffer(stride * uvHeight / 2);
        YuvHelper.copyPlane(dataU, stride, dataByteBufferU, stride / 2, stride / 2, uvHeight);
        YuvHelper.copyPlane(dataV, stride, dataByteBufferV, stride / 2, stride / 2, uvHeight);
        dataByteBufferU.position(0);
        dataByteBufferV.position(0);
        return JavaI420Buffer.wrap(frameWidth, frameHeight, dataY, stride, dataByteBufferU, stride / 2, dataByteBufferV, stride / 2, () -> {
            JniCommon.nativeFreeByteBuffer(i420ByteBuffer);
            JniCommon.nativeFreeByteBuffer(dataByteBufferU);
            JniCommon.nativeFreeByteBuffer(dataByteBufferV);
        });
    }

    public void clearPBO() {
        if (this.downloadPboIds != null && !this.is_clear) {
            Logging.d(TAG, "clearPBO");
            GLES30.glDeleteBuffers((int)2, (int[])this.downloadPboIds, (int)0);
            this.is_clear = true;
            this.srcWidth = 0;
            this.srcHeight = 0;
            this.downloadPboIds = null;
        }
    }

    private void updateShaderIfNeeded(VideoFrame.TextureBuffer.Type textureBufferType, int frameWidth, int frameHeight) {
        boolean needUpdateShader = false;
        String fragmentSource = FRAGMENT_SHADER;
        if (this.srcWidth != frameWidth || this.srcHeight != frameHeight) {
            int minProductFor1080p = 1166400;
            int minSideLengthFor1080p = 1080;
            if (this.srcWidth * this.srcHeight >= minProductFor1080p && frameWidth * frameHeight < minProductFor1080p && (frameWidth < minSideLengthFor1080p || frameHeight < minSideLengthFor1080p)) {
                Logging.i(TAG, "update shader for 1080p, 1080p -> other, srcWidth:" + this.srcWidth + ", srcHeight:" + this.srcHeight + ", frameWidth:" + frameWidth + ", frameHeight:" + frameHeight);
                needUpdateShader = true;
            }
            if (this.srcWidth * this.srcHeight < minProductFor1080p && frameWidth * frameHeight >= minProductFor1080p && (frameWidth >= minSideLengthFor1080p || frameHeight >= minSideLengthFor1080p)) {
                Logging.i(TAG, "update shader for 1080p, other -> 1080p, srcWidth:" + this.srcWidth + ", srcHeight:" + this.srcHeight + ", frameWidth:" + frameWidth + ", frameHeight:" + frameHeight);
                needUpdateShader = true;
                fragmentSource = "uniform vec2 xUnit;\nuniform vec4 coeffs;\n\nvoid main() {\n  gl_FragColor.r = coeffs.a + dot(coeffs.rgb,\n      sample(tc - 1.6 * xUnit).rgb);\n  gl_FragColor.g = coeffs.a + dot(coeffs.rgb,\n      sample(tc - 0.4 * xUnit).rgb);\n  gl_FragColor.b = coeffs.a + dot(coeffs.rgb,\n      sample(tc + 0.4 * xUnit).rgb);\n  gl_FragColor.a = coeffs.a + dot(coeffs.rgb,\n      sample(tc + 1.6 * xUnit).rgb);\n}\n";
            }
            this.srcWidth = frameWidth;
            this.srcHeight = frameHeight;
        }
        if (needUpdateShader) {
            GlGenericDrawer.ShaderType shaderType = GlGenericDrawer.ShaderType.RGB;
            switch (textureBufferType) {
                case OES: {
                    shaderType = GlGenericDrawer.ShaderType.OES;
                    break;
                }
                case RGB: {
                    shaderType = GlGenericDrawer.ShaderType.RGB;
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown texture type.");
                }
            }
            this.drawer.updateShader(shaderType, fragmentSource);
        }
    }

    private static class ShaderCallbacks
    implements GlGenericDrawer.ShaderCallbacks {
        private static final float[] yCoeffs = new float[]{0.256788f, 0.504129f, 0.0979059f, 0.0627451f};
        private static final float[] uCoeffs = new float[]{-0.148223f, -0.290993f, 0.439216f, 0.501961f};
        private static final float[] vCoeffs = new float[]{0.439216f, -0.367788f, -0.0714274f, 0.501961f};
        private int xUnitLoc;
        private int coeffsLoc;
        private float[] coeffs;
        private float stepSize;

        private ShaderCallbacks() {
        }

        public void setPlaneY() {
            this.coeffs = yCoeffs;
            this.stepSize = 1.0f;
        }

        public void setPlaneU() {
            this.coeffs = uCoeffs;
            this.stepSize = 2.0f;
        }

        public void setPlaneV() {
            this.coeffs = vCoeffs;
            this.stepSize = 2.0f;
        }

        @Override
        public void onNewShader(GlShader shader) {
            this.xUnitLoc = shader.getUniformLocation("xUnit");
            this.coeffsLoc = shader.getUniformLocation("coeffs");
        }

        @Override
        public void onPrepareShader(GlShader shader, float[] texMatrix, int frameWidth, int frameHeight, int viewportWidth, int viewportHeight) {
            GLES20.glUniform4fv((int)this.coeffsLoc, (int)1, (float[])this.coeffs, (int)0);
            GLES20.glUniform2f((int)this.xUnitLoc, (float)(this.stepSize * texMatrix[0] / (float)frameWidth), (float)(this.stepSize * texMatrix[1] / (float)frameWidth));
        }
    }
}

