/*
 * Decompiled with CFR 0.152.
 */
package com.netease.lava.webrtc.bitrate;

import com.netease.lava.webrtc.Logging;
import com.netease.lava.webrtc.bitrate.BaseBitrateAdjuster;

public class DynamicBitrateAdjuster
extends BaseBitrateAdjuster {
    private static final String TAG = "DynamicBitrateAdjuster";
    private int adjustmentSecond = 3;
    private double basicScale = 2.0;
    private int adjustment_steps = 40;
    private final double BITS_PER_BYTE = 8.0;
    private double maxAdjustmentScale = 1.15;
    private double minAdjustmentScale = 0.8;
    private double deviationBytes;
    private double timeSinceLastAdjustmentMs;
    private int bitrateAdjustmentScaleExp;
    private double targetScale = 1.0;
    private int count;

    @Override
    public void setTargets(int targetBitrateBps, int targetFps) {
        int absTargetBitrate;
        if (targetBitrateBps <= 0 || targetFps <= 0) {
            return;
        }
        int absBitrate = this.targetBitrateBps - targetBitrateBps;
        int n = absTargetBitrate = absBitrate > 0 ? absBitrate : -absBitrate;
        if (this.targetBitrateBps != 0 && (double)absTargetBitrate * 1.0 / (double)this.targetBitrateBps < 0.05) {
            return;
        }
        this.deviationBytes = 0.0;
        this.timeSinceLastAdjustmentMs = 0.0;
        this.bitrateAdjustmentScaleExp = 0;
        this.count = 0;
        super.setTargets(targetBitrateBps, targetFps);
    }

    @Override
    public void reportEncodedFrame(int size) {
        if (this.targetFps <= 0 || size <= 0) {
            return;
        }
        double expectedBytesPerFrame = (double)this.targetBitrateBps / 8.0 / (double)this.targetFps;
        this.deviationBytes += (double)size - expectedBytesPerFrame;
        this.timeSinceLastAdjustmentMs += 1000.0 / (double)this.targetFps;
        ++this.count;
        double deviationThresholdBytes = (double)this.targetBitrateBps / 8.0;
        double deviationCap = (double)this.adjustmentSecond * deviationThresholdBytes;
        this.deviationBytes = Math.min(this.deviationBytes, deviationCap);
        this.deviationBytes = Math.max(this.deviationBytes, -deviationCap);
        if (this.adjustmentSecond <= 0 || this.timeSinceLastAdjustmentMs <= (double)(1000 * this.adjustmentSecond) && this.count < this.targetFps * this.adjustmentSecond) {
            return;
        }
        double highDeviation = expectedBytesPerFrame * (double)this.count * (this.maxAdjustmentScale - 1.0);
        double lowDeviation = expectedBytesPerFrame * (double)this.count * (1.0 - this.minAdjustmentScale);
        if (this.deviationBytes > highDeviation) {
            int bitrateAdjustmentInc = (int)(this.deviationBytes / highDeviation + 0.5);
            this.bitrateAdjustmentScaleExp -= bitrateAdjustmentInc;
            this.bitrateAdjustmentScaleExp = Math.max(this.bitrateAdjustmentScaleExp, -this.adjustment_steps);
            this.deviationBytes = highDeviation;
        } else if (this.deviationBytes < -lowDeviation) {
            int bitrateAdjustmentInc = (int)(-this.deviationBytes / lowDeviation + 0.5);
            this.bitrateAdjustmentScaleExp += bitrateAdjustmentInc;
            this.bitrateAdjustmentScaleExp = Math.min(this.bitrateAdjustmentScaleExp, this.adjustment_steps);
            this.deviationBytes = -lowDeviation;
        }
        this.timeSinceLastAdjustmentMs = 0.0;
        this.count = 0;
    }

    public double getBitrateAdjustmentScale() {
        double adjustScale = Math.pow(this.basicScale, (double)this.bitrateAdjustmentScaleExp / (double)this.adjustment_steps);
        return adjustScale;
    }

    @Override
    public int getAdjustedBitrateBps() {
        double adjustmentScale = this.getBitrateAdjustmentScale();
        if (adjustmentScale > this.maxAdjustmentScale) {
            adjustmentScale = this.maxAdjustmentScale;
        } else if (adjustmentScale < this.minAdjustmentScale) {
            adjustmentScale = this.minAdjustmentScale;
        }
        if (adjustmentScale != this.targetScale) {
            Logging.d(TAG, "getAdjustedBitrateBps: change scale from " + this.targetScale + " to: " + adjustmentScale + ", bitrateAdjustmentScaleExp: " + this.bitrateAdjustmentScaleExp);
            this.targetScale = adjustmentScale;
        }
        return (int)((double)this.targetBitrateBps * this.targetScale);
    }

    public void setMaxAdjustmentScale(double maxScale) {
        Logging.d(TAG, "setMaxAdjustmentScale: " + maxScale);
        this.maxAdjustmentScale = maxScale;
    }

    public void setMinAdjustmentSteps(int steps) {
        Logging.d(TAG, "setMinAdjustmentSteps: " + steps);
        this.adjustment_steps = steps;
    }

    public void setBasicScale(double basicScale) {
        Logging.d(TAG, "setBasicScale: " + basicScale);
        this.basicScale = basicScale;
    }

    public void setAdjustmentSecond(int secondCycle) {
        Logging.d(TAG, "setAdjustmentSecond: " + secondCycle);
        this.adjustmentSecond = secondCycle;
    }
}

