/*
 * Decompiled with CFR 0.152.
 */
package com.netease.lava.webrtc.bitrate;

import com.netease.lava.webrtc.Logging;
import com.netease.lava.webrtc.bitrate.BaseBitrateAdjuster;

public class NewDynamicBitrateAdjuster
extends BaseBitrateAdjuster {
    private static final String TAG = "NewDynamicBitrateAdjuster";
    private long nativeBitrateAdjusterInstance;
    private float min_adjusted_bitrate_pct = 0.5f;
    private float max_adjusted_bitrate_pct = 1.0f;
    private boolean enable_dynamic_adjust_max_bitrate_pct = true;
    private final Object dynamicBitrateAdjusterLock = new Object();

    public NewDynamicBitrateAdjuster(float minAdjustedBitratePct, float maxAdjustedBitratePct) {
        if (minAdjustedBitratePct > 0.0f) {
            this.min_adjusted_bitrate_pct = minAdjustedBitratePct;
        }
        if (maxAdjustedBitratePct > 0.0f) {
            this.max_adjusted_bitrate_pct = maxAdjustedBitratePct;
            this.enable_dynamic_adjust_max_bitrate_pct = false;
        }
        this.nativeBitrateAdjusterInstance = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init(int low_qp_threshold, int high_qp_threshold) {
        Logging.d(TAG, "init()");
        Object object = this.dynamicBitrateAdjusterLock;
        synchronized (object) {
            if (this.nativeBitrateAdjusterInstance != 0L) {
                NewDynamicBitrateAdjuster.nativeRelease(this.nativeBitrateAdjusterInstance);
                this.nativeBitrateAdjusterInstance = 0L;
            }
            this.nativeBitrateAdjusterInstance = NewDynamicBitrateAdjuster.nativeInit(this.min_adjusted_bitrate_pct, this.max_adjusted_bitrate_pct, this.enable_dynamic_adjust_max_bitrate_pct, low_qp_threshold, high_qp_threshold);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTargets(int targetBitrateBps, int targetFps) {
        Object object = this.dynamicBitrateAdjusterLock;
        synchronized (object) {
            if (this.nativeBitrateAdjusterInstance != 0L) {
                NewDynamicBitrateAdjuster.nativeSetTargetBitrateBps(this.nativeBitrateAdjusterInstance, targetBitrateBps);
            }
            super.setTargets(targetBitrateBps, targetFps);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reportEncodedFrame(int size) {
        Object object = this.dynamicBitrateAdjusterLock;
        synchronized (object) {
            if (this.nativeBitrateAdjusterInstance != 0L) {
                NewDynamicBitrateAdjuster.nativeReportEncodedFrame(this.nativeBitrateAdjusterInstance, size);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reportQP(int qp) {
        Object object = this.dynamicBitrateAdjusterLock;
        synchronized (object) {
            if (this.nativeBitrateAdjusterInstance != 0L) {
                NewDynamicBitrateAdjuster.nativeReportQP(this.nativeBitrateAdjusterInstance, qp);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getAdjustedBitrateBps() {
        Object object = this.dynamicBitrateAdjusterLock;
        synchronized (object) {
            if (this.nativeBitrateAdjusterInstance != 0L) {
                int ret = NewDynamicBitrateAdjuster.nativeGetAdjustedBitrateBps(this.nativeBitrateAdjusterInstance);
                if (ret <= 0) {
                    return super.getAdjustedBitrateBps();
                }
                return ret;
            }
            return super.getAdjustedBitrateBps();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release() {
        Logging.d(TAG, "release()");
        Object object = this.dynamicBitrateAdjusterLock;
        synchronized (object) {
            if (this.nativeBitrateAdjusterInstance != 0L) {
                NewDynamicBitrateAdjuster.nativeRelease(this.nativeBitrateAdjusterInstance);
                this.nativeBitrateAdjusterInstance = 0L;
            }
        }
    }

    private static native long nativeInit(float var0, float var1, boolean var2, int var3, int var4);

    private static native void nativeSetTargetBitrateBps(long var0, int var2);

    private static native void nativeReportEncodedFrame(long var0, int var2);

    private static native void nativeReportQP(long var0, int var2);

    private static native int nativeGetAdjustedBitrateBps(long var0);

    private static native void nativeRelease(long var0);
}

