/*
 * Decompiled with CFR 0.152.
 */
package com.netease.lava.webrtc.device;

import android.annotation.TargetApi;
import android.app.ActivityManager;
import android.content.Context;
import android.opengl.GLES20;
import android.os.Build;
import com.netease.lava.webrtc.CalledByNative;
import com.netease.lava.webrtc.ContextUtils;
import com.netease.lava.webrtc.EglBase;
import com.netease.lava.webrtc.Logging;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.annotation.Nullable;

public class AndroidDeviceInfo {
    private static final String TAG = "AndroidDeviceInfo";
    public static final int DEVICEINFO_UNKNOWN = -1;
    private static boolean cpuInited;
    private static boolean memoryInited;
    private static boolean gpuInited;
    private static int mNumCores;
    private static int mMaxCpuFreq;
    private static int mMinCpuFreq;
    @Nullable
    private static String mCpuName;
    @Nullable
    private static String mCpuAbi;
    private static long mMemory;
    private static String hardware;
    @Nullable
    private static String mGpuVendor;
    private static final FileFilter CPU_FILTER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void initCPU() {
        if (cpuInited) return;
        Class<AndroidDeviceInfo> clazz = AndroidDeviceInfo.class;
        synchronized (AndroidDeviceInfo.class) {
            if (cpuInited) return;
            long startTime = System.currentTimeMillis();
            mNumCores = AndroidDeviceInfo.getNumberOfCPUCoresImpl();
            mMaxCpuFreq = AndroidDeviceInfo.getCPUMaxFreqKHzImpl();
            mMinCpuFreq = AndroidDeviceInfo.getCPUMinFreqKHzImpl();
            mCpuAbi = AndroidDeviceInfo.getCPUABIImpl();
            mCpuName = AndroidDeviceInfo.getDeviceCpuNameImpl();
            cpuInited = true;
            Logging.d(TAG, "init CPU info time cost: " + (System.currentTimeMillis() - startTime) + "ms");
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void initMemory(Context context) {
        if (memoryInited) return;
        Class<AndroidDeviceInfo> clazz = AndroidDeviceInfo.class;
        synchronized (AndroidDeviceInfo.class) {
            if (memoryInited) return;
            long startTime = System.currentTimeMillis();
            mMemory = AndroidDeviceInfo.getTotalMemoryImpl(context);
            memoryInited = true;
            Logging.d(TAG, "init memory info time cost: " + (System.currentTimeMillis() - startTime) + "ms");
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final double getCpuTemperature() {
        int cpuTemp = -1;
        FileInputStream is = null;
        try {
            is = new FileInputStream("/sys/devices/virtual/thermal/thermal_zone0/temp");
            String deviceTemp = new BufferedReader(new InputStreamReader(is)).readLine();
            Integer.parseInt(deviceTemp);
            cpuTemp = Integer.parseInt(deviceTemp) / 1000;
        }
        catch (Exception e) {
            Logging.e(TAG, "getCpuTemperature  failed !");
            double d = -1.0;
            return d;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
        return cpuTemp;
    }

    @CalledByNative
    public static int getNumberOfCPUCores() {
        AndroidDeviceInfo.initCPU();
        return mNumCores;
    }

    private static int getNumberOfCPUCoresImpl() {
        int cores = 1;
        try {
            cores = AndroidDeviceInfo.getCoresFromFileInfo("/sys/devices/system/cpu/possible");
            if (cores == -1) {
                cores = AndroidDeviceInfo.getCoresFromFileInfo("/sys/devices/system/cpu/present");
            }
            if (cores == -1) {
                cores = AndroidDeviceInfo.getCoresFromCPUFileList();
            }
        }
        catch (Exception e) {
            cores = -1;
        }
        return cores;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getCoresFromFileInfo(String fileLocation) {
        FileInputStream is = null;
        try {
            is = new FileInputStream(fileLocation);
            BufferedReader buf = new BufferedReader(new InputStreamReader(is));
            String fileContents = buf.readLine();
            buf.close();
            int n = AndroidDeviceInfo.getCoresFromFileString(fileContents);
            return n;
        }
        catch (Exception e) {
            int n = -1;
            return n;
        }
        finally {
            if (is != null) {
                try {
                    ((InputStream)is).close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static int getCoresFromFileString(String str) {
        if (str == null || !str.matches("0-[\\d]+$")) {
            return -1;
        }
        int cores = Integer.valueOf(str.substring(2)) + 1;
        return cores;
    }

    private static int getCoresFromCPUFileList() {
        return new File("/sys/devices/system/cpu/").listFiles(CPU_FILTER).length;
    }

    @CalledByNative
    public static int getCPUMaxFreqKHz() {
        AndroidDeviceInfo.initCPU();
        return mMaxCpuFreq;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getCPUMaxFreqKHzImpl() {
        int maxFreq;
        block25: {
            maxFreq = -1;
            try {
                for (int i = 0; i < AndroidDeviceInfo.getNumberOfCPUCoresImpl(); ++i) {
                    String filename = "/sys/devices/system/cpu/cpu" + i + "/cpufreq/cpuinfo_max_freq";
                    File cpuInfoFreqFile = new File(filename);
                    if (!cpuInfoFreqFile.exists() || !cpuInfoFreqFile.canRead()) continue;
                    byte[] buffer = new byte[128];
                    FileInputStream stream = new FileInputStream(cpuInfoFreqFile);
                    try {
                        int endIndex;
                        stream.read(buffer);
                        for (endIndex = 0; Character.isDigit(buffer[endIndex]) && endIndex < buffer.length; ++endIndex) {
                        }
                        String str = new String(buffer, 0, endIndex);
                        Integer freqBound = Integer.parseInt(str);
                        if (freqBound <= maxFreq) continue;
                        maxFreq = freqBound;
                        continue;
                    }
                    catch (Exception exception) {
                        continue;
                    }
                    finally {
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                }
                if (maxFreq != -1) break block25;
                FileInputStream stream = new FileInputStream("/proc/cpuinfo");
                try {
                    int freqBound = AndroidDeviceInfo.parseFileForValue("cpu MHz", stream);
                    if ((freqBound *= 1000) > 0) {
                        maxFreq = freqBound;
                    }
                }
                finally {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
            catch (Exception e) {
                maxFreq = -1;
            }
        }
        return maxFreq;
    }

    public static int getCPUMinFreqKHz() {
        AndroidDeviceInfo.initCPU();
        return mMinCpuFreq;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static int getCPUMinFreqKHzImpl() {
        int minFreq = -1;
        try {
            for (int i = 0; i < AndroidDeviceInfo.getNumberOfCPUCoresImpl(); ++i) {
                String filename = "/sys/devices/system/cpu/cpu" + i + "/cpufreq/cpuinfo_min_freq";
                File cpuInfoFreqFile = new File(filename);
                if (!cpuInfoFreqFile.exists() || !cpuInfoFreqFile.canRead()) continue;
                byte[] buffer = new byte[128];
                FileInputStream stream = new FileInputStream(cpuInfoFreqFile);
                try {
                    int endIndex;
                    stream.read(buffer);
                    for (endIndex = 0; Character.isDigit(buffer[endIndex]) && endIndex < buffer.length; ++endIndex) {
                    }
                    String str = new String(buffer, 0, endIndex);
                    Integer freqBound = Integer.parseInt(str);
                    if (minFreq == -1 && freqBound >= 0) {
                        minFreq = freqBound;
                    }
                    if (freqBound >= minFreq) continue;
                    minFreq = freqBound;
                    continue;
                }
                catch (Exception e) {
                    int n = -1;
                    return n;
                }
                finally {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
            if (minFreq != -1) return minFreq;
            FileInputStream stream = new FileInputStream("/proc/cpuinfo");
            try {
                int freqBound = AndroidDeviceInfo.parseFileForValue("cpu MHz", stream);
                if ((freqBound *= 1000) <= 0) return minFreq;
                minFreq = freqBound;
                return minFreq;
            }
            finally {
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        catch (Exception e) {
            return -1;
        }
    }

    @Nullable
    @CalledByNative
    public static String getDeviceCpuName() {
        AndroidDeviceInfo.initCPU();
        return mCpuName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static String getDeviceCpuNameImpl() {
        String str1 = "/proc/cpuinfo";
        String str2 = "";
        FileReader fr = null;
        try {
            fr = new FileReader(str1);
            BufferedReader localBufferedReader = new BufferedReader(fr);
            while ((str2 = localBufferedReader.readLine()) != null) {
                if (!str2.contains("Hardware") || str2.split(":")[1] == null) continue;
                String string = str2.split(":")[1].trim();
                return string;
            }
            localBufferedReader.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (fr != null) {
                try {
                    fr.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    @Nullable
    @CalledByNative
    public static String getCPUABI() {
        AndroidDeviceInfo.initCPU();
        return mCpuAbi;
    }

    @Nullable
    private static String getCPUABIImpl() {
        String os_cpuabi = null;
        try {
            os_cpuabi = new BufferedReader(new InputStreamReader(Runtime.getRuntime().exec("getprop ro.product.cpu.abi").getInputStream())).readLine();
        }
        catch (Exception e) {
            Logging.e(TAG, "getCPU ABI failed !");
            return null;
        }
        return os_cpuabi;
    }

    @TargetApi(value=16)
    @CalledByNative
    public static long getTotalMemory() {
        AndroidDeviceInfo.initMemory(ContextUtils.getApplicationContext());
        return mMemory;
    }

    @TargetApi(value=16)
    public static long getTotalMemory(Context context) {
        AndroidDeviceInfo.initMemory(context);
        return mMemory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long getTotalMemoryImpl(Context context) {
        if (context != null && Build.VERSION.SDK_INT >= 16) {
            ActivityManager.MemoryInfo memInfo = new ActivityManager.MemoryInfo();
            ActivityManager am = (ActivityManager)context.getSystemService("activity");
            am.getMemoryInfo(memInfo);
            if (memInfo != null) {
                return memInfo.totalMem;
            }
            return -1L;
        }
        long totalMem = -1L;
        try {
            FileInputStream stream = new FileInputStream("/proc/meminfo");
            try {
                totalMem = AndroidDeviceInfo.parseFileForValue("MemTotal", stream);
            }
            finally {
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        catch (Exception e) {
            return -1L;
        }
        return totalMem *= 1024L;
    }

    private static int parseFileForValue(String textToMatch, FileInputStream stream) {
        byte[] buffer = new byte[1024];
        try {
            int length = stream.read(buffer);
            for (int i = 0; i < length; ++i) {
                int textIndex;
                if (buffer[i] != 10 && i != 0) continue;
                if (buffer[i] == 10) {
                    // empty if block
                }
                for (int j = ++i; j < length && buffer[j] == textToMatch.charAt(textIndex = j - i); ++j) {
                    if (textIndex != textToMatch.length() - 1) continue;
                    return AndroidDeviceInfo.extractValue(buffer, j);
                }
            }
        }
        catch (Exception e) {
            return -1;
        }
        return -1;
    }

    private static int extractValue(byte[] buffer, int index) {
        while (index < buffer.length && buffer[index] != 10) {
            if (Character.isDigit(buffer[index])) {
                int start = index++;
                while (index < buffer.length && Character.isDigit(buffer[index])) {
                    ++index;
                }
                String str = new String(buffer, 0, start, index - start);
                return Integer.parseInt(str);
            }
            ++index;
        }
        return -1;
    }

    @CalledByNative
    public static String getHardwareVendorName() {
        return hardware;
    }

    @CalledByNative
    public static int getOsVersion() {
        return Build.VERSION.SDK_INT;
    }

    public static boolean isHardWareVendorQualcomm() {
        return hardware.matches("qcom");
    }

    public static boolean isHardWareVendorHisi() {
        return hardware.matches("kirin[0-9]*");
    }

    public static boolean isHardWareVendorMediaTek() {
        return hardware.matches("mt[0-9]*") || hardware.matches("m[0-9]*");
    }

    public static boolean isHardWareVendorDimensity() {
        return hardware.matches("^mt6[89].*");
    }

    public static boolean isHardWareVendorSprd() {
        return hardware.matches("sp[0-9]*");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void initGPU() {
        if (gpuInited) return;
        Class<AndroidDeviceInfo> clazz = AndroidDeviceInfo.class;
        synchronized (AndroidDeviceInfo.class) {
            if (gpuInited) return;
            long startTime = System.currentTimeMillis();
            mGpuVendor = AndroidDeviceInfo.getGPUVendor();
            gpuInited = true;
            Logging.d(TAG, "init GPU info time cost: " + (System.currentTimeMillis() - startTime) + "ms");
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    private static EglBase createEglBaseWithPixelBuffer(EglBase.Context context) {
        EglBase eglBase = EglBase.create(context, EglBase.CONFIG_PIXEL_BUFFER);
        eglBase.createDummyPbufferSurface();
        eglBase.makeCurrent();
        return eglBase;
    }

    private static String getGPUVendor() {
        EglBase eglBase = AndroidDeviceInfo.createEglBaseWithPixelBuffer(null);
        String gpu_vendor = GLES20.glGetString((int)7936) + " " + GLES20.glGetString((int)7937);
        eglBase.release();
        return gpu_vendor;
    }

    @Nullable
    @CalledByNative
    public static String getDeviceGPUVendor() {
        AndroidDeviceInfo.initGPU();
        return mGpuVendor;
    }

    static {
        hardware = Build.HARDWARE;
        CPU_FILTER = new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                String path = pathname.getName();
                if (path.startsWith("cpu")) {
                    for (int i = 3; i < path.length(); ++i) {
                        if (Character.isDigit(path.charAt(i))) continue;
                        return false;
                    }
                    return true;
                }
                return false;
            }
        };
    }
}

