/*
 * Decompiled with CFR 0.152.
 */
package com.netease.lava.webrtc.device;

import android.os.Build;
import com.netease.lava.webrtc.device.AndroidDeviceInfo;
import com.netease.lava.webrtc.device.CpuFamily;

public class HardwareLevel {
    public static final int LEVEL_UNKNOWN = -1;
    public static final int LEVEL_LOW = 1;
    public static final int LEVEL_MEDIUM = 2;
    public static final int LEVEL_HIGH = 3;

    public static int level() {
        String arch = AndroidDeviceInfo.getCPUABI();
        long totalRam = AndroidDeviceInfo.getTotalMemory(null);
        long cpuFreq = AndroidDeviceInfo.getCPUMaxFreqKHz();
        if (arch == null || totalRam == -1L || cpuFreq == -1L) {
            return -1;
        }
        long GB = 0x40000000L;
        if (totalRam <= 0x80000000L || !CpuFamily.is64BitArch(arch) || Build.VERSION.SDK_INT <= 23 || cpuFreq < 1500000L) {
            return 1;
        }
        if (CpuFamily.is64BitArch(arch) && totalRam >= 0x1C0000000L && cpuFreq > 2500000L) {
            return 3;
        }
        return 2;
    }
}

