/*
 * Decompiled with CFR 0.152.
 */
package com.netease.lava.webrtc.voiceengine;

import android.media.AudioFormat;
import android.media.AudioManager;
import android.media.AudioPlaybackCaptureConfiguration;
import android.media.AudioRecord;
import android.media.projection.MediaProjection;
import android.media.projection.MediaProjectionManager;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Process;
import com.netease.lava.webrtc.ContextUtils;
import com.netease.lava.webrtc.Logging;
import com.netease.lava.webrtc.ThreadUtils;
import com.netease.lava.webrtc.voiceengine.WebRtcAudioUtils;
import java.nio.ByteBuffer;
import java.util.Arrays;
import javax.annotation.Nullable;

public class WebRtcAudioLoopBack {
    private static final boolean DEBUG = false;
    private static final String TAG = "WebRtcAudioLoopBack";
    private static final int BITS_PER_SAMPLE = 16;
    private static final int CALLBACK_BUFFER_SIZE_MS = 10;
    private static final int BUFFERS_PER_SECOND = 100;
    private static final int BUFFER_SIZE_FACTOR = 2;
    private int reTryCnt = 10;
    private Handler handler;
    private boolean isSCOon;
    private static final long AUDIO_RECORD_THREAD_JOIN_TIMEOUT_MS = 2000L;
    private final long nativeAudioLoopBack;
    private ByteBuffer byteBuffer;
    private static MediaProjection.Callback mCallback;
    private HandlerThread thread;
    @Nullable
    private AudioRecord audioRecord;
    @Nullable
    private AudioLoopBackThread audioThread;
    private MediaProjectionManager mediaProjectionManager;
    private static volatile boolean microphoneMute;
    private MediaProjection mediaProjectionPermissionResultData;
    private byte[] emptyBytes;
    @Nullable
    public static WebRtcAudioLoopBackIntentCallback intentCallback;
    @Nullable
    private static WebRtcAudioLoopBackStateCallback stateCallback;
    @Nullable
    private static WebRtcAudioLoopBackSamplesReadyCallback audioSamplesReadyCallback;

    public static void setStateCallback(WebRtcAudioLoopBackStateCallback stateCallback) {
        Logging.d(TAG, "Set state callback");
        WebRtcAudioLoopBack.stateCallback = stateCallback;
    }

    public static void setIntentCallback(WebRtcAudioLoopBackIntentCallback callback) {
        Logging.d(TAG, "Set Intent callback");
        intentCallback = callback;
    }

    public static void setMediaProjectionCallback(MediaProjection.Callback callback) {
        mCallback = callback;
    }

    public static void setOnAudioSamplesReady(WebRtcAudioLoopBackSamplesReadyCallback callback) {
        audioSamplesReadyCallback = callback;
    }

    WebRtcAudioLoopBack(long nativeAudioLoopBack) {
        Logging.d(TAG, "ctor" + WebRtcAudioUtils.getThreadInfo());
        this.nativeAudioLoopBack = nativeAudioLoopBack;
        this.reTryCnt = 10;
    }

    private boolean enableBuiltInAEC(boolean enable) {
        return false;
    }

    private boolean enableBuiltInNS(boolean enable) {
        return false;
    }

    private void setCompatAudioSource(int source) {
    }

    private int initRecording(int sampleRate, int channels) {
        try {
            if (Build.VERSION.SDK_INT > 28) {
                this.mediaProjectionPermissionResultData = intentCallback.onWebRtcAudioLoopBackNeedIntent();
                if (this.mediaProjectionPermissionResultData == null) {
                    Logging.e(TAG, "error mediaProjectionPermissionResultData");
                    return -1;
                }
                Logging.d(TAG, "(sampleRate=" + sampleRate + ", channels=" + channels + ")");
                this.thread = new HandlerThread("audio_loop_handler");
                this.thread.start();
                this.handler = new Handler(this.thread.getLooper());
                this.mediaProjectionPermissionResultData.registerCallback(mCallback, this.handler);
                if (intentCallback == null) {
                    return -1;
                }
                if (this.audioRecord != null) {
                    this.reportWebRtcAudioLoopBackInitError("InitRecording called twice without StopRecording.");
                    return -1;
                }
                int bytesPerFrame = channels * 2;
                int framesPerBuffer = sampleRate / 100;
                this.byteBuffer = ByteBuffer.allocateDirect(bytesPerFrame * framesPerBuffer);
                Logging.d(TAG, "byteBuffer.capacity: " + this.byteBuffer.capacity());
                this.emptyBytes = new byte[this.byteBuffer.capacity()];
                this.nativeCacheDirectBufferAddress(this.byteBuffer, this.nativeAudioLoopBack);
                int channelConfig = this.channelCountToConfiguration(channels);
                int minBufferSize = AudioRecord.getMinBufferSize((int)sampleRate, (int)channelConfig, (int)2);
                if (minBufferSize == -1 || minBufferSize == -2) {
                    this.reportWebRtcAudioLoopBackInitError("AudioRecord.getMinBufferSize failed: " + minBufferSize);
                    return -1;
                }
                Logging.d(TAG, "AudioRecord.getMinBufferSize:" + minBufferSize);
                int bufferSizeInBytes = Math.max(2 * minBufferSize, this.byteBuffer.capacity());
                Logging.d(TAG, "bufferSizeInBytes: " + bufferSizeInBytes);
                AudioPlaybackCaptureConfiguration.Builder builder = new AudioPlaybackCaptureConfiguration.Builder(this.mediaProjectionPermissionResultData);
                AudioManager am = (AudioManager)ContextUtils.getApplicationContext().getSystemService("audio");
                builder.addMatchingUsage(1);
                builder.addMatchingUsage(4);
                builder.addMatchingUsage(14);
                builder.addMatchingUsage(0);
                builder.addMatchingUsage(16);
                if (Build.VERSION.SDK_INT < 31) {
                    builder.addMatchingUsage(2);
                }
                builder.addMatchingUsage(11);
                builder.addMatchingUsage(12);
                builder.addMatchingUsage(6);
                AudioPlaybackCaptureConfiguration config = builder.build();
                AudioRecord.Builder rb = new AudioRecord.Builder().setAudioFormat(new AudioFormat.Builder().setEncoding(2).setSampleRate(sampleRate).setChannelMask(channelConfig).build()).setAudioPlaybackCaptureConfig(config).setBufferSizeInBytes(bufferSizeInBytes);
                int mMODE = am.getMode();
                this.isSCOon = am.isBluetoothScoOn();
                am.setMode(0);
                this.audioRecord = rb.build();
                am.setMode(mMODE);
                if (this.audioRecord == null || this.audioRecord.getState() != 1) {
                    this.reportWebRtcAudioLoopBackInitError("Failed to create a new AudioRecord instance");
                    this.releaseAudioResources();
                    return -1;
                }
                this.logMainParameters();
                this.logMainParametersExtended();
                return framesPerBuffer;
            }
        }
        catch (Exception e) {
            this.reportWebRtcAudioLoopBackInitError("AudioRecord ctor error: " + e.getMessage());
            this.releaseAudioResources();
            if (Build.VERSION.SDK_INT >= 21) {
                mCallback.onStop();
            }
            return -1;
        }
        return 0;
    }

    private boolean startRecording() {
        Logging.d(TAG, "startRecording");
        try {
            if (this.audioRecord == null) {
                return false;
            }
            AudioManager am = (AudioManager)ContextUtils.getApplicationContext().getSystemService("audio");
            int mMODE = am.getMode();
            am.setMode(0);
            this.audioRecord.startRecording();
            am.setMode(mMODE);
            if (this.isSCOon && mMODE == 3) {
                am.stopBluetoothSco();
                am.setBluetoothScoOn(false);
                am.startBluetoothSco();
                am.setBluetoothScoOn(true);
            }
            if (this.audioRecord.getRecordingState() != 3) {
                return false;
            }
            if (this.audioThread != null) {
                return false;
            }
            this.audioThread = new AudioLoopBackThread("AudioLoopBackJavaThread");
            this.audioThread.start();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private boolean stopRecording() {
        Logging.d(TAG, "stopRecording");
        if (this.audioThread == null) {
            return false;
        }
        this.audioThread.stopThread();
        if (!ThreadUtils.joinUninterruptibly(this.audioThread, 2000L)) {
            Logging.e(TAG, "Join of AudioLoopBackJavaThread timed out");
            WebRtcAudioUtils.logAudioState(TAG);
        }
        this.audioThread = null;
        this.releaseAudioResources();
        return true;
    }

    private void logMainParameters() {
        Logging.d(TAG, "AudioLoopBack: session ID: " + this.audioRecord.getAudioSessionId() + ", channels: " + this.audioRecord.getChannelCount() + ", sample rate: " + this.audioRecord.getSampleRate());
    }

    private void logMainParametersExtended() {
        if (Build.VERSION.SDK_INT >= 23) {
            Logging.d(TAG, "AudioRecord: buffer size in frames: " + this.audioRecord.getBufferSizeInFrames());
        }
    }

    private static void assertTrue(boolean condition) {
        if (!condition) {
            throw new AssertionError((Object)"Expected condition to be true");
        }
    }

    private int channelCountToConfiguration(int channels) {
        return channels == 1 ? 16 : 12;
    }

    private native void nativeCacheDirectBufferAddress(ByteBuffer var1, long var2);

    private native void nativeDataIsRecorded(int var1, long var2, int var4);

    public static synchronized void setAudioSource(int source) {
    }

    private static int getDefaultAudioSource() {
        return -1;
    }

    public static void setMicrophoneMute(boolean mute) {
        Logging.w(TAG, "setMicrophoneMute(" + mute + ")");
        microphoneMute = mute;
    }

    private void setMicrophoneMuteInternal(boolean mute) {
        Logging.w(TAG, "setMicrophoneMuteInternal(" + mute + ")");
        microphoneMute = mute;
    }

    private void releaseAudioResources() {
        Logging.d(TAG, "releaseAudioResources");
        try {
            if (this.audioRecord != null) {
                this.audioRecord.release();
                this.audioRecord = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (Build.VERSION.SDK_INT > 21 && this.mediaProjectionPermissionResultData != null) {
            this.mediaProjectionPermissionResultData.unregisterCallback(mCallback);
        }
        if (this.handler != null) {
            this.handler.getLooper().quit();
        }
        if (this.thread != null) {
            this.thread.quit();
        }
    }

    private void reportWebRtcAudioLoopBackInitError(String errorMessage) {
        Logging.e(TAG, "Init recording error: " + errorMessage);
        WebRtcAudioUtils.logAudioState(TAG);
        if (stateCallback != null) {
            stateCallback.onWebRtcAudioLoopBackInitError(errorMessage);
        }
    }

    private void reportWebRtcAudioLoopBackError(String errorMessage) {
        Logging.e(TAG, "Run-time recording error: " + errorMessage);
        WebRtcAudioUtils.logAudioState(TAG);
        if (stateCallback != null) {
            stateCallback.onWebRtcAudioLoopBackError(errorMessage);
        }
    }

    private void reportWebRtcAudioLoopBackOpened() {
        Logging.d(TAG, "opened");
        if (stateCallback != null) {
            stateCallback.onWebRtcAudioLoopBackOpened();
        }
    }

    private void reportWebRtcAudioLoopBackClosed() {
        Logging.d(TAG, "closed");
        if (stateCallback != null) {
            stateCallback.onWebRtcAudioLoopBackClosed();
        }
    }

    private class AudioLoopBackThread
    extends Thread {
        private volatile boolean keepAlive;
        private Handler handler;

        public AudioLoopBackThread(String name) {
            super(name);
            this.keepAlive = true;
            this.reset();
            try {
                Looper.prepare();
                this.handler = new Handler(Looper.myLooper());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void reset() {
        }

        @Override
        public void run() {
            Process.setThreadPriority((int)-19);
            Logging.d(WebRtcAudioLoopBack.TAG, "AudioLoopBackThread" + WebRtcAudioUtils.getThreadInfo());
            long lastTime = System.nanoTime();
            WebRtcAudioLoopBack.this.reportWebRtcAudioLoopBackOpened();
            while (this.keepAlive) {
                int bytesRead = -3;
                if (WebRtcAudioLoopBack.this.audioRecord != null) {
                    bytesRead = WebRtcAudioLoopBack.this.audioRecord.read(WebRtcAudioLoopBack.this.byteBuffer, WebRtcAudioLoopBack.this.byteBuffer.capacity());
                }
                if (bytesRead == WebRtcAudioLoopBack.this.byteBuffer.capacity()) {
                    if (microphoneMute) {
                        WebRtcAudioLoopBack.this.byteBuffer.clear();
                        WebRtcAudioLoopBack.this.byteBuffer.put(WebRtcAudioLoopBack.this.emptyBytes);
                    }
                    if (this.keepAlive) {
                        WebRtcAudioLoopBack.this.nativeDataIsRecorded(bytesRead, WebRtcAudioLoopBack.this.nativeAudioLoopBack, 0);
                    }
                    if (audioSamplesReadyCallback == null) continue;
                    byte[] data = Arrays.copyOf(WebRtcAudioLoopBack.this.byteBuffer.array(), WebRtcAudioLoopBack.this.byteBuffer.capacity());
                    audioSamplesReadyCallback.onWebRtcAudioLoopBackSamplesReady(new AudioSamples(WebRtcAudioLoopBack.this.audioRecord, data));
                    continue;
                }
                String errorMessage = "AudioRecord.read failed: " + bytesRead;
                Logging.e(WebRtcAudioLoopBack.TAG, errorMessage);
                if (bytesRead != -3) continue;
                this.keepAlive = false;
                WebRtcAudioLoopBack.this.reportWebRtcAudioLoopBackError(errorMessage);
            }
            try {
                if (WebRtcAudioLoopBack.this.audioRecord != null) {
                    WebRtcAudioLoopBack.this.audioRecord.stop();
                }
            }
            catch (IllegalStateException e) {
                Logging.e(WebRtcAudioLoopBack.TAG, "AudioRecord.stop failed: " + e.getMessage());
            }
            intentCallback.stopAudioLoopBack();
            WebRtcAudioLoopBack.this.reportWebRtcAudioLoopBackClosed();
        }

        public void stopThread() {
            Logging.d(WebRtcAudioLoopBack.TAG, "stopThread");
            this.keepAlive = false;
        }
    }

    public static interface WebRtcAudioLoopBackSamplesReadyCallback {
        public void onWebRtcAudioLoopBackSamplesReady(AudioSamples var1);
    }

    public static class AudioSamples {
        private final int audioFormat;
        private final int channelCount;
        private final int sampleRate;
        private final byte[] data;

        private AudioSamples(AudioRecord audioRecord, byte[] data) {
            this.audioFormat = audioRecord.getAudioFormat();
            this.channelCount = audioRecord.getChannelCount();
            this.sampleRate = audioRecord.getSampleRate();
            this.data = data;
        }

        public int getAudioFormat() {
            return this.audioFormat;
        }

        public int getChannelCount() {
            return this.channelCount;
        }

        public int getSampleRate() {
            return this.sampleRate;
        }

        public byte[] getData() {
            return this.data;
        }
    }

    public static interface WebRtcAudioLoopBackIntentCallback {
        public MediaProjection onWebRtcAudioLoopBackNeedIntent();

        public void stopAudioLoopBack();
    }

    public static interface WebRtcAudioLoopBackStateCallback {
        public void onWebRtcAudioLoopBackInitError(String var1);

        public void onWebRtcAudioLoopBackError(String var1);

        public void onWebRtcAudioLoopBackOpened();

        public void onWebRtcAudioLoopBackClosed();
    }

    public static enum AudioLoopBackStartErrorCode {
        AUDIO_RECORD_START_EXCEPTION,
        AUDIO_RECORD_START_STATE_MISMATCH;

    }
}

