/*
 * Decompiled with CFR 0.152.
 */
package com.netease.lava.webrtc.voiceengine;

import android.media.AudioRecord;
import android.media.AudioTimestamp;
import android.os.Build;
import android.os.Process;
import android.util.Log;
import com.netease.lava.webrtc.Logging;
import com.netease.lava.webrtc.ThreadUtils;
import com.netease.lava.webrtc.voiceengine.WebRtcAudioEffects;
import com.netease.lava.webrtc.voiceengine.WebRtcAudioUtils;
import java.nio.ByteBuffer;
import java.util.Arrays;
import javax.annotation.Nullable;

public class WebRtcAudioRecord {
    private static final boolean DEBUG = false;
    private static final String TAG = "WebRtcAudioRecord";
    private static final int BITS_PER_SAMPLE = 16;
    private static final int CALLBACK_BUFFER_SIZE_MS = 10;
    private static final int BUFFERS_PER_SECOND = 100;
    private static final int BUFFER_SIZE_FACTOR = 2;
    private static final int MAX_MINIBUFFER_SIZE_MS = 50;
    private static final long AUDIO_RECORD_THREAD_JOIN_TIMEOUT_MS = 2000L;
    private static final int DEFAULT_AUDIO_SOURCE;
    private static int audioSource;
    private final long nativeAudioRecord;
    @Nullable
    private WebRtcAudioEffects effects;
    private ByteBuffer byteBuffer;
    @Nullable
    private AudioRecord audioRecord;
    @Nullable
    private AudioRecordThread audioThread;
    private boolean microphoneMute;
    private byte[] emptyBytes;
    @Nullable
    private static WebRtcAudioRecordStateCallback stateCallback;
    @Nullable
    private static WebRtcAudioRecordSamplesReadyCallback audioSamplesReadyCallback;

    public static void setStateCallback(WebRtcAudioRecordStateCallback stateCallback) {
        Logging.d(TAG, "Set state callback");
        WebRtcAudioRecord.stateCallback = stateCallback;
    }

    public static void setOnAudioSamplesReady(WebRtcAudioRecordSamplesReadyCallback callback) {
        audioSamplesReadyCallback = callback;
    }

    WebRtcAudioRecord(long nativeAudioRecord) {
        Logging.d(TAG, "ctor" + WebRtcAudioUtils.getThreadInfo());
        this.nativeAudioRecord = nativeAudioRecord;
        this.effects = WebRtcAudioEffects.create();
    }

    private boolean enableBuiltInAEC(boolean enable) {
        Logging.d(TAG, "enableBuiltInAEC(" + enable + ')');
        if (this.effects == null) {
            Logging.e(TAG, "Built-in AEC is not supported on this platform");
            return false;
        }
        return this.effects.setAEC(enable);
    }

    private boolean enableBuiltInNS(boolean enable) {
        Logging.d(TAG, "enableBuiltInNS(" + enable + ')');
        if (this.effects == null) {
            Logging.e(TAG, "Built-in NS is not supported on this platform");
            return false;
        }
        return this.effects.setNS(enable);
    }

    private void setCompatAudioSource(int source) {
        Logging.w(TAG, "Audio source is compat from: " + audioSource + " to " + source);
        audioSource = source;
    }

    private int initRecording(int sampleRate, int channels, boolean lowPerfDevices) {
        Logging.d(TAG, "initRecording(sampleRate=" + sampleRate + ", channels=" + channels + ")");
        try {
            if (this.audioRecord != null) {
                this.reportWebRtcAudioRecordInitError("InitRecording called twice without StopRecording. sate : " + this.audioRecord.getState() + " , record state :" + this.audioRecord.getRecordingState());
                this.stopRecording();
                if (this.audioRecord != null) {
                    return WebRtcAudioUtils.ERR_ADM_ANDROID_INIT_RECORD_FAILED;
                }
            }
            int bytesPerFrame = channels * 2;
            int framesPerBuffer = sampleRate / 100;
            this.byteBuffer = ByteBuffer.allocateDirect(bytesPerFrame * framesPerBuffer);
            Logging.d(TAG, "byteBuffer.capacity: " + this.byteBuffer.capacity());
            this.emptyBytes = new byte[this.byteBuffer.capacity()];
            this.nativeCacheDirectBufferAddress(this.byteBuffer, this.nativeAudioRecord);
            int channelConfig = this.channelCountToConfiguration(channels);
            int minBufferSize = AudioRecord.getMinBufferSize((int)sampleRate, (int)channelConfig, (int)2);
            if (minBufferSize == -1 || minBufferSize == -2) {
                this.reportWebRtcAudioRecordInitError("AudioRecord.getMinBufferSize failed: " + minBufferSize);
                return WebRtcAudioUtils.ERR_ADM_ANDROID_INIT_RECORD_ILLG_ARG;
            }
            if (lowPerfDevices) {
                if (minBufferSize < this.byteBuffer.capacity()) {
                    minBufferSize = this.byteBuffer.capacity();
                }
                if (minBufferSize < 50 * (sampleRate / 1000) * 2 * channels) {
                    minBufferSize = 50 * (sampleRate / 1000) * 2 * channels;
                }
            }
            Logging.d(TAG, "AudioRecord.getMinBufferSize:" + minBufferSize + ", compat audio_source_: " + audioSource);
            int bufferSizeInBytes = Math.max(2 * minBufferSize, this.byteBuffer.capacity());
            Logging.d(TAG, "bufferSizeInBytes: " + bufferSizeInBytes);
            try {
                this.audioRecord = new AudioRecord(audioSource, sampleRate, channelConfig, 2, bufferSizeInBytes);
            }
            catch (IllegalArgumentException e) {
                this.reportWebRtcAudioRecordInitError("AudioRecord ctor error: " + Log.getStackTraceString((Throwable)e));
                this.releaseAudioResources();
                return WebRtcAudioUtils.ERR_ADM_ANDROID_INIT_RECORD_ILLG_ARG;
            }
            if (this.audioRecord == null || this.audioRecord.getState() != 1) {
                this.reportWebRtcAudioRecordInitError("Failed to create a new AudioRecord instance , state : " + this.audioRecord.getState() + " , record state :" + this.audioRecord.getRecordingState());
                this.releaseAudioResources();
                return WebRtcAudioUtils.ERR_ADM_ANDROID_INIT_RECORD_ILLG_STATE;
            }
            if (this.effects != null) {
                this.effects.enable(this.audioRecord.getAudioSessionId());
            }
            this.logMainParameters();
            this.logMainParametersExtended();
            return framesPerBuffer;
        }
        catch (NullPointerException e) {
            e.printStackTrace();
            return WebRtcAudioUtils.ERR_ADM_ANDROID_INIT_RECORD_NULLPTR;
        }
        catch (Exception e) {
            e.printStackTrace();
            return WebRtcAudioUtils.ERR_ADM_ANDROID_INIT_RECORD_UNKNOWN_EXP;
        }
    }

    private int startRecording() {
        Logging.d(TAG, "startRecording");
        try {
            if (this.audioRecord == null || this.audioThread != null) {
                this.reportWebRtcAudioRecordStartError(AudioRecordStartErrorCode.AUDIO_RECORD_START_EXCEPTION, "AudioRecord.startRecording failed , record: " + this.audioRecord + ", thread:" + this.audioThread);
                return WebRtcAudioUtils.ERR_ADM_ANDROID_START_RECORD_ILLG_STATE;
            }
            try {
                this.audioRecord.startRecording();
            }
            catch (IllegalStateException e) {
                this.reportWebRtcAudioRecordStartError(AudioRecordStartErrorCode.AUDIO_RECORD_START_EXCEPTION, "AudioRecord.startRecording failed: " + Log.getStackTraceString((Throwable)e));
                return WebRtcAudioUtils.ERR_ADM_ANDROID_START_RECORD_ILLG_STATE;
            }
            if (this.audioRecord.getRecordingState() != 3) {
                this.reportWebRtcAudioRecordStartError(AudioRecordStartErrorCode.AUDIO_RECORD_START_STATE_MISMATCH, "AudioRecord.startRecording failed - incorrect state :" + this.audioRecord.getRecordingState());
                return WebRtcAudioUtils.ERR_ADM_ANDROID_NO_PERMISSION;
            }
            this.audioThread = new AudioRecordThread("AudioRecordJavaThread");
            this.audioThread.start();
            return 0;
        }
        catch (NullPointerException e) {
            e.printStackTrace();
            return WebRtcAudioUtils.ERR_ADM_ANDROID_START_RECORD_NULLPTR;
        }
        catch (Exception e) {
            e.printStackTrace();
            return WebRtcAudioUtils.ERR_ADM_START_RECORD_UNKNOWN_EXP;
        }
    }

    private int stopRecording() {
        if (this.audioThread == null && this.audioRecord == null) {
            return 0;
        }
        try {
            Logging.d(TAG, "stopRecording");
            if (this.audioThread != null) {
                this.audioThread.stopThread();
                if (!ThreadUtils.joinUninterruptibly(this.audioThread, 2000L)) {
                    Logging.e(TAG, "Join of AudioRecordJavaThread timed out");
                    WebRtcAudioUtils.logAudioState(TAG);
                }
                this.audioThread = null;
            } else {
                Logging.w(TAG, "stopRecording but audioThread is null");
            }
            if (this.effects != null) {
                this.effects.release();
            }
            this.releaseAudioResources();
            return 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            return WebRtcAudioUtils.ERR_ADM_ANDROID_RELEASE_RECORD_RES;
        }
    }

    private void logMainParameters() {
        Logging.d(TAG, "AudioRecord: session ID: " + this.audioRecord.getAudioSessionId() + ", channels: " + this.audioRecord.getChannelCount() + ", sample rate: " + this.audioRecord.getSampleRate());
    }

    private void logMainParametersExtended() {
        if (Build.VERSION.SDK_INT >= 23) {
            Logging.d(TAG, "AudioRecord: buffer size in frames: " + this.audioRecord.getBufferSizeInFrames());
        }
    }

    private int channelCountToConfiguration(int channels) {
        return channels == 1 ? 16 : 12;
    }

    private native void nativeCacheDirectBufferAddress(ByteBuffer var1, long var2);

    private native void nativeDataIsRecorded(int var1, long var2, int var4);

    public static synchronized void setAudioSource(int source) {
        Logging.w(TAG, "Audio source is changed from: " + audioSource + " to " + source);
        audioSource = source;
    }

    private static int getDefaultAudioSource() {
        return 7;
    }

    private void setMicrophoneMuteInternal(boolean mute) {
        Logging.w(TAG, "setMicrophoneMuteInternal(" + mute + ")");
        this.microphoneMute = mute;
    }

    private boolean isMicrophoneMuteInternal() {
        return this.microphoneMute;
    }

    private void releaseAudioResources() {
        Logging.d(TAG, "releaseAudioResources");
        if (this.audioRecord != null) {
            this.audioRecord.release();
            this.audioRecord = null;
        }
    }

    private void reportWebRtcAudioRecordInitError(String errorMessage) {
        Logging.e(TAG, "Init recording error: " + errorMessage);
        WebRtcAudioUtils.logAudioState(TAG);
        if (stateCallback != null) {
            stateCallback.onWebRtcAudioRecordInitError(errorMessage);
        }
    }

    private void reportWebRtcAudioRecordStartError(AudioRecordStartErrorCode errorCode, String errorMessage) {
        Logging.e(TAG, "Start recording error: " + (Object)((Object)errorCode) + ". " + errorMessage);
        WebRtcAudioUtils.logAudioState(TAG);
        if (stateCallback != null) {
            stateCallback.onWebRtcAudioRecordStartError(errorCode, errorMessage);
        }
    }

    private void reportWebRtcAudioRecordError(String errorMessage) {
        Logging.e(TAG, "Run-time recording error: " + errorMessage);
        WebRtcAudioUtils.logAudioState(TAG);
        if (stateCallback != null) {
            stateCallback.onWebRtcAudioRecordError(errorMessage);
        }
    }

    private void reportWebRtcAudioRecordOpened() {
        Logging.d(TAG, "opened");
        if (stateCallback != null) {
            stateCallback.onWebRtcAudioRecordOpened();
        }
    }

    private void reportWebRtcAudioRecordClosed() {
        Logging.d(TAG, "closed");
        if (stateCallback != null) {
            stateCallback.onWebRtcAudioRecordClosed();
        }
    }

    static {
        audioSource = DEFAULT_AUDIO_SOURCE = WebRtcAudioRecord.getDefaultAudioSource();
    }

    private class AudioRecordThread
    extends Thread {
        private volatile boolean keepAlive;
        private long _recDelay;
        private long _lastRecDelay;
        private long _recStartTS;
        private int _recStartDelay;

        public AudioRecordThread(String name) {
            super(name);
            this.keepAlive = true;
            this.reset();
        }

        public void reset() {
            this._lastRecDelay = 0L;
            this._recStartTS = System.nanoTime();
            this._recStartDelay = 0;
            this._recDelay = 10L;
        }

        @Override
        public void run() {
            Process.setThreadPriority((int)-19);
            Logging.d(WebRtcAudioRecord.TAG, "AudioRecordThread" + WebRtcAudioUtils.getThreadInfo());
            if (WebRtcAudioRecord.this.audioRecord.getRecordingState() != 3) {
                String errorMessage = "AudioRecord is not recording state , " + WebRtcAudioRecord.this.audioRecord.getRecordingState();
                Logging.e(WebRtcAudioRecord.TAG, errorMessage);
                WebRtcAudioRecord.this.reportWebRtcAudioRecordStartError(AudioRecordStartErrorCode.AUDIO_RECORD_START_STATE_MISMATCH, errorMessage);
                return;
            }
            try {
                long lastTime = System.nanoTime();
                WebRtcAudioRecord.this.reportWebRtcAudioRecordOpened();
                while (this.keepAlive) {
                    int bytesRead = WebRtcAudioRecord.this.audioRecord.read(WebRtcAudioRecord.this.byteBuffer, WebRtcAudioRecord.this.byteBuffer.capacity());
                    if (bytesRead == WebRtcAudioRecord.this.byteBuffer.capacity()) {
                        if (WebRtcAudioRecord.this.microphoneMute) {
                            WebRtcAudioRecord.this.byteBuffer.clear();
                            WebRtcAudioRecord.this.byteBuffer.put(WebRtcAudioRecord.this.emptyBytes);
                        }
                        if (this._recDelay == 10L) {
                            if (Build.VERSION.SDK_INT >= 24) {
                                AudioTimestamp ts = new AudioTimestamp();
                                WebRtcAudioRecord.this.audioRecord.getTimestamp(ts, 0);
                                this._recDelay = (System.nanoTime() - ts.nanoTime) / 1000L / 1000L;
                                if (this._recDelay > 50L) {
                                    this._recDelay = 10L;
                                }
                            } else {
                                this._recDelay = 10L;
                            }
                        }
                        if (this._lastRecDelay != this._recDelay || this._recDelay == 0L) {
                            if (Build.VERSION.SDK_INT >= 23) {
                                int frames = WebRtcAudioRecord.this.audioRecord.getBufferSizeInFrames();
                                Logging.d(WebRtcAudioRecord.TAG, "frames: " + frames + ", recDelay: " + this._recDelay + ", caculated frames delay: " + frames / (WebRtcAudioRecord.this.audioRecord.getSampleRate() / 1000));
                                this._recDelay += (long)(frames / (WebRtcAudioRecord.this.audioRecord.getSampleRate() / 1000));
                            } else {
                                if (this._recStartDelay == 0) {
                                    this._recStartDelay = (int)(System.nanoTime() - this._recStartTS) / 1000 / 1000;
                                }
                                this._recDelay += (long)this._recStartDelay;
                                Logging.d(WebRtcAudioRecord.TAG, "_recDelay: " + this._recDelay);
                            }
                            this._lastRecDelay = this._recDelay;
                        }
                        if (this.keepAlive) {
                            WebRtcAudioRecord.this.nativeDataIsRecorded(bytesRead, WebRtcAudioRecord.this.nativeAudioRecord, (int)this._recDelay);
                        }
                        if (audioSamplesReadyCallback == null) continue;
                        byte[] data = Arrays.copyOf(WebRtcAudioRecord.this.byteBuffer.array(), WebRtcAudioRecord.this.byteBuffer.capacity());
                        audioSamplesReadyCallback.onWebRtcAudioRecordSamplesReady(new AudioSamples(WebRtcAudioRecord.this.audioRecord, data));
                        continue;
                    }
                    String errorMessage = "AudioRecord.read failed: " + bytesRead;
                    if (WebRtcAudioRecord.this.audioRecord != null) {
                        errorMessage = errorMessage + " , state: " + WebRtcAudioRecord.this.audioRecord.getState() + ", record state" + WebRtcAudioRecord.this.audioRecord.getRecordingState();
                    }
                    Logging.e(WebRtcAudioRecord.TAG, errorMessage);
                    if (bytesRead != -3) continue;
                    this.keepAlive = false;
                    WebRtcAudioRecord.this.reportWebRtcAudioRecordError(errorMessage);
                }
                try {
                    if (WebRtcAudioRecord.this.audioRecord != null) {
                        WebRtcAudioRecord.this.audioRecord.stop();
                    }
                }
                catch (IllegalStateException e) {
                    Logging.e(WebRtcAudioRecord.TAG, "AudioRecord.stop failed: " + e.getMessage());
                }
                WebRtcAudioRecord.this.reportWebRtcAudioRecordClosed();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void stopThread() {
            Logging.d(WebRtcAudioRecord.TAG, "stopThread");
            this.keepAlive = false;
        }
    }

    public static interface WebRtcAudioRecordSamplesReadyCallback {
        public void onWebRtcAudioRecordSamplesReady(AudioSamples var1);
    }

    public static class AudioSamples {
        private final int audioFormat;
        private final int channelCount;
        private final int sampleRate;
        private final byte[] data;

        private AudioSamples(AudioRecord audioRecord, byte[] data) {
            this.audioFormat = audioRecord.getAudioFormat();
            this.channelCount = audioRecord.getChannelCount();
            this.sampleRate = audioRecord.getSampleRate();
            this.data = data;
        }

        public int getAudioFormat() {
            return this.audioFormat;
        }

        public int getChannelCount() {
            return this.channelCount;
        }

        public int getSampleRate() {
            return this.sampleRate;
        }

        public byte[] getData() {
            return this.data;
        }
    }

    public static interface WebRtcAudioRecordStateCallback {
        public void onWebRtcAudioRecordInitError(String var1);

        public void onWebRtcAudioRecordStartError(AudioRecordStartErrorCode var1, String var2);

        public void onWebRtcAudioRecordError(String var1);

        public void onWebRtcAudioRecordOpened();

        public void onWebRtcAudioRecordClosed();
    }

    public static enum AudioRecordStartErrorCode {
        AUDIO_RECORD_START_EXCEPTION,
        AUDIO_RECORD_START_STATE_MISMATCH;

    }
}

