/*
 * Decompiled with CFR 0.152.
 */
package com.netease.lava.webrtc.voiceengine;

import android.annotation.TargetApi;
import android.media.AudioAttributes;
import android.media.AudioFormat;
import android.media.AudioManager;
import android.media.AudioTrack;
import android.os.Build;
import android.os.Process;
import android.os.SystemClock;
import android.util.Log;
import com.netease.lava.webrtc.ContextUtils;
import com.netease.lava.webrtc.Logging;
import com.netease.lava.webrtc.ThreadUtils;
import com.netease.lava.webrtc.voiceengine.WebRtcAudioUtils;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import javax.annotation.Nullable;

public class WebRtcAudioTrack {
    private static final boolean DEBUG = false;
    private static final String TAG = "WebRtcAudioTrack";
    private static final int BITS_PER_SAMPLE = 16;
    private static final int CALLBACK_BUFFER_SIZE_MS = 10;
    private static final int BUFFERS_PER_SECOND = 100;
    private static final long AUDIO_TRACK_THREAD_JOIN_TIMEOUT_MS = 2000L;
    private static final int MAX_MINIBUFFER_SIZE_MS = 50;
    private static final int DEFAULT_USAGE;
    private static int usageAttribute;
    private static int stream_type;
    private static int audioLatencyMs;
    private final long nativeAudioTrack;
    private final AudioManager audioManager;
    private final ThreadUtils.ThreadChecker threadChecker = new ThreadUtils.ThreadChecker();
    private ByteBuffer byteBuffer;
    @Nullable
    private AudioTrack audioTrack;
    @Nullable
    private AudioTrackThread audioThread;
    private boolean speakerMute;
    private byte[] emptyBytes;
    @Nullable
    private static WebRtcAudioTrackStateCallback stateCallback;

    public static synchronized void setAudioTrackUsageAttribute(int usage) {
        Logging.w(TAG, "Default usage attribute is changed from: " + DEFAULT_USAGE + " to " + usage);
        usageAttribute = usage;
    }

    private static int getDefaultUsageAttribute() {
        if (Build.VERSION.SDK_INT >= 21) {
            return 2;
        }
        return 0;
    }

    public static void setStateCallback(WebRtcAudioTrackStateCallback stateCallback) {
        Logging.d(TAG, "Set extended state callback");
        WebRtcAudioTrack.stateCallback = stateCallback;
    }

    WebRtcAudioTrack(long nativeAudioTrack) {
        this.threadChecker.checkIsOnValidThread();
        Logging.d(TAG, "ctor" + WebRtcAudioUtils.getThreadInfo());
        this.nativeAudioTrack = nativeAudioTrack;
        this.audioManager = (AudioManager)ContextUtils.getApplicationContext().getSystemService("audio");
    }

    private void setCompatStreamType(int type) {
        Logging.d(TAG, "setCompatStreamType type: " + type);
        stream_type = type;
    }

    private int initPlayout(int sampleRate, int channels) {
        return this.initPlayout(sampleRate, channels, false);
    }

    private int initPlayout(int sampleRate, int channels, boolean lowPerfDevices) {
        this.threadChecker.checkIsOnValidThread();
        try {
            Logging.d(TAG, "initPlayout(sampleRate=" + sampleRate + ", channels=" + channels + ")");
            int bytesPerFrame = channels * 2;
            this.byteBuffer = ByteBuffer.allocateDirect(bytesPerFrame * (sampleRate / 100));
            Logging.d(TAG, "byteBuffer.capacity: " + this.byteBuffer.capacity());
            this.emptyBytes = new byte[this.byteBuffer.capacity()];
            this.nativeCacheDirectBufferAddress(this.byteBuffer, this.nativeAudioTrack);
            int channelConfig = this.channelCountToConfiguration(channels);
            int minBufferSizeInBytes = AudioTrack.getMinBufferSize((int)sampleRate, (int)channelConfig, (int)2);
            Logging.d(TAG, "AudioTrack.getMinBufferSize: " + minBufferSizeInBytes);
            if (lowPerfDevices) {
                if (minBufferSizeInBytes < this.byteBuffer.capacity()) {
                    minBufferSizeInBytes = this.byteBuffer.capacity();
                }
                if (minBufferSizeInBytes < 50 * (sampleRate / 1000) * 2 * channels) {
                    minBufferSizeInBytes = 50 * (sampleRate / 1000) * 2 * channels;
                }
            }
            if (minBufferSizeInBytes < this.byteBuffer.capacity()) {
                this.reportWebRtcAudioTrackInitError("AudioTrack.getMinBufferSize returns an invalid value. min : " + minBufferSizeInBytes + ", capacity: " + this.byteBuffer.capacity());
                return WebRtcAudioUtils.ERR_ADM_ANDROID_INIT_PLAY_ILLG_ARG;
            }
            Logging.d(TAG, "AudioTrack set minBufferSizeInBytes: " + minBufferSizeInBytes);
            if (this.audioTrack != null) {
                this.stopPlayout();
            }
            if (this.audioTrack != null) {
                this.reportWebRtcAudioTrackInitError("Conflict with existing AudioTrack. state : " + this.audioTrack.getState() + ", play state:  " + this.audioTrack.getPlayState());
                return WebRtcAudioUtils.ERR_ADM_ANDROID_START_PLAY_ILLG_OBJ;
            }
            try {
                this.audioTrack = Build.VERSION.SDK_INT >= 21 ? WebRtcAudioTrack.createAudioTrackOnLollipopOrHigher(sampleRate, channelConfig, minBufferSizeInBytes) : WebRtcAudioTrack.createAudioTrackOnLowerThanLollipop(sampleRate, channelConfig, minBufferSizeInBytes);
            }
            catch (IllegalArgumentException e) {
                this.reportWebRtcAudioTrackInitError(Log.getStackTraceString((Throwable)e));
                this.releaseAudioResources();
                return WebRtcAudioUtils.ERR_ADM_ANDROID_INIT_PLAY_ILLG_ARG;
            }
            if (this.audioTrack == null || this.audioTrack.getState() != 1) {
                this.reportWebRtcAudioTrackInitError("Initialization of audio track failed. state" + this.audioTrack.getState() + ", play state:  " + this.audioTrack.getPlayState());
                this.releaseAudioResources();
                return WebRtcAudioUtils.ERR_ADM_ANDROID_INIT_PLAY_ILLG_STATE;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return WebRtcAudioUtils.ERR_ADM_ANDROID_INIT_PLAY_UNKNOWN_EXP;
        }
        this.logMainParameters();
        this.logMainParametersExtended();
        return 0;
    }

    private int startPlayout() {
        long startTime = 0L;
        long setModeTime = 0L;
        long playTime = 0L;
        try {
            this.threadChecker.checkIsOnValidThread();
            Logging.d(TAG, "startPlayout");
            startTime = SystemClock.elapsedRealtime();
            if (this.audioTrack == null || this.audioThread != null) {
                Logging.w(TAG, "startPlayout , but state error audioTrack: " + this.audioTrack + " , audioThread: " + this.audioThread);
                return WebRtcAudioUtils.ERR_ADM_ANDROID_START_PLAY_ILLG_STATE;
            }
            if (stream_type == 0) {
                this.audioManager.setMode(3);
            } else {
                this.audioManager.setMode(0);
            }
            setModeTime = SystemClock.elapsedRealtime();
            this.audioTrack.play();
        }
        catch (Throwable e) {
            this.reportWebRtcAudioTrackStartError(AudioTrackStartErrorCode.AUDIO_TRACK_START_EXCEPTION, "AudioTrack.play failed: " + Log.getStackTraceString((Throwable)e));
            this.releaseAudioResources();
            e.printStackTrace();
            return WebRtcAudioUtils.ERR_ADM_ANDROID_START_PLAY_ILLG_ARG;
        }
        playTime = SystemClock.elapsedRealtime();
        if (this.audioTrack.getPlayState() != 3) {
            this.reportWebRtcAudioTrackStartError(AudioTrackStartErrorCode.AUDIO_TRACK_START_STATE_MISMATCH, "AudioTrack.play failed - incorrect state: " + this.audioTrack.getState() + " , play state: " + this.audioTrack.getPlayState());
            this.releaseAudioResources();
            return WebRtcAudioUtils.ERR_ADM_ANDROID_START_PLAY_ILLG_STATE;
        }
        this.audioThread = new AudioTrackThread("AudioTrackJavaThread");
        this.audioThread.reset();
        this.audioThread.start();
        long threadStartTime = SystemClock.elapsedRealtime();
        Logging.d(TAG, "startPlayOut end  : set mode cost: " + (setModeTime - startTime) + " , start play cost: " + (playTime - setModeTime) + " , thread start cost: " + (threadStartTime - playTime));
        return 0;
    }

    private int stopPlayout() {
        this.threadChecker.checkIsOnValidThread();
        Logging.d(TAG, "stopPlayout");
        if (this.audioThread == null) {
            Logging.w(TAG, "stopPlayout but audioThread is null");
            return 0;
        }
        this.logUnderrunCount();
        this.audioThread.stopThread();
        Logging.d(TAG, "Stopping the AudioTrackThread...");
        this.audioThread.interrupt();
        if (!ThreadUtils.joinUninterruptibly(this.audioThread, 2000L)) {
            Logging.e(TAG, "Join of AudioTrackThread timed out.");
            WebRtcAudioUtils.logAudioState(TAG);
        }
        Logging.d(TAG, "AudioTrackThread has now been stopped.");
        this.audioThread = null;
        this.releaseAudioResources();
        return 0;
    }

    private int getStreamMaxVolume() {
        this.threadChecker.checkIsOnValidThread();
        if (this.audioManager == null) {
            return 0;
        }
        return this.audioManager.getStreamMaxVolume(stream_type);
    }

    private boolean setStreamVolume(int volume) {
        this.threadChecker.checkIsOnValidThread();
        Logging.d(TAG, "setStreamVolume(" + volume + ")");
        if (this.audioManager == null) {
            Logging.w(TAG, "setStreamVolume(" + volume + ") , but audioManager is null");
            return false;
        }
        if (this.isVolumeFixed()) {
            Logging.e(TAG, "The device implements a fixed volume policy.");
            return false;
        }
        this.audioManager.setStreamVolume(stream_type, volume, 0);
        return true;
    }

    private boolean isVolumeFixed() {
        if (Build.VERSION.SDK_INT < 21) {
            return false;
        }
        return this.audioManager.isVolumeFixed();
    }

    private int getStreamVolume() {
        this.threadChecker.checkIsOnValidThread();
        Logging.d(TAG, "getStreamVolume");
        if (this.audioManager == null) {
            return 0;
        }
        return this.audioManager.getStreamVolume(stream_type);
    }

    private void logMainParameters() {
        Logging.d(TAG, "AudioTrack: session ID: " + this.audioTrack.getAudioSessionId() + ", channels: " + this.audioTrack.getChannelCount() + ", sample rate: " + this.audioTrack.getSampleRate() + ", max gain: " + AudioTrack.getMaxVolume());
    }

    @TargetApi(value=21)
    private static AudioTrack createAudioTrackOnLollipopOrHigher(int sampleRateInHz, int channelConfig, int bufferSizeInBytes) {
        Logging.d(TAG, "createAudioTrackOnLollipopOrHigher");
        Logging.w(TAG, "createAudioTrack compat stream_type: " + stream_type);
        int nativeOutputSampleRate = AudioTrack.getNativeOutputSampleRate((int)stream_type);
        Logging.d(TAG, "nativeOutputSampleRate: " + nativeOutputSampleRate);
        if (sampleRateInHz != nativeOutputSampleRate) {
            Logging.w(TAG, "Unable to use fast mode since requested sample rate is not native");
        }
        if (usageAttribute != DEFAULT_USAGE) {
            Logging.w(TAG, "A non default usage attribute is used: " + usageAttribute);
        }
        int contentType = 1;
        switch (stream_type) {
            case 0: {
                usageAttribute = 2;
                contentType = 1;
                break;
            }
            case 1: {
                usageAttribute = 13;
                contentType = 4;
                break;
            }
            case 2: {
                usageAttribute = 6;
                contentType = 4;
                break;
            }
            case 3: {
                usageAttribute = 1;
                contentType = 2;
                break;
            }
            case 4: {
                usageAttribute = 4;
                contentType = 4;
                break;
            }
            case 5: {
                usageAttribute = 5;
                contentType = 4;
                break;
            }
        }
        return new AudioTrack(new AudioAttributes.Builder().setUsage(usageAttribute).setContentType(contentType).build(), new AudioFormat.Builder().setEncoding(2).setSampleRate(sampleRateInHz).setChannelMask(channelConfig).build(), bufferSizeInBytes, 1, 0);
    }

    private static AudioTrack createAudioTrackOnLowerThanLollipop(int sampleRateInHz, int channelConfig, int bufferSizeInBytes) {
        Logging.w(TAG, "createAudioTrack stream_type: " + stream_type);
        return new AudioTrack(stream_type, sampleRateInHz, channelConfig, 2, bufferSizeInBytes, 1);
    }

    private void logBufferSizeInFrames() {
        if (Build.VERSION.SDK_INT >= 23) {
            Logging.d(TAG, "AudioTrack: buffer size in frames: " + this.audioTrack.getBufferSizeInFrames());
        }
    }

    private void logBufferCapacityInFrames() {
        if (Build.VERSION.SDK_INT >= 24) {
            Logging.d(TAG, "AudioTrack: buffer capacity in frames: " + this.audioTrack.getBufferCapacityInFrames());
        }
    }

    private void logMainParametersExtended() {
        this.logBufferSizeInFrames();
        this.logBufferCapacityInFrames();
    }

    private void logUnderrunCount() {
        if (Build.VERSION.SDK_INT >= 24) {
            Logging.d(TAG, "underrun count: " + this.audioTrack.getUnderrunCount());
        }
    }

    private int channelCountToConfiguration(int channels) {
        return channels == 1 ? 4 : 12;
    }

    private native void nativeCacheDirectBufferAddress(ByteBuffer var1, long var2);

    private native void nativeGetPlayoutData(int var1, long var2, int var4);

    private void setSpeakerMuteInternal(boolean mute) {
        Logging.w(TAG, "setSpeakerMuteInternal(" + mute + ")");
        this.speakerMute = mute;
    }

    private boolean isSpeakerMuteInternal() {
        return this.speakerMute;
    }

    private void releaseAudioResources() {
        Logging.d(TAG, "releaseAudioResources");
        if (this.audioTrack != null) {
            this.audioTrack.release();
            this.audioTrack = null;
        }
    }

    private void reportWebRtcAudioTrackInitError(String errorMessage) {
        Logging.e(TAG, "Init playout error: " + errorMessage);
        WebRtcAudioUtils.logAudioState(TAG);
        if (stateCallback != null) {
            stateCallback.onWebRtcAudioTrackInitError(errorMessage);
        }
    }

    private void reportWebRtcAudioTrackStartError(AudioTrackStartErrorCode errorCode, String errorMessage) {
        Logging.e(TAG, "Start playout error: " + (Object)((Object)errorCode) + ". " + errorMessage);
        WebRtcAudioUtils.logAudioState(TAG);
        if (stateCallback != null) {
            stateCallback.onWebRtcAudioTrackStartError(errorCode, errorMessage);
        }
    }

    private void reportWebRtcAudioTrackError(String errorMessage) {
        Logging.e(TAG, "Run-time playback error: " + errorMessage);
        WebRtcAudioUtils.logAudioState(TAG);
        if (stateCallback != null) {
            stateCallback.onWebRtcAudioTrackError(errorMessage);
        }
    }

    private void reportWebRtcAudioTrackOpened() {
        Logging.d(TAG, "opened");
        if (stateCallback != null) {
            stateCallback.onWebRtcAudioTrackOpened();
        }
    }

    private void reportWebRtcAudioTrackClosed() {
        Logging.d(TAG, "closed");
        if (stateCallback != null) {
            stateCallback.onWebRtcAudioTrackClosed();
        }
    }

    static {
        usageAttribute = DEFAULT_USAGE = WebRtcAudioTrack.getDefaultUsageAttribute();
        stream_type = 0;
    }

    private class AudioTrackThread
    extends Thread {
        private volatile boolean keepAlive;
        private boolean _renderStart;
        private long _firstRenderTS;
        private int _playWritenBytes;
        private int _maxDelay;
        private int _totalDelay;
        private int _playPosition;
        private int frameCount;

        public AudioTrackThread(String name) {
            super(name);
            this.keepAlive = true;
            this.reset();
        }

        public void reset() {
            this._firstRenderTS = 0L;
            this._playWritenBytes = 0;
            this._maxDelay = 0;
            this._totalDelay = 0;
            this._playPosition = 0;
            this._renderStart = false;
            this.frameCount = 0;
        }

        @Override
        public void run() {
            Process.setThreadPriority((int)-19);
            Logging.d(WebRtcAudioTrack.TAG, "AudioTrackThread" + WebRtcAudioUtils.getThreadInfo());
            if (WebRtcAudioTrack.this.audioTrack == null || WebRtcAudioTrack.this.audioTrack.getPlayState() != 3) {
                Logging.e(WebRtcAudioTrack.TAG, "AudioTrackThread run , but audioTrack is null or not playing , audioTrack: " + WebRtcAudioTrack.this.audioTrack);
                return;
            }
            int sizeInBytes = WebRtcAudioTrack.this.byteBuffer.capacity();
            WebRtcAudioTrack.this.reportWebRtcAudioTrackOpened();
            while (this.keepAlive) {
                int bytesWritten;
                WebRtcAudioTrack.this.nativeGetPlayoutData(sizeInBytes, WebRtcAudioTrack.this.nativeAudioTrack, this._totalDelay);
                if (WebRtcAudioTrack.this.speakerMute) {
                    WebRtcAudioTrack.this.byteBuffer.clear();
                    WebRtcAudioTrack.this.byteBuffer.put(WebRtcAudioTrack.this.emptyBytes);
                    WebRtcAudioTrack.this.byteBuffer.position(0);
                }
                if ((bytesWritten = this.writeBytes(WebRtcAudioTrack.this.audioTrack, WebRtcAudioTrack.this.byteBuffer, sizeInBytes)) != sizeInBytes) {
                    Logging.e(WebRtcAudioTrack.TAG, "AudioTrack.write played invalid number of bytes: " + bytesWritten);
                    if (bytesWritten < 0) {
                        this.keepAlive = false;
                        AudioTrack tempAudioTrack = WebRtcAudioTrack.this.audioTrack;
                        String stateMsg = tempAudioTrack != null ? " , state: " + tempAudioTrack.getState() + " , play state : " + tempAudioTrack.getPlayState() : "";
                        WebRtcAudioTrack.this.reportWebRtcAudioTrackError("AudioTrack.write failed: write : " + bytesWritten + ", sizeInBytes : " + sizeInBytes + stateMsg);
                    }
                }
                if (bytesWritten > 0) {
                    this._playWritenBytes += bytesWritten;
                }
                if (WebRtcAudioTrack.this.audioTrack == null) {
                    Logging.w(WebRtcAudioTrack.TAG, "AudioTrack release timeout , keepAlive: " + this.keepAlive);
                    return;
                }
                if (this.frameCount == 200) {
                    if (Build.VERSION.SDK_INT >= 18) {
                        try {
                            Method getLatencyMethod = AudioTrack.class.getMethod("getLatency", null);
                            audioLatencyMs = (Integer)getLatencyMethod.invoke((Object)WebRtcAudioTrack.this.audioTrack, (Object[])null);
                        }
                        catch (Exception stateMsg) {
                            // empty catch block
                        }
                        this._totalDelay = audioLatencyMs;
                    } else {
                        int pos = WebRtcAudioTrack.this.audioTrack.getPlaybackHeadPosition() * WebRtcAudioTrack.this.audioTrack.getChannelCount();
                        int delay = (this._playWritenBytes / 2 - pos) / 2 / (WebRtcAudioTrack.this.audioTrack.getSampleRate() / 1000);
                        int n = this._maxDelay = delay > this._maxDelay ? delay : this._maxDelay;
                        if (this._firstRenderTS == 0L) {
                            this._firstRenderTS = System.currentTimeMillis();
                        }
                        if (pos > 0 && !this._renderStart) {
                            this._firstRenderTS = System.currentTimeMillis() - this._firstRenderTS;
                            this._renderStart = true;
                        }
                        if (this._renderStart) {
                            this._totalDelay = (int)this._firstRenderTS + this._maxDelay;
                        }
                    }
                    this.frameCount = 0;
                }
                ++this.frameCount;
                WebRtcAudioTrack.this.byteBuffer.rewind();
            }
            if (WebRtcAudioTrack.this.audioTrack != null) {
                Logging.d(WebRtcAudioTrack.TAG, "Calling AudioTrack.stop...");
                try {
                    WebRtcAudioTrack.this.audioTrack.stop();
                    Logging.d(WebRtcAudioTrack.TAG, "AudioTrack.stop is done.");
                }
                catch (Throwable e) {
                    Logging.e(WebRtcAudioTrack.TAG, "AudioTrack.stop failed: " + e.getMessage());
                }
                WebRtcAudioTrack.this.reportWebRtcAudioTrackClosed();
            }
        }

        private int writeBytes(AudioTrack audioTrack, ByteBuffer byteBuffer, int sizeInBytes) {
            if (Build.VERSION.SDK_INT >= 21) {
                return audioTrack.write(byteBuffer, sizeInBytes, 0);
            }
            return audioTrack.write(byteBuffer.array(), byteBuffer.arrayOffset(), sizeInBytes);
        }

        public void stopThread() {
            Logging.d(WebRtcAudioTrack.TAG, "stopThread");
            this.keepAlive = false;
        }
    }

    public static interface WebRtcAudioTrackStateCallback {
        public void onWebRtcAudioTrackInitError(String var1);

        public void onWebRtcAudioTrackStartError(AudioTrackStartErrorCode var1, String var2);

        public void onWebRtcAudioTrackError(String var1);

        public void onWebRtcAudioTrackOpened();

        public void onWebRtcAudioTrackClosed();
    }

    public static enum AudioTrackStartErrorCode {
        AUDIO_TRACK_START_EXCEPTION,
        AUDIO_TRACK_START_STATE_MISMATCH;

    }
}

