/*
 * Decompiled with CFR 0.152.
 */
package com.netease.yunxin.lite;

import com.netease.lava.webrtc.CalledByNative;
import com.netease.lava.webrtc.Logging;
import com.netease.yunxin.lite.annotation.Keep;
import com.netease.yunxin.lite.util.ContextUtils;
import com.netease.yunxin.lite.util.catcher.sdk.YXCatcher;
import com.netease.yunxin.lite.util.catcher.sdk.YXCatcherComponent;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;

@Keep
public class LiteCrashCatcher
implements YXCatcherComponent.CrashCallback {
    private static final String SDK_TYPE = "nrtc2";
    private static final String TAG = "NERtcCrashHandler";
    private final long mNativeHandler;

    private LiteCrashCatcher(long nativeHandler) {
        this.mNativeHandler = nativeHandler;
    }

    @CalledByNative
    private static void setUp(long nativeHandler, String logDirectory) {
        Logging.i(TAG, "setUp");
        ArrayList<String> crashTags = new ArrayList<String>();
        crashTags.add("com.netease.yunxin.nertc.ui");
        crashTags.add("com.netease.yunxin.kit.call");
        crashTags.add("com.netease.yunxin.nertc.nertcvideocall");
        crashTags.add("com.netease.lava.nertc");
        crashTags.add("com.netease.yunxin.lite");
        crashTags.add("com.netease.lava.webrtc");
        YXCatcherComponent component = new YXCatcherComponent.Builder(ContextUtils.getContext(), SDK_TYPE, crashTags, new LiteCrashCatcher(nativeHandler)).logDir(logDirectory).build();
        YXCatcher.setup(SDK_TYPE, component);
    }

    @CalledByNative
    private static void release() {
        Logging.i(TAG, "release");
        YXCatcher.release(SDK_TYPE);
    }

    @CalledByNative
    private static void processJNIException(String stackTrace) {
        YXCatcher.processJNIException(SDK_TYPE, stackTrace);
    }

    @Override
    public void onCrash(String md5, File crashLogFile, String sdkLogDir, long crashTime, HashMap<String, String> extraHeader, boolean isOldCrash) {
        Logging.d(TAG, "onCrash, md5:" + md5 + ", crashLogFile:" + crashLogFile + ", sdkLogDir:" + sdkLogDir);
        this.onCrash(this.mNativeHandler, md5, crashLogFile.getAbsolutePath(), sdkLogDir, crashTime);
    }

    private native void onCrash(long var1, String var3, String var4, String var5, long var6);
}

