/*
 * Decompiled with CFR 0.152.
 */
package com.netease.yunxin.lite.audio;

import android.content.Context;
import android.media.AudioManager;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import com.netease.lava.webrtc.Logging;
import com.netease.yunxin.lite.audio.BluetoothManager;
import com.netease.yunxin.lite.audio.FakeBluetoothManager;
import com.netease.yunxin.lite.audio.LavaAudioDeviceManager;
import com.netease.yunxin.lite.util.SystemPermissionUtils;
import com.netease.yunxin.lite.util.ThreadUtils;

public abstract class AbsBluetoothManager {
    private static final String TAG = "AbsBluetoothManager";
    protected final Context mContext;
    protected final LavaAudioDeviceManager mAudioDeviceManager;
    protected final AudioManager mAudioManager;
    protected final Handler mHandler;
    protected State mBluetoothState;
    protected volatile boolean mBlueToothSCO;

    public static AbsBluetoothManager create(Context context, LavaAudioDeviceManager manager, int bluetoothSCOTimeoutMs) {
        Logging.i(TAG, "create bluetooth manager");
        int targetVersion = context.getApplicationInfo().targetSdkVersion;
        boolean hasBluetoothPermission = SystemPermissionUtils.checkBluetoothScoConnectPermission(context);
        if (!hasBluetoothPermission) {
            Logging.e(TAG, "missing  permission , create FakeBluetoothManager");
            Logging.e(TAG, "has bluetooth permission: " + SystemPermissionUtils.checkBluetoothPermission(context));
            Logging.e(TAG, "has bluetoothConnect permission\uff1a" + SystemPermissionUtils.checkBluetoothConnectPermission(context));
            Logging.e(TAG, "targetVersion\uff1a" + targetVersion + ", sdk int: " + Build.VERSION.SDK_INT);
            return new FakeBluetoothManager(context, manager);
        }
        return new BluetoothManager(context, manager, bluetoothSCOTimeoutMs);
    }

    public AbsBluetoothManager(Context context, LavaAudioDeviceManager manager) {
        ThreadUtils.checkIsOnUiThread();
        this.mContext = context;
        this.mAudioDeviceManager = manager;
        this.mAudioManager = (AudioManager)context.getSystemService("audio");
        this.mHandler = new Handler(Looper.getMainLooper());
        this.mBluetoothState = State.UNINITIALIZED;
    }

    public abstract void start();

    public abstract void stop();

    public abstract void setAudioBlueToothSCO(boolean var1);

    public boolean blueToothIsSCO() {
        return this.mBlueToothSCO;
    }

    public void stopScoAudio() {
    }

    public void updateDevice() {
    }

    public boolean startScoAudio() {
        return true;
    }

    public State getState() {
        return this.mBluetoothState;
    }

    public static enum State {
        UNINITIALIZED,
        HEADSET_UNAVAILABLE,
        HEADSET_AVAILABLE,
        SCO_DISCONNECTING,
        SCO_CONNECTING,
        SCO_CONNECTED;

    }
}

