/*
 * Decompiled with CFR 0.152.
 */
package com.netease.yunxin.lite.audio;

import android.content.Context;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.os.Handler;
import android.os.Message;
import com.netease.lava.webrtc.Logging;
import java.lang.ref.WeakReference;

class AccelerometerListener {
    private static final String TAG = "AccelerometerListener";
    private SensorManager mSensorManager;
    private Sensor mSensor;
    private int mOrientation;
    private int mPendingOrientation;
    private OrientationListener mListener;
    static final int ORIENTATION_UNKNOWN = 0;
    static final int ORIENTATION_VERTICAL = 1;
    static final int ORIENTATION_HORIZONTAL = 2;
    private static final int ORIENTATION_CHANGED = 1234;
    private static final int VERTICAL_DEBOUNCE = 100;
    private static final int HORIZONTAL_DEBOUNCE = 500;
    private static final double VERTICAL_ANGLE = 50.0;
    private SensorEventListener mSensorListener = new SensorEventListener(){

        public void onSensorChanged(SensorEvent event) {
            AccelerometerListener.this.onSensorEvent(event.values[0], event.values[1], event.values[2]);
        }

        public void onAccuracyChanged(Sensor sensor, int accuracy) {
        }
    };
    private Handler mHandler = new AccelerometerHandler(this);

    AccelerometerListener(Context context, OrientationListener listener) {
        Logging.d(TAG, "AccelerometerListener ctor");
        this.mListener = listener;
        this.mSensorManager = (SensorManager)context.getSystemService("sensor");
        if (this.mSensorManager != null) {
            this.mSensor = this.mSensorManager.getDefaultSensor(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enable(boolean enable) {
        Logging.d(TAG, "enable(" + enable + ")");
        AccelerometerListener accelerometerListener = this;
        synchronized (accelerometerListener) {
            if (enable) {
                this.mOrientation = 0;
                this.mPendingOrientation = 0;
                this.mSensorManager.registerListener(this.mSensorListener, this.mSensor, 3);
            } else {
                this.mSensorManager.unregisterListener(this.mSensorListener);
                this.mHandler.removeMessages(1234);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setOrientation(int orientation) {
        AccelerometerListener accelerometerListener = this;
        synchronized (accelerometerListener) {
            if (this.mPendingOrientation == orientation) {
                return;
            }
            this.mHandler.removeMessages(1234);
            if (this.mOrientation != orientation) {
                this.mPendingOrientation = orientation;
                Message m = this.mHandler.obtainMessage(1234);
                int delay = orientation == 1 ? 100 : 500;
                this.mHandler.sendMessageDelayed(m, (long)delay);
            } else {
                this.mPendingOrientation = 0;
            }
        }
    }

    private void onSensorEvent(double x, double y, double z) {
        if (x == 0.0 || y == 0.0 || z == 0.0) {
            return;
        }
        double xy = Math.sqrt(x * x + y * y);
        double angle = Math.atan2(xy, z);
        int orientation = (angle = angle * 180.0 / Math.PI) > 50.0 ? 1 : 2;
        this.setOrientation(orientation);
    }

    private static class AccelerometerHandler
    extends Handler {
        WeakReference<AccelerometerListener> l;
        final Object lock = new Object();

        AccelerometerHandler(AccelerometerListener listener) {
            this.l = new WeakReference<AccelerometerListener>(listener);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleMessage(Message msg) {
            AccelerometerListener listener = (AccelerometerListener)this.l.get();
            if (listener == null) {
                return;
            }
            switch (msg.what) {
                case 1234: {
                    Object object = this.lock;
                    synchronized (object) {
                        listener.mOrientation = listener.mPendingOrientation;
                        Logging.d(AccelerometerListener.TAG, "orientation: " + (listener.mOrientation == 2 ? "horizontal" : (listener.mOrientation == 1 ? "vertical" : "unknown")));
                        listener.mListener.orientationChanged(listener.mOrientation);
                        break;
                    }
                }
            }
        }
    }

    static interface OrientationListener {
        public void orientationChanged(int var1);
    }
}

