/*
 * Decompiled with CFR 0.152.
 */
package com.netease.yunxin.lite.audio;

import com.netease.lava.webrtc.CalledByNative;
import com.netease.yunxin.lite.annotation.Keep;
import com.netease.yunxin.lite.audio.AudioDeviceUtils;
import java.util.HashSet;
import java.util.Set;

@Keep
public class AudioDeviceCompatibility {
    private static final String TAG = "AudioDeviceCompatibility";
    public static int audioSource = 7;
    public static int streamType = 0;
    public static int audioMode = 3;
    private static final Set<AudioDeviceCompatibilityObserver> sCompatibilityObservers = new HashSet<AudioDeviceCompatibilityObserver>();

    public static void addObserver(AudioDeviceCompatibilityObserver observer) {
        sCompatibilityObservers.add(observer);
    }

    public static void removeObserver(AudioDeviceCompatibilityObserver observer) {
        sCompatibilityObservers.remove(observer);
    }

    @CalledByNative
    private static void setAudioSource(int audioSource) {
        if (audioSource != AudioDeviceCompatibility.audioSource) {
            AudioDeviceCompatibility.notifyCompatibilityChange(audioSource, streamType, audioMode);
        }
        AudioDeviceCompatibility.audioSource = audioSource;
    }

    @CalledByNative
    private static void setStreamType(int streamType) {
        if (streamType != AudioDeviceCompatibility.streamType) {
            AudioDeviceCompatibility.notifyCompatibilityChange(audioSource, streamType, audioMode);
        }
        AudioDeviceCompatibility.streamType = streamType;
    }

    @CalledByNative
    private static void setAudioMode(int audioMode) {
        if (audioMode != AudioDeviceCompatibility.audioMode) {
            AudioDeviceCompatibility.notifyCompatibilityChange(audioSource, streamType, audioMode);
        }
        AudioDeviceCompatibility.audioMode = audioMode;
    }

    @CalledByNative
    public static int getAudioSource() {
        return audioSource;
    }

    @CalledByNative
    public static int getStreamType() {
        return streamType;
    }

    @CalledByNative
    public static int getAudioMode() {
        return audioMode;
    }

    public static void notifyCompatibilityChange(int audioSource, int streamType, int audioMode) {
        for (AudioDeviceCompatibilityObserver observer : sCompatibilityObservers) {
            observer.onChanged(audioSource, streamType, audioMode);
        }
        AudioDeviceUtils.logAudioProfile(TAG, audioMode, streamType, audioSource);
    }

    public static interface AudioDeviceCompatibilityObserver {
        public void onChanged(int var1, int var2, int var3);
    }
}

