/*
 * Decompiled with CFR 0.152.
 */
package com.netease.yunxin.lite.audio;

import android.support.annotation.GuardedBy;
import com.netease.lava.webrtc.CalledByNative;
import com.netease.yunxin.lite.audio.LavaAudioDeviceManager;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class AudioDeviceEventListener
implements LavaAudioDeviceManager.AudioManagerEvents {
    private final ReadWriteLock mNativeHandleLock = new ReentrantReadWriteLock();
    private long mNativeHandle = 0L;

    @CalledByNative
    private AudioDeviceEventListener(long nativeHandle) {
        this.mNativeHandle = nativeHandle;
    }

    @Override
    @GuardedBy(value="mNativeHandleLock")
    public void onAudioDeviceChanged(int selectedAudioDevice, Set<Integer> availableAudioDevices, boolean hasExternalMic) {
        this.mNativeHandleLock.readLock().lock();
        this.onAudioDeviceChanged(this.mNativeHandle, selectedAudioDevice, hasExternalMic);
        this.mNativeHandleLock.readLock().unlock();
    }

    @Override
    public void onVolumeChange(int volume, int maxVolume) {
        this.mNativeHandleLock.readLock().lock();
        this.onVolumeChange(this.mNativeHandle, volume, maxVolume);
        this.mNativeHandleLock.readLock().unlock();
    }

    @Override
    public void onAudioModeChange(int mode) {
        this.mNativeHandleLock.readLock().lock();
        this.onAudioModeChange(this.mNativeHandle, mode);
        this.mNativeHandleLock.readLock().unlock();
    }

    @CalledByNative
    private void setNativeHandle(long nativeHandle) {
        this.mNativeHandleLock.writeLock().lock();
        this.mNativeHandle = nativeHandle;
        this.mNativeHandleLock.writeLock().unlock();
    }

    private native void onAudioDeviceChanged(long var1, int var3, boolean var4);

    private native void onVolumeChange(long var1, int var3, int var4);

    private native void onAudioModeChange(long var1, int var3);
}

