/*
 * Decompiled with CFR 0.152.
 */
package com.netease.yunxin.lite.audio;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.Context;
import android.media.AudioDeviceInfo;
import android.media.AudioFormat;
import android.media.AudioManager;
import android.media.AudioPlaybackConfiguration;
import android.media.AudioRecordingConfiguration;
import android.media.MicrophoneInfo;
import com.netease.lava.webrtc.ContextUtils;
import com.netease.lava.webrtc.Logging;
import com.netease.yunxin.lite.util.Compatibility;
import com.netease.yunxin.lite.util.SystemPermissionUtils;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

public class AudioDeviceUtils {
    public static String audioDeviceToString(int device) {
        switch (device) {
            case 3: {
                return "SPEAKER_PHONE";
            }
            case 1: {
                return "WIRED_HEADSET";
            }
            case 2: {
                return "EARPIECE";
            }
            case 4: {
                return "BLUETOOTH";
            }
            case 0: {
                return "NONE";
            }
        }
        return "UNKNOWN";
    }

    public static String audioDeviceToString(int[] devices) {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        if (devices == null) {
            return sb.append("null]").toString();
        }
        for (int device : devices) {
            sb.append(AudioDeviceUtils.audioDeviceToString(device)).append(" ");
        }
        sb.append("]");
        return sb.toString();
    }

    public static void logAudioState(String tag) {
        Context context = ContextUtils.getApplicationContext();
        AudioManager audioManager = (AudioManager)context.getSystemService("audio");
        if (audioManager == null) {
            return;
        }
        AudioDeviceUtils.logAudioStateBasic(tag, context, audioManager);
        AudioDeviceUtils.logAudioStateVolume(tag, audioManager);
        AudioDeviceUtils.logAudioDeviceInfo(tag, audioManager);
    }

    private static void logAudioStateBasic(String tag, Context context, AudioManager audioManager) {
        Logging.i(tag, "Audio State: audio mode: " + AudioDeviceUtils.audioModeToString(audioManager.getMode()) + ", has mic: " + SystemPermissionUtils.hasMicrophoneFeature(context) + ", mic muted: " + audioManager.isMicrophoneMute() + ", music active: " + audioManager.isMusicActive() + ", speakerphone: " + audioManager.isSpeakerphoneOn() + ", BT SCO: " + audioManager.isBluetoothScoOn());
    }

    private static void logAudioStateVolume(String tag, AudioManager audioManager) {
        int[] streams = new int[]{0, 3, 2, 4, 5, 1};
        Logging.i(tag, "Audio State: ");
        boolean fixedVolume = false;
        if (Compatibility.runningOnLollipopOrHigher()) {
            fixedVolume = audioManager.isVolumeFixed();
            Logging.i(tag, "  fixed volume=" + fixedVolume);
        }
        if (!fixedVolume) {
            for (int stream : streams) {
                StringBuilder info = new StringBuilder();
                info.append("  " + AudioDeviceUtils.streamTypeToString(stream) + ": ");
                info.append("volume=").append(audioManager.getStreamVolume(stream));
                info.append(", max=").append(audioManager.getStreamMaxVolume(stream));
                if (Compatibility.runningOnMarshmallowOrHigher()) {
                    info.append(", muted=").append(audioManager.isStreamMute(stream));
                }
                Logging.i(tag, info.toString());
            }
        }
    }

    @TargetApi(value=28)
    public static String microphoneInfoToString(MicrophoneInfo microphone) {
        StringBuilder sb = new StringBuilder();
        if (microphone != null) {
            sb.append("deviceId:").append(microphone.getDescription()).append(", ");
            sb.append("portId:").append(microphone.getId()).append(", ");
            sb.append("type:").append(microphone.getType()).append(", ");
            sb.append("deviceLocation:").append(microphone.getLocation()).append(", ");
            sb.append("deviceGroup:").append(microphone.getGroup()).append(", ");
            sb.append("index:").append(microphone.getIndexInTheGroup()).append(", ");
            MicrophoneInfo.Coordinate3F position = microphone.getPosition();
            sb.append("position:").append(position.x).append("-").append(position.y).append("-").append(position.z).append(", ");
            MicrophoneInfo.Coordinate3F orientation = microphone.getOrientation();
            sb.append("orientation:").append(orientation.x).append("-").append(orientation.y).append("-").append(orientation.z).append(", ");
            sb.append("channelMapping:").append(microphone.getChannelMapping()).append(", ");
            sb.append("sensitivity:").append(microphone.getSensitivity()).append(", ");
            sb.append("max spl:").append(microphone.getMaxSpl()).append(", ");
            sb.append("min spl:").append(microphone.getMinSpl()).append(", ");
            sb.append("directionality:").append(microphone.getDirectionality());
        } else {
            sb.append("null");
        }
        return sb.toString();
    }

    @TargetApi(value=23)
    public static String audioDeviceInfoToString(AudioDeviceInfo info) {
        StringBuilder sb = new StringBuilder();
        if (info != null) {
            sb.append("type:").append(AudioDeviceUtils.audioDeviceTypeToString(info.getType())).append(", ");
            sb.append("name:").append(info.getProductName()).append(", ");
            sb.append("sink:").append(info.isSink()).append(", ");
            sb.append("source:").append(info.isSource()).append(", ");
            sb.append("sample:").append(Arrays.toString(info.getSampleRates())).append(", ");
            sb.append("channels:").append(Arrays.toString(info.getChannelCounts())).append(", ");
        }
        return sb.toString();
    }

    @TargetApi(value=26)
    public static String audioPlaybackConfigurationToString(AudioPlaybackConfiguration apc) {
        if (apc != null) {
            return "APC: " + apc.getAudioAttributes();
        }
        return "APC: null";
    }

    private static String audioFormatEncodingToString(int encoding) {
        switch (encoding) {
            case 0: {
                return "ENCODING_INVALID";
            }
            case 2: {
                return "ENCODING_PCM_16BIT";
            }
            case 3: {
                return "ENCODING_PCM_8BIT";
            }
            case 4: {
                return "ENCODING_PCM_FLOAT";
            }
            case 5: {
                return "ENCODING_AC3";
            }
            case 6: {
                return "ENCODING_E_AC3";
            }
            case 7: {
                return "ENCODING_DTS";
            }
            case 8: {
                return "ENCODING_DTS_HD";
            }
            case 9: {
                return "ENCODING_MP3";
            }
            case 10: {
                return "ENCODING_AAC_LC";
            }
            case 11: {
                return "ENCODING_AAC_HE_V1";
            }
            case 12: {
                return "ENCODING_AAC_HE_V2";
            }
            case 13: {
                return "ENCODING_IEC61937";
            }
            case 14: {
                return "ENCODING_DOLBY_TRUEHD";
            }
            case 15: {
                return "ENCODING_AAC_ELD";
            }
            case 16: {
                return "ENCODING_AAC_XHE";
            }
            case 17: {
                return "ENCODING_AC4";
            }
        }
        return "invalid encoding " + encoding;
    }

    @SuppressLint(value={"DefaultLocale"})
    @TargetApi(value=23)
    private static String audioFormatToString(AudioFormat format) {
        return String.format("%dch %dHz %s", format.getChannelCount(), format.getSampleRate(), AudioDeviceUtils.audioFormatEncodingToString(format.getEncoding()));
    }

    @TargetApi(value=24)
    public static String audioRecordingConfigurationToString(AudioRecordingConfiguration arc) {
        if (arc != null) {
            return "ARC: session:" + arc.getClientAudioSessionId() + " -- source:" + AudioDeviceUtils.audioSourceToString(arc.getClientAudioSource()) + " -- format client=" + AudioDeviceUtils.audioFormatToString(arc.getClientFormat()) + ", dev=" + AudioDeviceUtils.audioFormatToString(arc.getFormat());
        }
        return "ARC: null";
    }

    private static String audioDeviceTypeToString(int type) {
        switch (type) {
            case 0: {
                return "UNKNOWN";
            }
            case 1: {
                return "BUILTIN_EARPIECE";
            }
            case 2: {
                return "BUILTIN_SPEAKER";
            }
            case 3: {
                return "WIRED_HEADSET";
            }
            case 4: {
                return "WIRED_HEADPHONES";
            }
            case 5: {
                return "LINE_ANALOG";
            }
            case 6: {
                return "LINE_DIGITAL";
            }
            case 7: {
                return "BLUETOOTH_SCO";
            }
            case 8: {
                return "BLUETOOTH_A2DP";
            }
            case 9: {
                return "HDMI";
            }
            case 10: {
                return "HDMI_ARC";
            }
            case 11: {
                return "USB_DEVICE";
            }
            case 12: {
                return "USB_ACCESSORY";
            }
            case 13: {
                return "DOCK";
            }
            case 14: {
                return "FM";
            }
            case 15: {
                return "BUILTIN_MIC";
            }
            case 16: {
                return "FM_TUNER";
            }
            case 17: {
                return "TV_TUNER";
            }
            case 18: {
                return "TELEPHONY";
            }
            case 19: {
                return "AUX_LINE";
            }
            case 20: {
                return "IP";
            }
            case 21: {
                return "BUS";
            }
            case 22: {
                return "USB_HEADSET";
            }
        }
        return "UNKNOWN:" + type;
    }

    public static String audioSourceToString(int source) {
        switch (source) {
            case 0: {
                return "DEFAULT";
            }
            case 1: {
                return "MIC";
            }
            case 2: {
                return "VOICE_UPLINK";
            }
            case 3: {
                return "VOICE_DOWNLINK";
            }
            case 4: {
                return "VOICE_CALL";
            }
            case 5: {
                return "CAMCORDER";
            }
            case 6: {
                return "VOICE_RECOGNITION";
            }
            case 7: {
                return "VOICE_COMMUNICATION";
            }
        }
        return "Unknown:" + source;
    }

    public static String streamTypeToString(int type) {
        switch (type) {
            case 0: {
                return "STREAM_VOICE_CALL";
            }
            case 1: {
                return "STREAM_SYSTEM";
            }
            case 2: {
                return "STREAM_RING";
            }
            case 3: {
                return "STREAM_MUSIC";
            }
            case 5: {
                return "STREAM_NOTIFICATION";
            }
            case 10: {
                return "STREAM_ACCESSIBILITY";
            }
            case 4: {
                return "STREAM_ALARM";
            }
        }
        return "Unknown:" + type;
    }

    public static String audioScenarioToString(int audioScenario) {
        switch (audioScenario) {
            case 0: {
                return "SCENARIO_DEFAULT";
            }
            case 1: {
                return "SCENARIO_SPEECH";
            }
            case 2: {
                return "SCENARIO_MUSIC";
            }
        }
        return "Unknown:" + audioScenario;
    }

    public static String audioModeToString(int mode) {
        switch (mode) {
            case -2: {
                return "MODE_INVALID";
            }
            case -1: {
                return "MODE_CURRENT";
            }
            case 0: {
                return "MODE_NORMAL";
            }
            case 1: {
                return "MODE_RINGTONE";
            }
            case 2: {
                return "MODE_IN_CALL";
            }
            case 3: {
                return "MODE_IN_COMMUNICATION";
            }
        }
        return "Unknown:" + mode;
    }

    public static String audioFocusChangeToString(int focusChange) {
        String typeOfChange;
        switch (focusChange) {
            case 1: {
                typeOfChange = "AUDIOFOCUS_GAIN";
                break;
            }
            case 2: {
                typeOfChange = "AUDIOFOCUS_GAIN_TRANSIENT";
                break;
            }
            case 4: {
                typeOfChange = "AUDIOFOCUS_GAIN_TRANSIENT_EXCLUSIVE";
                break;
            }
            case 3: {
                typeOfChange = "AUDIOFOCUS_GAIN_TRANSIENT_MAY_DUCK";
                break;
            }
            case -1: {
                typeOfChange = "AUDIOFOCUS_LOSS";
                break;
            }
            case -2: {
                typeOfChange = "AUDIOFOCUS_LOSS_TRANSIENT";
                break;
            }
            case -3: {
                typeOfChange = "AUDIOFOCUS_LOSS_TRANSIENT_CAN_DUCK";
                break;
            }
            default: {
                typeOfChange = "AUDIOFOCUS_INVALID";
            }
        }
        return typeOfChange;
    }

    public static void logAudioProfile(String tag, int audioMode, int streamType, int audioSource) {
        String sb = "Audio Compat Profile:  , audio mode:" + AudioDeviceUtils.audioModeToString(audioMode) + " , stream type:" + AudioDeviceUtils.streamTypeToString(streamType) + " , audio source:" + AudioDeviceUtils.audioSourceToString(audioSource);
        Logging.i(tag, sb);
    }

    @TargetApi(value=23)
    private static void logAudioDeviceInfo(String tag, AudioManager audioManager) {
        if (!Compatibility.runningOnMarshmallowOrHigher() || audioManager == null) {
            return;
        }
        AudioDeviceInfo[] devices = audioManager.getDevices(3);
        if (devices.length == 0) {
            return;
        }
        Logging.i(tag, "Audio Devices: ");
        for (AudioDeviceInfo device : devices) {
            Logging.i(tag, "  " + AudioDeviceUtils.audioDeviceInfoToString(device));
        }
    }

    @TargetApi(value=28)
    private static void logMicrophoneInfo(String tag, AudioManager audioManager) {
        if (!Compatibility.runningOnPieOrHigher() || audioManager == null) {
            return;
        }
        try {
            List microphoneInfoList = audioManager.getMicrophones();
            if (microphoneInfoList.isEmpty()) {
                return;
            }
            Logging.i(tag, "Audio Microphone: ");
            for (MicrophoneInfo info : microphoneInfoList) {
                Logging.i(tag, "  " + AudioDeviceUtils.microphoneInfoToString(info));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static boolean isLowLatencyOutputSupported(Context context) {
        return AudioDeviceUtils.isOpenSLESSupported() && context.getPackageManager().hasSystemFeature("android.hardware.audio.low_latency");
    }

    static boolean isLowLatencyInputSupported(Context context) {
        return Compatibility.runningOnLollipopOrHigher() && AudioDeviceUtils.isLowLatencyOutputSupported(context);
    }

    @SuppressLint(value={"InlinedApi"})
    static boolean isProAudioSupported(Context context) {
        return Compatibility.runningOnMarshmallowOrHigher() && context.getPackageManager().hasSystemFeature("android.hardware.audio.pro");
    }

    static boolean isOpenSLESSupported() {
        return Compatibility.runningOnGingerBreadOrHigher();
    }

    public static int getAudioPreferDelay(Context context) {
        if (AudioDeviceUtils.isProAudioSupported(context)) {
            return 2;
        }
        if (AudioDeviceUtils.isLowLatencyInputSupported(context)) {
            return 1;
        }
        return 0;
    }
}

