/*
 * Decompiled with CFR 0.152.
 */
package com.netease.yunxin.lite.audio;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothHeadset;
import android.bluetooth.BluetoothProfile;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.util.Log;
import com.netease.lava.webrtc.Logging;
import com.netease.yunxin.lite.audio.AbsBluetoothManager;
import com.netease.yunxin.lite.audio.AudioDeviceCompatibility;
import com.netease.yunxin.lite.audio.BluetoothUtil;
import com.netease.yunxin.lite.audio.LavaAudioDeviceManager;
import com.netease.yunxin.lite.util.CommonUtils;
import com.netease.yunxin.lite.util.SystemPermissionUtils;
import com.netease.yunxin.lite.util.ThreadUtils;
import java.util.List;
import java.util.Set;

public class BluetoothManager
extends AbsBluetoothManager {
    private static final String TAG = "BluetoothManager";
    public static final int BLUETOOTH_SCO_TIMEOUT_MS = 12000;
    private static final int MIN_BLUETOOTH_SCO_TIMEOUT_MS = 2000;
    private static final int MAX_SCO_CONNECTION_ATTEMPTS = 3;
    private int mBluetoothSCOTimeoutMs = 12000;
    private int mScoConnectionAttempts;
    private final BluetoothProfile.ServiceListener mBluetoothServiceListener;
    private BluetoothAdapter mBluetoothAdapter;
    private BluetoothHeadset mBluetoothHeadset;
    private BluetoothDevice mBluetoothDevice;
    private final BroadcastReceiver mBluetoothHeadsetReceiver;
    private boolean needStopSco = false;
    private final Runnable mBluetoothTimeoutRunnable = new Runnable(){

        @Override
        public void run() {
            BluetoothManager.this.bluetoothTimeout();
        }
    };

    public BluetoothManager(Context context, LavaAudioDeviceManager manager, int bluetoothSCOTimeoutMs) {
        super(context, manager);
        Logging.i(TAG, "ctor");
        ThreadUtils.checkIsOnUiThread();
        this.mBluetoothServiceListener = new BluetoothServiceListener();
        this.mBluetoothHeadsetReceiver = new BluetoothHeadsetBroadcastReceiver();
        this.mBluetoothSCOTimeoutMs = Math.max(2000, bluetoothSCOTimeoutMs);
        this.mBlueToothSCO = true;
    }

    @Override
    public void start() {
        ThreadUtils.checkIsOnUiThread();
        if (!SystemPermissionUtils.checkBluetoothScoConnectPermission(this.mContext)) {
            Logging.e(TAG, "no  bluetooth  permission for start");
            return;
        }
        if (!this.mAudioManager.isBluetoothScoAvailableOffCall()) {
            Logging.e(TAG, "bluetooth is not available off call");
        }
        if (this.mBluetoothState != AbsBluetoothManager.State.UNINITIALIZED) {
            Logging.e(TAG, "Invalid bluetooth state");
            return;
        }
        this.mBluetoothHeadset = null;
        this.mBluetoothDevice = null;
        this.mScoConnectionAttempts = 0;
        this.mBluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
        if (this.mBluetoothAdapter == null) {
            Logging.e(TAG, "bluetooth is not supported  on this hardware platform");
            return;
        }
        this.logBluetoothAdapterInfo(this.mBluetoothAdapter);
        if (!this.mBluetoothAdapter.getProfileProxy(this.mContext, this.mBluetoothServiceListener, 1)) {
            Logging.e(TAG, "BluetoothAdapter.getProfileProxy(HEADSET) failed");
            return;
        }
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.bluetooth.headset.profile.action.CONNECTION_STATE_CHANGED");
        filter.addAction("android.bluetooth.headset.profile.action.AUDIO_STATE_CHANGED");
        filter.addAction("android.media.ACTION_SCO_AUDIO_STATE_UPDATED");
        CommonUtils.safeRegisterReceiver(this.mContext, this.mBluetoothHeadsetReceiver, filter);
        this.setBluetoothState(this.mBluetoothAdapter.getProfileConnectionState(1));
    }

    private void setBluetoothState(int state) {
        Logging.i(TAG, "HEADSET profile state: " + this.connectionStateToString(state));
        switch (state) {
            case 2: {
                this.mBluetoothState = AbsBluetoothManager.State.HEADSET_AVAILABLE;
                break;
            }
            case 0: 
            case 1: 
            case 3: {
                this.mBluetoothState = AbsBluetoothManager.State.HEADSET_UNAVAILABLE;
                break;
            }
            default: {
                Logging.e(TAG, "Invalid BluetoothHeadset state: " + state);
            }
        }
        Logging.i(TAG, "New headset state: " + (Object)((Object)this.mBluetoothState));
    }

    @Override
    public void stop() {
        ThreadUtils.checkIsOnUiThread();
        try {
            this.mContext.unregisterReceiver(this.mBluetoothHeadsetReceiver);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Logging.i(TAG, "stop: bluetooth state=" + (Object)((Object)this.mBluetoothState));
        if (this.mBluetoothAdapter != null) {
            this.stopScoAudio();
            if (this.mBluetoothState != AbsBluetoothManager.State.UNINITIALIZED) {
                this.cancelTimer();
                if (this.mBluetoothHeadset != null) {
                    this.mBluetoothAdapter.closeProfileProxy(1, (BluetoothProfile)this.mBluetoothHeadset);
                    this.mBluetoothHeadset = null;
                }
                this.mBluetoothAdapter = null;
                this.mBluetoothDevice = null;
                this.mBluetoothState = AbsBluetoothManager.State.UNINITIALIZED;
            }
        }
        Logging.i(TAG, "stop done: bluetooth state=" + (Object)((Object)this.mBluetoothState));
    }

    @Override
    public AbsBluetoothManager.State getState() {
        ThreadUtils.checkIsOnUiThread();
        return this.mBluetoothState;
    }

    @Override
    public boolean startScoAudio() {
        ThreadUtils.checkIsOnUiThread();
        Logging.i(TAG, "startScoAudio: bluetooth state=" + (Object)((Object)this.mBluetoothState) + ", attempts: " + this.mScoConnectionAttempts + ", sco is on: " + this.mAudioManager.isBluetoothScoOn());
        if (this.mScoConnectionAttempts >= 3) {
            Logging.e(TAG, "bluetooth sco connection fails - no more attempts");
            return false;
        }
        if (this.mBluetoothState != AbsBluetoothManager.State.HEADSET_AVAILABLE) {
            Logging.e(TAG, "bluetooth sco connection fails - no headset available");
            return false;
        }
        this.mBluetoothState = AbsBluetoothManager.State.SCO_CONNECTING;
        if (!this.mBlueToothSCO) {
            Logging.i(TAG, "sco will not enabled , need stop sco:" + this.needStopSco);
            if (this.needStopSco) {
                this.mAudioManager.stopBluetoothSco();
                this.needStopSco = false;
            }
            this.mAudioManager.setBluetoothScoOn(false);
            this.mAudioManager.setBluetoothA2dpOn(true);
        } else {
            this.mAudioManager.startBluetoothSco();
            this.mAudioManager.setBluetoothScoOn(true);
            ++this.mScoConnectionAttempts;
            this.startTimer();
            this.needStopSco = true;
        }
        Logging.i(TAG, "startScoAudio done: bluetooth state = " + (Object)((Object)this.mBluetoothState) + " , sco is on: " + this.mBlueToothSCO);
        return true;
    }

    @Override
    public void stopScoAudio() {
        ThreadUtils.checkIsOnUiThread();
        Logging.i(TAG, "stopScoAudio: bluetooth state=" + (Object)((Object)this.mBluetoothState) + ", sco is on: " + this.mAudioManager.isBluetoothScoOn() + " , needStopSco:" + this.needStopSco);
        if (this.mBluetoothState != AbsBluetoothManager.State.SCO_CONNECTING && this.mBluetoothState != AbsBluetoothManager.State.SCO_CONNECTED) {
            return;
        }
        this.cancelTimer();
        if (this.needStopSco) {
            this.mAudioManager.stopBluetoothSco();
            this.needStopSco = false;
        }
        this.mBluetoothState = AbsBluetoothManager.State.SCO_DISCONNECTING;
    }

    private void logBluetoothAdapterInfo(BluetoothAdapter localAdapter) {
        try {
            Logging.i(TAG, "BluetoothAdapter: enabled=" + localAdapter.isEnabled() + ", state=" + this.adapterStateToString(localAdapter.getState()) + ", name=" + localAdapter.getName());
            Set pairedDevices = localAdapter.getBondedDevices();
            if (!pairedDevices.isEmpty()) {
                Logging.i(TAG, "paired devices:");
                for (BluetoothDevice device : pairedDevices) {
                    Logging.i(TAG, "name=" + device.getName() + " , type = " + BluetoothUtil.getBluetoothDeviceType(device));
                }
            }
        }
        catch (Exception e) {
            Logging.e(TAG, "logBluetoothAdapterInfo error : " + Log.getStackTraceString((Throwable)e));
        }
    }

    private String connectionStateToString(int state) {
        switch (state) {
            case 0: {
                return "DISCONNECTED";
            }
            case 1: {
                return "CONNECTING";
            }
            case 2: {
                return "CONNECTED";
            }
            case 3: {
                return "DISCONNECTING";
            }
        }
        return "INVALID(" + state + ")";
    }

    private String audioStateToString(int state) {
        switch (state) {
            case 12: {
                return "CONNECTED";
            }
            case 11: {
                return "CONNECTING";
            }
            case 10: {
                return "DISCONNECTED";
            }
        }
        return "INVALID(" + state + ")";
    }

    @Override
    public void setAudioBlueToothSCO(boolean blueToothSCO) {
        Logging.i(TAG, "setAudioBlueToothSCO: " + blueToothSCO);
        this.mBlueToothSCO = blueToothSCO;
    }

    @Override
    public boolean blueToothIsSCO() {
        return this.mBlueToothSCO;
    }

    private String scoStateToString(int state) {
        switch (state) {
            case 0: {
                return "DISCONNECTED";
            }
            case 1: {
                return "CONNECTED";
            }
            case 2: {
                return "CONNECTING";
            }
        }
        return "ERROR (" + state + ")";
    }

    private String adapterStateToString(int state) {
        switch (state) {
            case 10: {
                return "OFF";
            }
            case 12: {
                return "ON";
            }
            case 13: {
                return "TURNING_OFF";
            }
            case 11: {
                return "TURNING_ON";
            }
        }
        return "INVALID(" + state + ")";
    }

    private void startTimer() {
        ThreadUtils.checkIsOnUiThread();
        Logging.i(TAG, "startTimer , time out: " + this.mBluetoothSCOTimeoutMs);
        this.mHandler.postDelayed(this.mBluetoothTimeoutRunnable, (long)this.mBluetoothSCOTimeoutMs);
    }

    private void cancelTimer() {
        ThreadUtils.checkIsOnUiThread();
        Logging.i(TAG, "cancelTimer");
        this.mHandler.removeCallbacks(this.mBluetoothTimeoutRunnable);
    }

    private void bluetoothTimeout() {
        ThreadUtils.checkIsOnUiThread();
        if (this.mBluetoothState == AbsBluetoothManager.State.UNINITIALIZED || this.mBluetoothHeadset == null) {
            return;
        }
        Logging.e(TAG, "bluetoothTimeout: bluetooth state=" + (Object)((Object)this.mBluetoothState) + ", attempts: " + this.mScoConnectionAttempts + ", sco is on: " + this.mAudioManager.isBluetoothScoOn());
        if (this.mBluetoothState != AbsBluetoothManager.State.SCO_CONNECTING) {
            return;
        }
        boolean scoConnected = false;
        List devices = this.mBluetoothHeadset.getConnectedDevices();
        if (!devices.isEmpty()) {
            this.mBluetoothDevice = (BluetoothDevice)devices.get(0);
            if (this.mBluetoothHeadset.isAudioConnected(this.mBluetoothDevice)) {
                Logging.i(TAG, "sco connected with " + this.mBluetoothDevice.getName() + " , type: " + BluetoothUtil.getBluetoothDeviceType(this.mBluetoothDevice));
                scoConnected = true;
            } else {
                if (!(this.mBlueToothSCO || AudioDeviceCompatibility.getAudioSource() != 1 && AudioDeviceCompatibility.getAudioSource() != 0 || AudioDeviceCompatibility.getStreamType() != 3 || AudioDeviceCompatibility.getAudioMode() != 0)) {
                    Logging.i(TAG, "sco is not connected ,fake connection " + this.mBluetoothDevice.getName());
                    scoConnected = true;
                }
                Logging.i(TAG, "sco is not connected with " + this.mBluetoothDevice.getName());
            }
        }
        if (scoConnected) {
            this.mBluetoothState = AbsBluetoothManager.State.SCO_CONNECTED;
            this.mScoConnectionAttempts = 0;
        } else {
            Logging.e(TAG, "bluetooth failed to connect after timeout");
            this.stopScoAudio();
        }
        this.updateAudioDeviceState();
    }

    private void updateAudioDeviceState() {
        ThreadUtils.checkIsOnUiThread();
        this.mAudioDeviceManager.updateAudioDeviceState();
    }

    @Override
    public void updateDevice() {
        if (this.mBluetoothState == AbsBluetoothManager.State.UNINITIALIZED || this.mBluetoothHeadset == null) {
            return;
        }
        List devices = this.mBluetoothHeadset.getConnectedDevices();
        if (devices.isEmpty()) {
            this.mBluetoothDevice = null;
            this.mBluetoothState = AbsBluetoothManager.State.HEADSET_UNAVAILABLE;
            Logging.w(TAG, "updateDevice no connected bluetooth headset");
        } else {
            for (BluetoothDevice device : devices) {
                int deviceType = device.getBluetoothClass().getMajorDeviceClass();
                Logging.i(TAG, "updateDevice connected bluetooth headset: , name=" + device.getName() + ", , state=" + this.connectionStateToString(this.mBluetoothHeadset.getConnectionState(device)) + ", type=" + BluetoothUtil.getBluetoothDeviceType(device) + ", sco audio=" + this.mBluetoothHeadset.isAudioConnected(device));
                if (deviceType != 1024 && deviceType != 0 && deviceType != 7936) continue;
                this.mBluetoothDevice = device;
                this.mBluetoothState = AbsBluetoothManager.State.HEADSET_AVAILABLE;
                return;
            }
            this.mBluetoothDevice = null;
            this.mBluetoothState = AbsBluetoothManager.State.HEADSET_UNAVAILABLE;
        }
    }

    private class BluetoothHeadsetBroadcastReceiver
    extends BroadcastReceiver {
        private BluetoothHeadsetBroadcastReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            if (BluetoothManager.this.mBluetoothState == AbsBluetoothManager.State.UNINITIALIZED) {
                return;
            }
            String action = intent.getAction();
            if ("android.bluetooth.headset.profile.action.CONNECTION_STATE_CHANGED".equals(action)) {
                int state = intent.getIntExtra("android.bluetooth.profile.extra.STATE", 0);
                int preState = intent.getIntExtra("android.bluetooth.profile.extra.PREVIOUS_STATE", 0);
                BluetoothDevice device = (BluetoothDevice)intent.getParcelableExtra("android.bluetooth.device.extra.DEVICE");
                Logging.i(BluetoothManager.TAG, "BluetoothHeadsetReceiver.onReceive: a=ACTION_CONNECTION_STATE_CHANGED, s=" + BluetoothManager.this.connectionStateToString(state) + ", ps=" + BluetoothManager.this.connectionStateToString(preState) + ", sb=" + this.isInitialStickyBroadcast() + ", bluetooth state=" + (Object)((Object)BluetoothManager.this.mBluetoothState) + ", d=" + (device == null ? "null" : device.getName()) + ", ds=" + BluetoothManager.this.connectionStateToString(BluetoothManager.this.mBluetoothHeadset == null ? -1 : BluetoothManager.this.mBluetoothHeadset.getConnectionState(device)));
                if (state == 2) {
                    BluetoothManager.this.mScoConnectionAttempts = 0;
                    BluetoothManager.this.updateAudioDeviceState();
                } else if (state == 0) {
                    BluetoothManager.this.stopScoAudio();
                    BluetoothManager.this.updateAudioDeviceState();
                }
            } else if (action.equals("android.bluetooth.headset.profile.action.AUDIO_STATE_CHANGED")) {
                int state = intent.getIntExtra("android.bluetooth.profile.extra.STATE", 10);
                int preState = intent.getIntExtra("android.bluetooth.profile.extra.PREVIOUS_STATE", 10);
                BluetoothDevice device = (BluetoothDevice)intent.getParcelableExtra("android.bluetooth.device.extra.DEVICE");
                Logging.i(BluetoothManager.TAG, "BluetoothHeadsetReceiver.onReceive: a=ACTION_AUDIO_STATE_CHANGED, s=" + BluetoothManager.this.audioStateToString(state) + ", ps=" + BluetoothManager.this.audioStateToString(preState) + ", sb=" + this.isInitialStickyBroadcast() + ", bluetooth state=" + (Object)((Object)BluetoothManager.this.mBluetoothState) + ", d=" + (device == null ? "null" : device.getName()) + ", d_type =" + BluetoothUtil.getBluetoothDeviceType(device) + ", sco=" + (BluetoothManager.this.mBluetoothHeadset == null ? "false" : Boolean.valueOf(BluetoothManager.this.mBluetoothHeadset.isAudioConnected(device))));
                if (state == 12) {
                    BluetoothManager.this.cancelTimer();
                    if (BluetoothManager.this.mBluetoothState == AbsBluetoothManager.State.SCO_CONNECTING) {
                        BluetoothManager.this.mBluetoothState = AbsBluetoothManager.State.SCO_CONNECTED;
                        BluetoothManager.this.mScoConnectionAttempts = 0;
                        BluetoothManager.this.updateAudioDeviceState();
                    } else {
                        Logging.e(BluetoothManager.TAG, "BluetoothHeadsetReceiver.Unexpected state BluetoothHeadset.STATE_AUDIO_CONNECTED");
                    }
                } else if (state == 10) {
                    Logging.i(BluetoothManager.TAG, "BluetoothHeadsetReceiver.bluetooth audio sco is now disconnected");
                    if (this.isInitialStickyBroadcast()) {
                        Logging.i(BluetoothManager.TAG, "BluetoothHeadsetReceiver.Ignore STATE_AUDIO_DISCONNECTED initial sticky broadcast.");
                        return;
                    }
                    BluetoothManager.this.updateAudioDeviceState();
                }
            } else if (action.equals("android.media.ACTION_SCO_AUDIO_STATE_UPDATED")) {
                int state = intent.getIntExtra("android.media.extra.SCO_AUDIO_STATE", 0);
                int preState = intent.getIntExtra("android.media.extra.SCO_AUDIO_PREVIOUS_STATE", 0);
                Logging.i(BluetoothManager.TAG, "BluetoothHeadsetReceiver.onReceive: a=ACTION_SCO_AUDIO_STATE_UPDATED, s=" + BluetoothManager.this.scoStateToString(state) + ", ps=" + BluetoothManager.this.scoStateToString(preState) + ", sb=" + this.isInitialStickyBroadcast() + ", bluetooth state=" + (Object)((Object)BluetoothManager.this.mBluetoothState));
            }
        }
    }

    private class BluetoothServiceListener
    implements BluetoothProfile.ServiceListener {
        private BluetoothServiceListener() {
        }

        public void onServiceConnected(int profile, BluetoothProfile proxy) {
            if (profile != 1 || BluetoothManager.this.mBluetoothState == AbsBluetoothManager.State.UNINITIALIZED) {
                return;
            }
            Logging.i(BluetoothManager.TAG, "BluetoothServiceListener.onServiceConnected: bluetooth state=" + (Object)((Object)BluetoothManager.this.mBluetoothState));
            BluetoothManager.this.mBluetoothHeadset = (BluetoothHeadset)proxy;
            BluetoothManager.this.mBluetoothState = AbsBluetoothManager.State.HEADSET_AVAILABLE;
            BluetoothManager.this.updateAudioDeviceState();
            Logging.i(BluetoothManager.TAG, "BluetoothServiceListener.onServiceConnected done: bluetooth state=" + (Object)((Object)BluetoothManager.this.mBluetoothState));
        }

        public void onServiceDisconnected(int profile) {
            if (profile != 1 || BluetoothManager.this.mBluetoothState == AbsBluetoothManager.State.UNINITIALIZED) {
                return;
            }
            Logging.i(BluetoothManager.TAG, "BluetoothServiceListener.onServiceDisconnected: bluetooth state=" + (Object)((Object)BluetoothManager.this.mBluetoothState));
            BluetoothManager.this.stopScoAudio();
            BluetoothManager.this.mBluetoothHeadset = null;
            BluetoothManager.this.mBluetoothDevice = null;
            BluetoothManager.this.mBluetoothState = AbsBluetoothManager.State.HEADSET_UNAVAILABLE;
            BluetoothManager.this.updateAudioDeviceState();
            Logging.i(BluetoothManager.TAG, "BluetoothServiceListener.onServiceDisconnected done: bluetooth state=" + (Object)((Object)BluetoothManager.this.mBluetoothState));
        }
    }
}

