/*
 * Decompiled with CFR 0.152.
 */
package com.netease.yunxin.lite.audio;

import android.bluetooth.BluetoothA2dp;
import android.bluetooth.BluetoothClass;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothHeadset;
import android.util.Log;
import com.netease.lava.webrtc.Logging;
import java.lang.reflect.Method;

public class BluetoothUtil {
    public static final String TAG = "BluetoothUtil";

    public static String getBluetoothDeviceType(BluetoothDevice device) {
        BluetoothClass bluetoothClass;
        BluetoothClass bluetoothClass2 = bluetoothClass = device == null ? null : device.getBluetoothClass();
        if (bluetoothClass == null) {
            return "device is null";
        }
        String deviceType = null;
        switch (bluetoothClass.getMajorDeviceClass()) {
            case 0: {
                deviceType = "MISC";
                break;
            }
            case 256: {
                deviceType = "COMPUTER";
                break;
            }
            case 512: {
                deviceType = "PHONE";
                break;
            }
            case 768: {
                deviceType = "NETWORKING";
                break;
            }
            case 1024: {
                deviceType = "AUDIO_VIDEO";
                break;
            }
            case 1280: {
                deviceType = "PERIPHERAL";
                break;
            }
            case 1536: {
                deviceType = "IMAGING";
                break;
            }
            case 1792: {
                deviceType = "WEARABLE";
                break;
            }
            case 2048: {
                deviceType = "TOY";
                break;
            }
            case 2304: {
                deviceType = "HEALTH";
                break;
            }
            default: {
                deviceType = "UNCATEGORIZED";
            }
        }
        return "[major_type:" + deviceType + " , minor_type: " + Integer.toHexString(device.getBluetoothClass().getDeviceClass()) + "]";
    }

    public static boolean connectHFP(BluetoothHeadset hfp, BluetoothDevice device) {
        boolean ret = false;
        Method connect = null;
        try {
            connect = BluetoothHeadset.class.getDeclaredMethod("connect", BluetoothDevice.class);
            connect.setAccessible(true);
            ret = (Boolean)connect.invoke((Object)hfp, device);
        }
        catch (Exception e) {
            Logging.e(TAG, "connectHfp exception: " + Log.getStackTraceString((Throwable)e));
        }
        return ret;
    }

    public static boolean disconnectHFP(BluetoothHeadset hfp, BluetoothDevice device) {
        boolean ret = false;
        Method connect = null;
        try {
            connect = BluetoothHeadset.class.getDeclaredMethod("disconnect", BluetoothDevice.class);
            connect.setAccessible(true);
            ret = (Boolean)connect.invoke((Object)hfp, device);
        }
        catch (Exception e) {
            Logging.e(TAG, "disconnectHFP exception: " + Log.getStackTraceString((Throwable)e));
        }
        return ret;
    }

    public static boolean connectA2DP(BluetoothA2dp a2dp, BluetoothDevice device) {
        boolean ret = false;
        Method connect = null;
        try {
            connect = BluetoothA2dp.class.getDeclaredMethod("connect", BluetoothDevice.class);
            connect.setAccessible(true);
            ret = (Boolean)connect.invoke((Object)a2dp, device);
        }
        catch (Exception e) {
            Logging.e(TAG, "connectA2dp exception: " + Log.getStackTraceString((Throwable)e));
        }
        return ret;
    }

    public static boolean disconnectA2DP(BluetoothA2dp a2dp, BluetoothDevice device) {
        boolean ret = false;
        Method connect = null;
        try {
            connect = BluetoothA2dp.class.getDeclaredMethod("disconnect", BluetoothDevice.class);
            connect.setAccessible(true);
            ret = (Boolean)connect.invoke((Object)a2dp, device);
        }
        catch (Exception e) {
            Logging.e(TAG, "disconnectA2DP exception: " + Log.getStackTraceString((Throwable)e));
        }
        return ret;
    }
}

