/*
 * Decompiled with CFR 0.152.
 */
package com.netease.yunxin.lite.audio;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.Context;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.hardware.display.DisplayManager;
import android.os.PowerManager;
import android.util.Log;
import android.view.Display;
import com.netease.lava.webrtc.Logging;
import com.netease.yunxin.lite.audio.AccelerometerListener;
import com.netease.yunxin.lite.util.Compatibility;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

class CallProximityManager
implements SensorEventListener,
AccelerometerListener.OrientationListener {
    private static final String TAG = "CallProximityManager";
    private SensorManager mSensorManager;
    private PowerManager mPowerManager;
    private Sensor mProximitySensor;
    private static final float PROXIMITY_THRESHOLD = 5.0f;
    private boolean mProximitySensorTracked = false;
    private boolean mIsFirstRun = true;
    private ProximityDirector mDirector = null;
    private PowerManager.WakeLock mProximityWakeLock;
    private AccelerometerListener mAccelerometerManager;
    private int mOrientation;
    private boolean mAccelerometerEnabled = false;
    private int WAIT_FOR_PROXIMITY_NEGATIVE = 1;
    private static Method mPowerLockReleaseIntMethod;
    private ProximityDisplayListener mProximityDisplayListener;

    @SuppressLint(value={"InvalidWakeLockTag"})
    CallProximityManager(Context context, ProximityDirector director) {
        Logging.d(TAG, "CallProximityManager ctor");
        this.mDirector = director;
        this.mSensorManager = (SensorManager)context.getSystemService("sensor");
        this.mPowerManager = (PowerManager)context.getSystemService("power");
        this.mAccelerometerManager = new AccelerometerListener(context, this);
        if (Compatibility.runningOnLollipopOrHigher()) {
            this.mProximityDisplayListener = new ProximityDisplayListener((DisplayManager)context.getSystemService("display"));
        }
        if (this.mPowerManager != null) {
            try {
                boolean supportProximity;
                Field f = PowerManager.class.getDeclaredField("PROXIMITY_SCREEN_OFF_WAKE_LOCK");
                int proximityScreenOffWakeLock = (Integer)f.get(null);
                if (Compatibility.runningOnJellyBeanMR1OrHigher()) {
                    Method method = this.mPowerManager.getClass().getDeclaredMethod("isWakeLockLevelSupported", Integer.TYPE);
                    supportProximity = (Boolean)method.invoke((Object)this.mPowerManager, proximityScreenOffWakeLock);
                    Logging.d(TAG, "Use 4.2 detection way for proximity sensor detection. Result is " + supportProximity);
                } else {
                    Method method = this.mPowerManager.getClass().getDeclaredMethod("getSupportedWakeLockFlags", new Class[0]);
                    int supportedFlags = (Integer)method.invoke((Object)this.mPowerManager, new Object[0]);
                    Logging.d(TAG, "Proximity flags supported : " + supportedFlags);
                    boolean bl = supportProximity = (supportedFlags & proximityScreenOffWakeLock) != 0;
                }
                if (supportProximity) {
                    Logging.d(TAG, "We can use native screen locker !!");
                    this.mProximityWakeLock = this.mPowerManager.newWakeLock(proximityScreenOffWakeLock, "com.netease.nrtc.CallProximity");
                    this.mProximityWakeLock.setReferenceCounted(false);
                }
            }
            catch (Exception e) {
                Logging.i(TAG, "Impossible to get power manager supported wake lock flags ");
            }
            if (mPowerLockReleaseIntMethod == null) {
                try {
                    mPowerLockReleaseIntMethod = this.mProximityWakeLock.getClass().getDeclaredMethod("release", Integer.TYPE);
                }
                catch (Exception e) {
                    Logging.i(TAG, "Impossible to get power manager release with it");
                }
            }
        }
        if (this.mProximityWakeLock == null) {
            this.mProximitySensor = this.mSensorManager.getDefaultSensor(8);
        }
    }

    void startTracking() {
        Logging.i(TAG, "start tracking");
        if (this.mProximitySensor != null && !this.mProximitySensorTracked) {
            this.mIsFirstRun = true;
            Log.d((String)TAG, (String)"Register sensor");
            this.mSensorManager.registerListener((SensorEventListener)this, this.mProximitySensor, 3);
            this.mProximitySensorTracked = true;
        }
        if (!this.mAccelerometerEnabled) {
            this.mAccelerometerManager.enable(true);
            this.mAccelerometerEnabled = true;
        }
        if (this.mProximityDisplayListener != null) {
            this.mProximityDisplayListener.register();
        }
    }

    void stopTracking() {
        Logging.i(TAG, "stop tracking");
        if (this.mProximitySensor != null && this.mProximitySensorTracked) {
            this.mProximitySensorTracked = false;
            this.mSensorManager.unregisterListener((SensorEventListener)this);
            Logging.d(TAG, "Unregister to sensor is done !!!");
        }
        if (this.mAccelerometerEnabled) {
            this.mAccelerometerManager.enable(false);
            this.mAccelerometerEnabled = false;
        }
        if (this.mProximityDisplayListener != null) {
            this.mProximityDisplayListener.unregister();
        }
        this.release(0);
    }

    public void onAccuracyChanged(Sensor sensor, int accuracy) {
    }

    public void onSensorChanged(SensorEvent event) {
        if (this.mProximitySensorTracked && !this.mIsFirstRun) {
            float distance = event.values[0];
            boolean active = (double)distance >= 0.0 && distance < 5.0f && distance < event.sensor.getMaximumRange();
            Logging.d(TAG, "Distance is now " + distance);
            boolean isValidCallState = false;
            if (this.mDirector != null) {
                isValidCallState = this.mDirector.shouldActivateProximity();
            }
            if (isValidCallState && active) {
                if (this.mDirector != null) {
                    this.mDirector.onProximityTrackingChanged(true);
                }
            } else if (this.mDirector != null) {
                this.mDirector.onProximityTrackingChanged(false);
            }
        }
        if (this.mIsFirstRun) {
            this.mIsFirstRun = false;
        }
    }

    private void release(int flag) {
        if (this.mProximityWakeLock != null && this.mProximityWakeLock.isHeld()) {
            boolean usedNewRelease = false;
            if (mPowerLockReleaseIntMethod != null) {
                try {
                    mPowerLockReleaseIntMethod.invoke((Object)this.mProximityWakeLock, flag);
                    usedNewRelease = true;
                }
                catch (Exception e) {
                    Logging.i(TAG, "Error calling new release method " + e);
                }
            }
            if (!usedNewRelease) {
                this.mProximityWakeLock.release();
            }
        }
        if (this.mDirector != null) {
            this.mDirector.onProximityTrackingChanged(false);
        }
    }

    private void acquire() {
        if (this.mProximityWakeLock != null && !this.mProximityWakeLock.isHeld()) {
            this.mProximityWakeLock.acquire();
        }
        if (this.mDirector != null) {
            this.mDirector.onProximityTrackingChanged(true);
        }
    }

    private void updateProximitySensorMode() {
        boolean horizontal = this.mOrientation == 2;
        boolean activeRegardingCalls = false;
        if (this.mDirector != null) {
            activeRegardingCalls = this.mDirector.shouldActivateProximity();
        }
        Logging.d(TAG, "Horizontal : " + horizontal + " and activate for calls " + activeRegardingCalls);
        if (activeRegardingCalls && !horizontal) {
            this.acquire();
        } else {
            this.release(horizontal ? this.WAIT_FOR_PROXIMITY_NEGATIVE : 0);
        }
    }

    @Override
    public void orientationChanged(int orientation) {
        this.mOrientation = orientation;
        this.updateProximitySensorMode();
    }

    private void onDisplayStateChanged(boolean isDisplayOn) {
        Logging.i(TAG, "isDisplayOn: " + isDisplayOn);
        this.mAccelerometerManager.enable(isDisplayOn);
    }

    @TargetApi(value=21)
    private class ProximityDisplayListener
    implements DisplayManager.DisplayListener {
        private DisplayManager mDisplayManager;
        private boolean mIsDisplayOn = true;

        ProximityDisplayListener(DisplayManager displayManager) {
            Logging.d(CallProximityManager.TAG, "ProximityDisplayListener ctor");
            this.mDisplayManager = displayManager;
        }

        void register() {
            this.mDisplayManager.registerDisplayListener((DisplayManager.DisplayListener)this, null);
        }

        void unregister() {
            this.mDisplayManager.unregisterDisplayListener((DisplayManager.DisplayListener)this);
        }

        public void onDisplayRemoved(int displayId) {
        }

        public void onDisplayChanged(int displayId) {
            if (displayId == 0) {
                boolean isDisplayOn;
                Display display = this.mDisplayManager.getDisplay(displayId);
                boolean bl = isDisplayOn = display.getState() != 1;
                if (isDisplayOn != this.mIsDisplayOn) {
                    this.mIsDisplayOn = isDisplayOn;
                    CallProximityManager.this.onDisplayStateChanged(this.mIsDisplayOn);
                }
            }
        }

        public void onDisplayAdded(int displayId) {
        }
    }

    static interface ProximityDirector {
        public boolean shouldActivateProximity();

        public void onProximityTrackingChanged(boolean var1);
    }
}

