/*
 * Decompiled with CFR 0.152.
 */
package com.netease.yunxin.lite.audio;

import android.content.Context;
import android.media.AudioDeviceCallback;
import android.media.AudioDeviceInfo;
import com.netease.lava.webrtc.Logging;
import com.netease.yunxin.lite.audio.AbsBluetoothManager;
import com.netease.yunxin.lite.audio.AudioDeviceUtils;
import com.netease.yunxin.lite.audio.LavaAudioDeviceManager;
import com.netease.yunxin.lite.util.Compatibility;
import com.netease.yunxin.lite.util.ThreadUtils;

public class FakeBluetoothManager
extends AbsBluetoothManager {
    private static final String TAG = "FakeBluetoothManager";
    private AudioDeviceCallback mAudioDeviceCallback;

    public FakeBluetoothManager(Context context, LavaAudioDeviceManager manager) {
        super(context, manager);
        this.mBlueToothSCO = false;
        Logging.i(TAG, "ctor");
    }

    @Override
    public void start() {
        this.mBluetoothState = AbsBluetoothManager.State.HEADSET_UNAVAILABLE;
        this.registerAudioDeviceCallback(true);
    }

    @Override
    public void stop() {
        this.registerAudioDeviceCallback(false);
        this.mBluetoothState = AbsBluetoothManager.State.UNINITIALIZED;
    }

    @Override
    public void setAudioBlueToothSCO(boolean blueToothSCO) {
        this.mBlueToothSCO = false;
    }

    private void registerAudioDeviceCallback(boolean register) {
        if (!Compatibility.runningOnMarshmallowOrHigher()) {
            return;
        }
        if (!register && this.mAudioDeviceCallback != null) {
            this.mAudioManager.unregisterAudioDeviceCallback(this.mAudioDeviceCallback);
            this.mAudioDeviceCallback = null;
            return;
        }
        if (register && this.mAudioDeviceCallback == null) {
            this.mAudioDeviceCallback = new AudioDeviceCallback(){

                public void onAudioDevicesAdded(AudioDeviceInfo[] addedDevices) {
                    if (addedDevices == null || addedDevices.length == 0) {
                        Logging.i(FakeBluetoothManager.TAG, "    Devices info is null!!");
                        return;
                    }
                    for (AudioDeviceInfo info : addedDevices) {
                        if (info.getType() != 8) continue;
                        Logging.i(FakeBluetoothManager.TAG, "Bluetooth Devices Added " + AudioDeviceUtils.audioDeviceInfoToString(info));
                        FakeBluetoothManager.this.mBluetoothState = AbsBluetoothManager.State.SCO_CONNECTED;
                        FakeBluetoothManager.this.updateAudioDeviceState();
                        return;
                    }
                }

                public void onAudioDevicesRemoved(AudioDeviceInfo[] removedDevices) {
                    if (removedDevices == null || removedDevices.length == 0) {
                        Logging.i(FakeBluetoothManager.TAG, "    Devices info is null!!");
                        return;
                    }
                    for (AudioDeviceInfo info : removedDevices) {
                        if (info.getType() != 8) continue;
                        Logging.i(FakeBluetoothManager.TAG, "Bluetooth Devices Removed " + AudioDeviceUtils.audioDeviceInfoToString(info));
                        FakeBluetoothManager.this.mBluetoothState = AbsBluetoothManager.State.HEADSET_UNAVAILABLE;
                        FakeBluetoothManager.this.updateAudioDeviceState();
                        return;
                    }
                }
            };
            this.mAudioManager.registerAudioDeviceCallback(this.mAudioDeviceCallback, this.mHandler);
        }
    }

    private void updateAudioDeviceState() {
        ThreadUtils.checkIsOnUiThread();
        this.mAudioDeviceManager.updateAudioDeviceState();
    }
}

