/*
 * Decompiled with CFR 0.152.
 */
package com.netease.yunxin.lite.audio;

import android.annotation.SuppressLint;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.media.AudioDeviceCallback;
import android.media.AudioDeviceInfo;
import android.media.AudioManager;
import android.media.AudioPlaybackConfiguration;
import android.media.AudioRecordingConfiguration;
import android.os.Handler;
import android.os.HandlerThread;
import android.util.Log;
import com.netease.lava.webrtc.CalledByNative;
import com.netease.lava.webrtc.ContextUtils;
import com.netease.lava.webrtc.Logging;
import com.netease.yunxin.lite.audio.AbsBluetoothManager;
import com.netease.yunxin.lite.audio.AudioDeviceCompatibility;
import com.netease.yunxin.lite.audio.AudioDeviceUtils;
import com.netease.yunxin.lite.audio.CallProximityManager;
import com.netease.yunxin.lite.util.ArrayUtils;
import com.netease.yunxin.lite.util.CancelableTask;
import com.netease.yunxin.lite.util.Compatibility;
import com.netease.yunxin.lite.util.LooperUtils;
import com.netease.yunxin.lite.util.SystemPermissionUtils;
import com.netease.yunxin.lite.util.ThreadUtils;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;

public final class LavaAudioDeviceManager {
    private static final String TAG = "AudioDeviceManager";
    private int mSavedAudioMode = -2;
    private boolean mSavedIsSpeakerPhoneOn = false;
    private boolean mSavedIsMicrophoneMute = false;
    private boolean mHasWiredHeadset = false;
    private AudioManager mAudioManager;
    private AbsBluetoothManager mBluetoothManager;
    private WiredHeadsetReceiver mWiredHeadsetReceiver;
    private Context mContext;
    private volatile AudioManagerState mAudioManagerState;
    private int mDefaultAudioDevice = 0;
    private volatile int mSelectedAudioDevice = 0;
    private int mUserSelectedAudioDevice = 0;
    private AudioManagerEvents mAudioManagerEvents;
    private CallProximityManager mCallProximityManager;
    private boolean mProximityActivated = true;
    private Set<Integer> mAudioDevices = new HashSet<Integer>();
    private Handler mHandler;
    private AudioManager.OnAudioFocusChangeListener mAudioFocusChangeListener;
    private AudioManager.AudioPlaybackCallback mAudioPlaybackCallback;
    private AudioManager.AudioRecordingCallback mAudioRecordingCallback;
    private AudioDeviceCallback mAudioDeviceCallback;
    private final VolumeLogger mVolumeLogger;
    private boolean bluetoothTryReconnect;
    private volatile CancelableTask startTask;
    private volatile CancelableTask setModeTask;
    private String playbackCallbackConfigPrintLog;
    private String recordCallbackConfigPrintLog;
    private boolean wiredHeadsetHasMic = false;
    private static final int VOLUME_LOGGER_INTERVAL_MS = 5000;

    public static LavaAudioDeviceManager create(Context context) {
        return new LavaAudioDeviceManager(context);
    }

    @CalledByNative
    public static LavaAudioDeviceManager create() {
        return new LavaAudioDeviceManager(ContextUtils.getApplicationContext());
    }

    private LavaAudioDeviceManager(Context context) {
        ThreadUtils.checkIsOnUiThread();
        this.mContext = context;
        this.mAudioManager = (AudioManager)context.getSystemService("audio");
        this.mBluetoothManager = AbsBluetoothManager.create(context, this, 12000);
        this.mWiredHeadsetReceiver = new WiredHeadsetReceiver();
        this.mAudioManagerState = AudioManagerState.UNINITIALIZED;
        this.mVolumeLogger = new VolumeLogger(this.mAudioManager);
    }

    @CalledByNative
    public void start(final int defaultAudioDevice, final boolean enableCallProximity, final AudioManagerEvents audioManagerEvents, final int focusMode, final boolean isHFP) {
        Logging.i(TAG, "start , defaultAudioDevice: " + defaultAudioDevice + " , focusMode: " + focusMode + " , isHFP: " + isHFP);
        if (this.mAudioManagerState == AudioManagerState.RUNNING) {
            Logging.e(TAG, "AudioManager is already active");
            return;
        }
        this.saveAudioStatus();
        this.startTask = new CancelableTask("LavaAudioDeviceManager#start"){

            @Override
            public void action() {
                LavaAudioDeviceManager.this.startInner(defaultAudioDevice, enableCallProximity, audioManagerEvents, focusMode, isHFP, this);
            }
        };
        ThreadUtils.runOnUiThread(this.startTask);
    }

    private void startInner(int defaultAudioDevice, boolean enableCallProximity, AudioManagerEvents audioManagerEvents, int focusMode, boolean isHFP, CancelableTask startTask) {
        List configs;
        Logging.i(TAG, "AudioManager start inner , taskId: " + startTask.getTaskId());
        if (startTask.isCanceled()) {
            Logging.w(TAG, "AudioManager start inner , but task canceled , taskId: " + startTask.getTaskId());
            return;
        }
        ThreadUtils.checkIsOnUiThread();
        if (this.mAudioManagerState == AudioManagerState.RUNNING) {
            Logging.e(TAG, "AudioManager is already active");
            return;
        }
        if (Compatibility.runningOnOreoOrHigher()) {
            try {
                configs = this.mAudioManager.getActivePlaybackConfigurations();
                for (AudioPlaybackConfiguration apc : configs) {
                    Logging.i(TAG, "Active Playback: " + AudioDeviceUtils.audioPlaybackConfigurationToString(apc));
                }
            }
            catch (Exception exception) {
                Logging.e(TAG, "getActivePlaybackConfigurations exception:" + Log.getStackTraceString((Throwable)exception));
                return;
            }
        }
        if (Compatibility.runningOnNougatOrHigher()) {
            try {
                configs = this.mAudioManager.getActiveRecordingConfigurations();
                for (AudioRecordingConfiguration arc : configs) {
                    Logging.i(TAG, "Active Recording: " + AudioDeviceUtils.audioRecordingConfigurationToString(arc));
                }
            }
            catch (Exception exception) {
                Logging.e(TAG, "getActiveRecordingConfigurations exception:" + Log.getStackTraceString((Throwable)exception));
                return;
            }
        }
        this.playbackCallbackConfigPrintLog = null;
        this.recordCallbackConfigPrintLog = null;
        this.bluetoothTryReconnect = false;
        this.mAudioManagerEvents = audioManagerEvents;
        this.mAudioManagerState = AudioManagerState.RUNNING;
        if (this.mHandler != null) {
            LooperUtils.quitSafely(this.mHandler);
            this.mHandler = null;
        }
        HandlerThread handlerThread = new HandlerThread(TAG);
        handlerThread.start();
        this.mHandler = new Handler(handlerThread.getLooper());
        this.mHasWiredHeadset = this.hasWiredHeadset();
        this.registerAudioFocusRequest(true, AudioDeviceCompatibility.getStreamType(), focusMode);
        this.registerAudioDeviceCallback(true);
        this.registerAudioPlaybackCallback(true);
        this.registerAudioRecordingCallback(true);
        this.mVolumeLogger.start(audioManagerEvents);
        this.setMicrophoneMute(false);
        this.mUserSelectedAudioDevice = 0;
        this.mSelectedAudioDevice = 0;
        if (this.mDefaultAudioDevice == 0) {
            this.mDefaultAudioDevice = defaultAudioDevice;
        }
        this.mAudioDevices.clear();
        this.setAudioBlueToothSCO(isHFP);
        try {
            this.mBluetoothManager.start();
        }
        catch (Exception e) {
            Logging.e(TAG, "start bluetooth manager error, reason: " + Log.getStackTraceString((Throwable)e));
        }
        this.updateAudioDeviceState();
        this.mContext.registerReceiver((BroadcastReceiver)this.mWiredHeadsetReceiver, new IntentFilter("android.intent.action.HEADSET_PLUG"));
        if (enableCallProximity) {
            if (this.mCallProximityManager == null) {
                this.mCallProximityManager = new CallProximityManager(this.mContext, new CallProximityManager.ProximityDirector(){

                    @Override
                    public boolean shouldActivateProximity() {
                        return LavaAudioDeviceManager.this.proximityActivated();
                    }

                    @Override
                    public void onProximityTrackingChanged(boolean acquired) {
                        LavaAudioDeviceManager.this.onProximitySensorChangedState(acquired);
                    }
                });
            }
            this.mCallProximityManager.startTracking();
        }
        Logging.i(TAG, "AudioManager started");
        this.mHandler.post(() -> {
            AudioDeviceUtils.logAudioProfile(TAG, AudioDeviceCompatibility.getAudioMode(), AudioDeviceCompatibility.getStreamType(), AudioDeviceCompatibility.getAudioSource());
            AudioDeviceUtils.logAudioState(TAG);
        });
        if (startTask.isCanceled()) {
            Logging.w(TAG, "AudioManager started , but task canceled ,so call stop taskId:" + startTask.getTaskId());
            this.stopInner(false);
        }
    }

    @CalledByNative
    public void setMode(final int audioMode) {
        if (audioMode < 0 || audioMode > 3) {
            Logging.w(TAG, "setAudioMode invalid" + audioMode);
            return;
        }
        if (this.setModeTask != null) {
            this.setModeTask.cancel();
        }
        this.setModeTask = new CancelableTask("LavaAudioDeviceManager#setModeAsync"){

            @Override
            public void action() {
                if (LavaAudioDeviceManager.this.mAudioManagerState != AudioManagerState.RUNNING) {
                    Logging.w(LavaAudioDeviceManager.TAG, "dynamic set audio mode in incorrect state: " + (Object)((Object)LavaAudioDeviceManager.this.mAudioManagerState) + " , mode: " + AudioDeviceUtils.audioModeToString(audioMode));
                    return;
                }
                if (this.isCanceled()) {
                    Logging.w(LavaAudioDeviceManager.TAG, "dynamic set audio mode but cancel , mode: " + AudioDeviceUtils.audioModeToString(audioMode));
                    return;
                }
                LavaAudioDeviceManager.this.mAudioManager.setMode(audioMode);
                Logging.w(LavaAudioDeviceManager.TAG, "dynamic set audio mode: " + AudioDeviceUtils.audioModeToString(audioMode) + "  done");
            }
        };
        if (this.mHandler != null) {
            this.mHandler.post((Runnable)this.setModeTask);
        } else {
            this.setModeTask.run();
        }
    }

    @CalledByNative
    public void setAudioBlueToothSCO(boolean blueToothSCO) {
        if (this.mBluetoothManager == null) {
            Logging.w(TAG, "setAudioBlueToothSCO but NPL: " + blueToothSCO);
            return;
        }
        if (blueToothSCO && !SystemPermissionUtils.checkBluetoothScoConnectPermission(this.mContext)) {
            blueToothSCO = false;
            Logging.e(TAG, "setAudioBlueToothSCO no permission");
        }
        boolean reStartBlueTooth = this.mSelectedAudioDevice == 4 && blueToothSCO != this.mBluetoothManager.blueToothIsSCO();
        this.mBluetoothManager.setAudioBlueToothSCO(blueToothSCO);
        if (reStartBlueTooth) {
            this.reconnectBlueTooth();
        }
        Logging.i(TAG, "setAudioBlueToothSCO: " + blueToothSCO + " , re start: " + reStartBlueTooth);
    }

    public boolean isBlueToothInA2DP() {
        if (this.mBluetoothManager != null) {
            return !this.mBluetoothManager.blueToothIsSCO();
        }
        return false;
    }

    private void registerAudioFocusRequest(boolean register, int streamType, int focusMode) {
        if (register) {
            if (focusMode != 0 && this.mAudioFocusChangeListener == null) {
                this.mAudioFocusChangeListener = focusChange -> {
                    String typeOfChange = AudioDeviceUtils.audioFocusChangeToString(focusChange);
                    Logging.i(TAG, "onAudioFocusChange: " + typeOfChange);
                };
                int result = this.mAudioManager.requestAudioFocus(this.mAudioFocusChangeListener, streamType, focusMode);
                if (result == 1) {
                    Logging.i(TAG, "Audio focus request granted for " + AudioDeviceUtils.streamTypeToString(streamType));
                } else {
                    Logging.e(TAG, "Audio focus request failed");
                }
            }
        } else if (this.mAudioFocusChangeListener != null) {
            this.mAudioManager.abandonAudioFocus(this.mAudioFocusChangeListener);
            this.mAudioFocusChangeListener = null;
            Logging.i(TAG, "Abandoned audio focus ");
        }
    }

    @SuppressLint(value={"NewApi"})
    private void registerAudioRecordingCallback(boolean register) {
        if (Compatibility.runningOnNougatOrHigher()) {
            if (register) {
                if (this.mAudioRecordingCallback == null) {
                    this.mAudioRecordingCallback = new AudioManager.AudioRecordingCallback(){

                        public void onRecordingConfigChanged(List<AudioRecordingConfiguration> configs) {
                            String recordCallbackNewLog = " Recording Config Changed: ";
                            for (AudioRecordingConfiguration apc : configs) {
                                recordCallbackNewLog = recordCallbackNewLog + "\n";
                                recordCallbackNewLog = recordCallbackNewLog + AudioDeviceUtils.audioRecordingConfigurationToString(apc);
                            }
                            if (recordCallbackNewLog.equals(LavaAudioDeviceManager.this.recordCallbackConfigPrintLog)) {
                                return;
                            }
                            LavaAudioDeviceManager.this.recordCallbackConfigPrintLog = recordCallbackNewLog;
                            Logging.i(LavaAudioDeviceManager.TAG, recordCallbackNewLog);
                        }
                    };
                    this.mAudioManager.registerAudioRecordingCallback(this.mAudioRecordingCallback, this.mHandler);
                }
            } else if (this.mAudioRecordingCallback != null) {
                this.mAudioManager.unregisterAudioRecordingCallback(this.mAudioRecordingCallback);
                this.mAudioRecordingCallback = null;
            }
        }
    }

    @SuppressLint(value={"NewApi"})
    private void registerAudioPlaybackCallback(boolean register) {
        if (Compatibility.runningOnOreoOrHigher()) {
            if (register) {
                if (this.mAudioPlaybackCallback == null) {
                    this.mAudioPlaybackCallback = new AudioManager.AudioPlaybackCallback(){

                        public void onPlaybackConfigChanged(List<AudioPlaybackConfiguration> configs) {
                            String playbackCallbackNewLog = " Playback Config Changed: ";
                            for (AudioPlaybackConfiguration apc : configs) {
                                playbackCallbackNewLog = playbackCallbackNewLog + "\n";
                                playbackCallbackNewLog = playbackCallbackNewLog + AudioDeviceUtils.audioPlaybackConfigurationToString(apc);
                            }
                            if (playbackCallbackNewLog.equals(LavaAudioDeviceManager.this.playbackCallbackConfigPrintLog)) {
                                return;
                            }
                            LavaAudioDeviceManager.this.playbackCallbackConfigPrintLog = playbackCallbackNewLog;
                            Logging.i(LavaAudioDeviceManager.TAG, playbackCallbackNewLog);
                        }
                    };
                    this.mAudioManager.registerAudioPlaybackCallback(this.mAudioPlaybackCallback, this.mHandler);
                }
            } else if (this.mAudioPlaybackCallback != null) {
                this.mAudioManager.unregisterAudioPlaybackCallback(this.mAudioPlaybackCallback);
                this.mAudioPlaybackCallback = null;
            }
        }
    }

    @SuppressLint(value={"NewApi"})
    private void registerAudioDeviceCallback(boolean register) {
        if (Compatibility.runningOnMarshmallowOrHigher()) {
            if (register) {
                if (this.mAudioDeviceCallback == null) {
                    this.mAudioDeviceCallback = new AudioDeviceCallback(){

                        public void onAudioDevicesAdded(AudioDeviceInfo[] addedDevices) {
                            Logging.i(LavaAudioDeviceManager.TAG, "Audio Devices Added: ");
                            if (addedDevices == null || addedDevices.length == 0) {
                                Logging.i(LavaAudioDeviceManager.TAG, "    Devices info is null!!");
                            } else {
                                for (AudioDeviceInfo info : addedDevices) {
                                    Logging.i(LavaAudioDeviceManager.TAG, "  " + AudioDeviceUtils.audioDeviceInfoToString(info));
                                }
                            }
                        }

                        public void onAudioDevicesRemoved(AudioDeviceInfo[] removedDevices) {
                            Logging.i(LavaAudioDeviceManager.TAG, "Audio Devices Removed: ");
                            if (removedDevices == null || removedDevices.length == 0) {
                                Logging.i(LavaAudioDeviceManager.TAG, "    Devices info is null!!");
                            } else {
                                for (AudioDeviceInfo info : removedDevices) {
                                    Logging.i(LavaAudioDeviceManager.TAG, "    " + AudioDeviceUtils.audioDeviceInfoToString(info));
                                }
                            }
                        }
                    };
                    this.mAudioManager.registerAudioDeviceCallback(this.mAudioDeviceCallback, this.mHandler);
                }
            } else if (this.mAudioDeviceCallback != null) {
                this.mAudioManager.unregisterAudioDeviceCallback(this.mAudioDeviceCallback);
                this.mAudioDeviceCallback = null;
            }
        }
    }

    @CalledByNative
    public void stop(final boolean subExe) {
        Logging.i(TAG, "stop");
        CancelableTask task = this.startTask;
        boolean needRestore = false;
        if (task != null && !task.isCanceled()) {
            task.cancel();
            needRestore = true;
            Logging.i(TAG, "cancel start taskId :" + task.getTaskId());
        }
        if (this.setModeTask != null) {
            this.setModeTask.cancel();
        }
        if (this.mAudioManagerState != AudioManagerState.RUNNING) {
            if (needRestore) {
                this.restoreAudioStatus();
            }
            Logging.w(TAG, "Trying to stop AudioManager in incorrect state: " + (Object)((Object)this.mAudioManagerState) + " , restore: " + needRestore);
            return;
        }
        CancelableTask stopTask = new CancelableTask("LavaAudioDeviceManager#stop"){

            @Override
            public void action() {
                LavaAudioDeviceManager.this.stopInner(subExe);
            }
        };
        ThreadUtils.runOnUiThread(stopTask);
    }

    private void stopInner(boolean subExe) {
        Logging.i(TAG, "stopInner");
        ThreadUtils.checkIsOnUiThread();
        if (this.mAudioManagerState != AudioManagerState.RUNNING) {
            Logging.w(TAG, "Trying to stop AudioManager in incorrect state: " + (Object)((Object)this.mAudioManagerState));
            return;
        }
        this.mAudioManagerState = AudioManagerState.UNINITIALIZED;
        this.mVolumeLogger.stop();
        Logging.i(TAG, "stop volume logger done");
        try {
            this.mContext.unregisterReceiver((BroadcastReceiver)this.mWiredHeadsetReceiver);
        }
        catch (Exception e) {
            Logging.w(TAG, e.getMessage());
        }
        Logging.i(TAG, "stop unregister receiver done");
        try {
            this.mBluetoothManager.stop();
        }
        catch (Exception e) {
            Logging.i(TAG, "stop bluetooth error, reason: " + Log.getStackTraceString((Throwable)e));
        }
        this.registerAudioFocusRequest(false, 0, 0);
        this.registerAudioDeviceCallback(false);
        this.registerAudioPlaybackCallback(false);
        this.registerAudioRecordingCallback(false);
        if (this.mCallProximityManager != null) {
            this.mCallProximityManager.stopTracking();
        }
        if (subExe && this.mHandler != null) {
            if (!this.mHandler.post(this::restoreAudioStatus)) {
                Logging.i(TAG, "restoreAudioStatus exec failed.");
            }
        } else {
            this.restoreAudioStatus();
        }
        if (this.mHandler != null) {
            LooperUtils.quitSafely(this.mHandler);
            this.mHandler = null;
        }
        this.mAudioManagerEvents = null;
        this.mSelectedAudioDevice = 0;
        Logging.i(TAG, "AudioManager stopped inner");
    }

    private void setAudioDeviceInternal(int device) {
        Logging.i(TAG, "setAudioDeviceInternal(device=" + AudioDeviceUtils.audioDeviceToString(device) + ")");
        switch (device) {
            case 3: {
                this.setSpeakerphoneOn(true);
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                this.setSpeakerphoneOn(false);
                break;
            }
            default: {
                Logging.e(TAG, "Invalid audio device selection");
            }
        }
        this.mSelectedAudioDevice = device;
    }

    @CalledByNative
    public void setDefaultAudioDevice(int defaultDevice) {
        ThreadUtils.checkIsOnUiThread();
        switch (defaultDevice) {
            case 3: {
                this.mDefaultAudioDevice = defaultDevice;
                break;
            }
            case 2: {
                if (this.hasEarpiece()) {
                    this.mDefaultAudioDevice = defaultDevice;
                    break;
                }
                this.mDefaultAudioDevice = 3;
                break;
            }
            default: {
                Logging.e(TAG, "Invalid default audio device selection");
            }
        }
        Logging.i(TAG, "setDefaultAudioDevice(device=" + AudioDeviceUtils.audioDeviceToString(this.mDefaultAudioDevice) + ")");
        this.updateAudioDeviceState();
    }

    @CalledByNative
    public void selectAudioDevice(int device) {
        ThreadUtils.checkIsOnUiThread();
        Logging.i(TAG, "select audio device:" + AudioDeviceUtils.audioDeviceToString(device));
        if (!this.mAudioDevices.contains(device)) {
            Logging.e(TAG, "Can not select " + AudioDeviceUtils.audioDeviceToString(device) + " from available " + AudioDeviceUtils.audioDeviceToString(ArrayUtils.toPrimitive(this.mAudioDevices.toArray(new Integer[0]))));
            return;
        }
        this.mUserSelectedAudioDevice = device;
        this.updateAudioDeviceState();
    }

    @CalledByNative
    public void reconnectBlueTooth() {
        ThreadUtils.checkIsOnUiThread();
        this.bluetoothTryReconnect = true;
        this.updateAudioDeviceState();
        this.bluetoothTryReconnect = false;
    }

    public Set<Integer> getAudioDevices() {
        ThreadUtils.checkIsOnUiThread();
        return Collections.unmodifiableSet(new HashSet<Integer>(this.mAudioDevices));
    }

    @CalledByNative
    public int getSelectedAudioDevice() {
        ThreadUtils.checkIsOnUiThread();
        if (this.mSelectedAudioDevice != 0) {
            return this.mSelectedAudioDevice;
        }
        boolean hasWiredHeadset = false;
        boolean hasBluetooth = false;
        if (Compatibility.runningOnMarshmallowOrHigher()) {
            AudioDeviceInfo[] devices;
            for (AudioDeviceInfo deviceInfo : devices = this.mAudioManager.getDevices(2)) {
                int deviceInfoType = deviceInfo.getType();
                if (deviceInfoType == 3) {
                    hasWiredHeadset = true;
                    continue;
                }
                if (deviceInfoType != 8 && deviceInfoType != 7) continue;
                hasBluetooth = true;
            }
        }
        this.mHasWiredHeadset = hasWiredHeadset;
        if (hasWiredHeadset) {
            return 1;
        }
        if (hasBluetooth) {
            return 4;
        }
        if (this.mDefaultAudioDevice != 0) {
            return this.mDefaultAudioDevice;
        }
        return 3;
    }

    public void activateProximity(boolean enable) {
        Logging.i(TAG, "activate proximity :" + enable);
        this.mProximityActivated = enable;
    }

    private boolean proximityActivated() {
        return this.mProximityActivated;
    }

    private boolean hasWiredHeadset() {
        return this.mAudioManager.isWiredHeadsetOn();
    }

    private boolean hasEarpiece() {
        return this.mContext.getPackageManager().hasSystemFeature("android.hardware.telephony");
    }

    private void onProximitySensorChangedState(boolean nearState) {
        if (this.mAudioDevices.size() == 2 && this.mAudioDevices.contains(2) && this.mAudioDevices.contains(3)) {
            Logging.i(TAG, "onProximitySensorChangedState -> near: " + nearState);
            if (nearState) {
                if (this.mSelectedAudioDevice != 2) {
                    this.setAudioDeviceInternal(2);
                }
            } else {
                int newAudioDevice = this.mUserSelectedAudioDevice;
                if (newAudioDevice == 0) {
                    newAudioDevice = this.mDefaultAudioDevice;
                }
                if (newAudioDevice != this.mSelectedAudioDevice) {
                    this.setAudioDeviceInternal(newAudioDevice);
                }
            }
        } else {
            Logging.i(TAG, "onProximitySensorChangedState -> ignore");
        }
    }

    private void saveAudioStatus() {
        this.mSavedAudioMode = this.mAudioManager.getMode();
        this.mSavedIsSpeakerPhoneOn = this.mAudioManager.isSpeakerphoneOn();
        this.mSavedIsMicrophoneMute = this.mAudioManager.isMicrophoneMute();
        Logging.i(TAG, "save system audio state[audio mode:" + AudioDeviceUtils.audioModeToString(this.mSavedAudioMode) + ", microphone mute:" + this.mSavedIsMicrophoneMute + ", speakerphone on:" + this.mSavedIsSpeakerPhoneOn + "]");
    }

    private void restoreAudioStatus() {
        this.setMicrophoneMute(this.mSavedIsMicrophoneMute);
        Logging.i(TAG, "restore setMicrophoneMute done");
        if (this.mSelectedAudioDevice == 2) {
            this.setSpeakerphoneOn(true);
            Logging.i(TAG, "restore setSpeakerphoneOn done");
        }
        if (this.mSavedAudioMode != -2) {
            this.mAudioManager.setMode(this.mSavedAudioMode);
        }
        Logging.i(TAG, "restore system audio state[audio mode:" + AudioDeviceUtils.audioModeToString(this.mSavedAudioMode) + ", microphone mute:" + this.mSavedIsMicrophoneMute + "]");
    }

    private void setSpeakerphoneOn(boolean on) {
        this.mAudioManager.setSpeakerphoneOn(on);
        Logging.i(TAG, "setSpeakerphoneOn " + on + " ,result -> " + this.mAudioManager.isSpeakerphoneOn());
    }

    private void setMicrophoneMute(boolean on) {
        boolean wasMuted = this.mAudioManager.isMicrophoneMute();
        if (wasMuted == on) {
            return;
        }
        this.mAudioManager.setMicrophoneMute(on);
    }

    @CalledByNative
    private boolean isSpeakerPhoneOn() {
        Logging.w(TAG, "isSpeakerPhoneOn , state :" + (this.mSelectedAudioDevice == 3));
        return this.mSelectedAudioDevice == 3;
    }

    void updateAudioDeviceState() {
        boolean bluetoothReconnected;
        boolean deviceChanged;
        if (this.mAudioManagerState != AudioManagerState.RUNNING) {
            Logging.w(TAG, "updateAudioDeviceState , but state is :" + (Object)((Object)this.mAudioManagerState));
            return;
        }
        ThreadUtils.checkIsOnUiThread();
        Logging.i(TAG, "updateAudioDeviceState current device status: wired headset=" + this.mHasWiredHeadset + ", reconnect=" + this.bluetoothTryReconnect + ", bluetooth state=" + (Object)((Object)this.mBluetoothManager.getState()) + ", available=" + AudioDeviceUtils.audioDeviceToString(ArrayUtils.toPrimitive(this.mAudioDevices.toArray(new Integer[0]))) + ", pre worked=" + AudioDeviceUtils.audioDeviceToString(this.mSelectedAudioDevice) + ", user selected=" + AudioDeviceUtils.audioDeviceToString(this.mUserSelectedAudioDevice));
        if (this.bluetoothTryReconnect && this.mBluetoothManager.getState() == AbsBluetoothManager.State.UNINITIALIZED) {
            this.bluetoothTryReconnect = false;
        }
        if (this.mBluetoothManager.getState() == AbsBluetoothManager.State.HEADSET_AVAILABLE || this.mBluetoothManager.getState() == AbsBluetoothManager.State.HEADSET_UNAVAILABLE || this.mBluetoothManager.getState() == AbsBluetoothManager.State.SCO_DISCONNECTING || this.bluetoothTryReconnect) {
            try {
                this.mBluetoothManager.updateDevice();
            }
            catch (Exception e) {
                Logging.e(TAG, "update device error, reason: " + Log.getStackTraceString((Throwable)e));
            }
        }
        HashSet<Integer> newAudioDevices = new HashSet<Integer>();
        if (this.mBluetoothManager.getState() == AbsBluetoothManager.State.SCO_CONNECTED || this.mBluetoothManager.getState() == AbsBluetoothManager.State.SCO_CONNECTING || this.mBluetoothManager.getState() == AbsBluetoothManager.State.HEADSET_AVAILABLE) {
            newAudioDevices.add(4);
        }
        if (this.mHasWiredHeadset) {
            newAudioDevices.add(1);
        } else {
            newAudioDevices.add(3);
            if (this.hasEarpiece()) {
                newAudioDevices.add(2);
            }
        }
        boolean audioDeviceSetUpdated = !this.mAudioDevices.equals(newAudioDevices);
        this.mAudioDevices = newAudioDevices;
        int userSelectedRet = this.mUserSelectedAudioDevice;
        if (this.mUserSelectedAudioDevice == 4 && (this.mBluetoothManager.getState() == AbsBluetoothManager.State.HEADSET_UNAVAILABLE || this.mBluetoothManager.getState() == AbsBluetoothManager.State.UNINITIALIZED)) {
            userSelectedRet = 0;
        }
        if (!this.mHasWiredHeadset && this.mUserSelectedAudioDevice == 1) {
            userSelectedRet = 0;
        }
        int newAudioDevice = this.mDefaultAudioDevice;
        if (userSelectedRet != 0) {
            newAudioDevice = userSelectedRet;
        } else if (this.mHasWiredHeadset) {
            newAudioDevice = 1;
        } else if (this.mBluetoothManager.getState() != AbsBluetoothManager.State.HEADSET_UNAVAILABLE && this.mBluetoothManager.getState() != AbsBluetoothManager.State.UNINITIALIZED) {
            newAudioDevice = 4;
        }
        boolean needStopBluetooth = (this.mBluetoothManager.getState() == AbsBluetoothManager.State.SCO_CONNECTED || this.mBluetoothManager.getState() == AbsBluetoothManager.State.SCO_CONNECTING) && newAudioDevice != 0 && newAudioDevice != 4;
        boolean needStartBluetooth = this.mBluetoothManager.getState() == AbsBluetoothManager.State.HEADSET_AVAILABLE && (newAudioDevice == 0 || newAudioDevice == 4);
        Logging.i(TAG, "updateAudioDeviceState bluetooth audio: start=" + needStartBluetooth + ", stop=" + needStopBluetooth + ", state=" + (Object)((Object)this.mBluetoothManager.getState()) + ", userSelectedRet=" + AudioDeviceUtils.audioDeviceToString(userSelectedRet));
        boolean bl = deviceChanged = newAudioDevice != this.mSelectedAudioDevice || audioDeviceSetUpdated;
        if (deviceChanged) {
            this.setAudioDeviceInternal(newAudioDevice);
            Logging.i(TAG, "updateAudioDeviceState new device status: available=" + AudioDeviceUtils.audioDeviceToString(ArrayUtils.toPrimitive(this.mAudioDevices.toArray(new Integer[0]))) + " , selected=" + AudioDeviceUtils.audioDeviceToString(newAudioDevice));
        }
        if (needStopBluetooth) {
            try {
                this.mBluetoothManager.stopScoAudio();
                this.mBluetoothManager.updateDevice();
            }
            catch (Exception e) {
                Logging.e(TAG, "update device error, reason: " + Log.getStackTraceString((Throwable)e));
            }
        }
        if (this.bluetoothTryReconnect || needStartBluetooth) {
            try {
                if (!this.mBluetoothManager.startScoAudio()) {
                    this.mAudioDevices.remove(4);
                }
            }
            catch (Exception e) {
                Logging.e(TAG, "start sco audio error, reason: " + Log.getStackTraceString((Throwable)e));
            }
        }
        boolean bl2 = bluetoothReconnected = newAudioDevice == 4 && this.bluetoothTryReconnect;
        if ((deviceChanged || bluetoothReconnected) && this.mAudioManagerEvents != null) {
            this.mAudioManagerEvents.onAudioDeviceChanged(this.mSelectedAudioDevice, this.mAudioDevices, this.hasExternalMic(newAudioDevice));
        }
        Logging.i(TAG, "updateAudioDeviceState done");
    }

    private boolean hasExternalMic(int selectedAudioDevice) {
        boolean hasExternalMic = false;
        if (Compatibility.runningOnMarshmallowOrHigher()) {
            AudioDeviceInfo[] devices;
            for (AudioDeviceInfo deviceInfo : devices = this.mAudioManager.getDevices(1)) {
                if ((deviceInfo.getType() != 3 || selectedAudioDevice != 1) && (deviceInfo.getType() != 7 || selectedAudioDevice != 4)) continue;
                hasExternalMic = true;
                break;
            }
        } else if (selectedAudioDevice == 1) {
            hasExternalMic = this.wiredHeadsetHasMic;
        } else if (selectedAudioDevice == 4) {
            hasExternalMic = true;
        }
        Logging.i(TAG, "hasExternalMic : " + hasExternalMic + " , selectedAudioDevice: " + AudioDeviceUtils.audioDeviceToString(selectedAudioDevice));
        return hasExternalMic;
    }

    private static class VolumeLogger {
        private static final String THREAD_NAME = "VolumeLogger";
        private final AudioManager audioManager;
        private Timer timer;
        private AudioManagerEvents audioManagerEvents;
        private LogVolumeTask logVolumeTask;

        VolumeLogger(AudioManager audioManager) {
            this.audioManager = audioManager;
        }

        public void start(AudioManagerEvents audioManagerEvents) {
            this.timer = new Timer(THREAD_NAME);
            this.logVolumeTask = new LogVolumeTask(this.audioManager.getStreamMaxVolume(2), this.audioManager.getStreamMaxVolume(0), this.audioManager.getStreamMaxVolume(3));
            this.timer.schedule((TimerTask)this.logVolumeTask, 5000L, 5000L);
            this.audioManagerEvents = audioManagerEvents;
            AudioDeviceCompatibility.addObserver(this.logVolumeTask);
        }

        private void tryNotifyVolumeChange(int streamType, int volume, int maxVolume) {
            if (AudioDeviceCompatibility.getStreamType() != streamType) {
                return;
            }
            AudioManagerEvents audioManagerEvents = this.audioManagerEvents;
            if (audioManagerEvents == null) {
                return;
            }
            audioManagerEvents.onVolumeChange(volume, maxVolume);
        }

        private void stop() {
            AudioDeviceCompatibility.removeObserver(this.logVolumeTask);
            if (this.timer != null) {
                this.timer.cancel();
                this.timer = null;
            }
            this.audioManagerEvents = null;
        }

        private class LogVolumeTask
        extends TimerTask
        implements AudioDeviceCompatibility.AudioDeviceCompatibilityObserver {
            private final int maxRingVolume;
            private final int maxVoiceCallVolume;
            private final int maxMusicVolume;
            private int currentRingVolume;
            private int currentVoiceCallVolume;
            private int currentMusicVolume;
            private int currentMode = -1;

            LogVolumeTask(int maxRingVolume, int maxVoiceCallVolume, int maxMusicVolume) {
                this.maxRingVolume = maxRingVolume;
                this.maxVoiceCallVolume = maxVoiceCallVolume;
                this.maxMusicVolume = maxMusicVolume;
            }

            @Override
            public void run() {
                int ringVolume = VolumeLogger.this.audioManager.getStreamVolume(2);
                int voiceCallVolume = VolumeLogger.this.audioManager.getStreamVolume(0);
                int musicVolume = VolumeLogger.this.audioManager.getStreamVolume(3);
                if (ringVolume != this.currentRingVolume) {
                    Logging.i(LavaAudioDeviceManager.TAG, "STREAM_RING stream volume: " + ringVolume + " (max=" + this.maxRingVolume + ")");
                    this.currentRingVolume = ringVolume;
                    VolumeLogger.this.tryNotifyVolumeChange(2, ringVolume, this.maxRingVolume);
                }
                if (voiceCallVolume != this.currentVoiceCallVolume) {
                    Logging.i(LavaAudioDeviceManager.TAG, "VOICE_CALL stream volume: " + voiceCallVolume + " (max=" + this.maxVoiceCallVolume + ")");
                    this.currentVoiceCallVolume = voiceCallVolume;
                    VolumeLogger.this.tryNotifyVolumeChange(0, voiceCallVolume, this.maxVoiceCallVolume);
                }
                if (musicVolume != this.currentMusicVolume) {
                    Logging.i(LavaAudioDeviceManager.TAG, "STREAM_MUSIC stream volume: " + musicVolume + " (max=" + this.maxMusicVolume + ")");
                    this.currentMusicVolume = musicVolume;
                    VolumeLogger.this.tryNotifyVolumeChange(3, musicVolume, this.maxMusicVolume);
                }
            }

            @Override
            public void onChanged(int audioSource, int streamType, int audioMode) {
                if (this.currentMode != audioMode) {
                    this.currentMode = -1;
                }
            }
        }
    }

    private class WiredHeadsetReceiver
    extends BroadcastReceiver {
        private static final int STATE_UNPLUGGED = 0;
        private static final int STATE_PLUGGED = 1;
        private static final int HAS_NO_MIC = 0;
        private static final int HAS_MIC = 1;

        private WiredHeadsetReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            int state = intent.getIntExtra("state", 0);
            int microphone = intent.getIntExtra("microphone", 0);
            String name = intent.getStringExtra("name");
            Logging.i(LavaAudioDeviceManager.TAG, "WiredHeadsetReceiver.onReceive: a=" + intent.getAction() + ", s=" + (state == 0 ? "unplugged" : "plugged") + ", m=" + (microphone == 1 ? "mic" : "no mic") + ", n=" + name + ", sb=" + this.isInitialStickyBroadcast());
            LavaAudioDeviceManager.this.mHasWiredHeadset = state == 1;
            if (LavaAudioDeviceManager.this.mHasWiredHeadset) {
                // empty if block
            }
            LavaAudioDeviceManager.this.wiredHeadsetHasMic = state == 1 && microphone == 1;
            LavaAudioDeviceManager.this.updateAudioDeviceState();
        }
    }

    public static interface AudioManagerEvents {
        public void onAudioDeviceChanged(int var1, Set<Integer> var2, boolean var3);

        public void onVolumeChange(int var1, int var2);

        public void onAudioModeChange(int var1);
    }

    private static enum AudioManagerState {
        UNINITIALIZED,
        RUNNING;

    }

    public static interface AudioDevice {
        public static final int SPEAKER_PHONE = 3;
        public static final int WIRED_HEADSET = 1;
        public static final int EARPIECE = 2;
        public static final int BLUETOOTH = 4;
        public static final int NONE = 0;
    }
}

