/*
 * Decompiled with CFR 0.152.
 */
package com.netease.yunxin.lite.audio.earback;

import android.content.Context;
import android.os.Build;
import android.util.Log;
import com.netease.lava.webrtc.CalledByNative;
import com.netease.lava.webrtc.Logging;
import com.netease.lava.webrtc.voiceengine.IHardwareEarback;
import com.netease.yunxin.lite.annotation.Keep;
import com.netease.yunxin.lite.audio.earback.HuaweiEarBackImpl;
import com.netease.yunxin.lite.audio.earback.HuaweiEmptyImpl;
import com.netease.yunxin.lite.util.ContextUtils;

@Keep
public class HardwareEarBackManager {
    private static final String TAG = "HardwareEarBackManager";
    private final IHardwareEarback hardwareEarBack = HardwareEarBackManager.createHardwareEarBackInstance(ContextUtils.getContext());

    @CalledByNative
    public HardwareEarBackManager() {
        Logging.i(TAG, "hardwareEarBack: " + this.hardwareEarBack);
    }

    @CalledByNative
    public boolean isEarBackSupported() {
        return this.hardwareEarBack.isEarBackSupported();
    }

    @CalledByNative
    public int setEarBackVolume(int volume) {
        return this.hardwareEarBack.setEarBackVolume(volume);
    }

    @CalledByNative
    public int enableHardwareEarBack(boolean enable, int volume) {
        int ret = 0;
        if (enable) {
            ret = this.hardwareEarBack.startHardwareEarBack();
            if (ret == 0) {
                if (volume < 0) {
                    volume = 0;
                }
                if (volume > 100) {
                    volume = 100;
                }
                ret = this.hardwareEarBack.setEarBackVolume(volume);
            }
        } else {
            ret = this.hardwareEarBack.stopHardwareEarBack();
        }
        return ret;
    }

    private static IHardwareEarback createHardwareEarBackInstance(Context context) {
        if (context == null) {
            return HuaweiEmptyImpl.getInstance(null);
        }
        if (!Build.BRAND.toLowerCase().contains("huawei") && !Build.MANUFACTURER.toLowerCase().contains("huawei")) {
            return HuaweiEmptyImpl.getInstance(context);
        }
        Class<?> akClass = null;
        try {
            akClass = Class.forName("com.huawei.multimedia.audiokit.interfaces.HwAudioKit");
        }
        catch (ClassNotFoundException e) {
            Logging.w(TAG, "exception:  :" + Log.getStackTraceString((Throwable)e) + " class: " + akClass);
        }
        return akClass != null ? HuaweiEarBackImpl.getInstance(context) : HuaweiEmptyImpl.getInstance(context);
    }
}

