/*
 * Decompiled with CFR 0.152.
 */
package com.netease.yunxin.lite.audio.earback;

import android.content.Context;
import android.util.Log;
import com.huawei.multimedia.audiokit.interfaces.HwAudioKaraokeFeatureKit;
import com.huawei.multimedia.audiokit.interfaces.HwAudioKit;
import com.huawei.multimedia.audiokit.interfaces.IAudioKitCallback;
import com.netease.lava.webrtc.Logging;
import com.netease.lava.webrtc.voiceengine.IHardwareEarback;

public class HuaweiEarBackImpl
implements IHardwareEarback {
    private static final String TAG = "HardwareEarBack-Huawei";
    public static final int HW_AUDIOKIT_READY = 1;
    public static final int HW_AUDIOKIT_RELEASED = 2;
    public static final int HW_AUDIOKIT_KARAOKE_READY = 3;
    private boolean isPlatformSupported = false;
    private HwAudioKit mHwAudioKit;
    private HwAudioKaraokeFeatureKit mHwAudioKaraokeFeatureKit;
    private int mState = 30004;
    private Context mContext;
    private static volatile HuaweiEarBackImpl mInstance = null;
    private final IAudioKitCallback iAudioKitCallback = new IAudioKitCallback(){

        public void onResult(int resultType) {
            try {
                switch (resultType) {
                    case 0: {
                        HuaweiEarBackImpl.this.mState = 1;
                        HuaweiEarBackImpl.this.isPlatformSupported = HuaweiEarBackImpl.this.mHwAudioKit.isFeatureSupported(HwAudioKit.FeatureType.HWAUDIO_FEATURE_KARAOKE);
                        break;
                    }
                    case 1000: {
                        HuaweiEarBackImpl.this.mState = 3;
                        HuaweiEarBackImpl.this.isPlatformSupported = true;
                        break;
                    }
                    default: {
                        HuaweiEarBackImpl.this.mState = 30004;
                    }
                }
                Logging.i(HuaweiEarBackImpl.TAG, "huawei ear back support check ret: " + HuaweiEarBackImpl.this.isPlatformSupported + " , type: " + HuaweiEarBackImpl.this.mState);
            }
            catch (Exception e) {
                Logging.e(HuaweiEarBackImpl.TAG, "onResult exception: " + e.getMessage());
            }
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HuaweiEarBackImpl getInstance(Context context) {
        if (mInstance != null) return mInstance;
        Class<HuaweiEarBackImpl> clazz = HuaweiEarBackImpl.class;
        synchronized (HuaweiEarBackImpl.class) {
            if (mInstance != null) return mInstance;
            mInstance = new HuaweiEarBackImpl(context.getApplicationContext());
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return mInstance;
        }
    }

    private HuaweiEarBackImpl(Context context) {
        try {
            this.mContext = context;
            this.mHwAudioKit = new HwAudioKit(this.mContext, this.iAudioKitCallback);
            this.mHwAudioKit.initialize();
            this.mHwAudioKaraokeFeatureKit = (HwAudioKaraokeFeatureKit)this.mHwAudioKit.createFeature(HwAudioKit.FeatureType.HWAUDIO_FEATURE_KARAOKE);
        }
        catch (Exception e) {
            Logging.e(TAG, "HuaweiEarBackImpl  exception: " + e.getMessage());
        }
    }

    protected void finalize() throws Throwable {
        if (this.mHwAudioKit != null) {
            this.mHwAudioKit.destroy();
        }
        if (this.mHwAudioKaraokeFeatureKit != null) {
            this.mHwAudioKaraokeFeatureKit.destroy();
        }
        Log.i((String)TAG, (String)("finalize \uff0cstate: " + this.mState));
        super.finalize();
    }

    @Override
    public boolean isEarBackSupported() {
        return this.isPlatformSupported;
    }

    @Override
    public int setEarBackVolume(int volume) {
        if (this.mHwAudioKaraokeFeatureKit == null) {
            return 30004;
        }
        try {
            int ret = this.mHwAudioKaraokeFeatureKit.setParameter(HwAudioKaraokeFeatureKit.ParameName.CMD_SET_VOCAL_VOLUME_BASE, volume);
            if (ret != 0) {
                Logging.w(TAG, "setEarBackVolume failed, ret: " + ret);
                return 30001;
            }
        }
        catch (Exception e) {
            Logging.e(TAG, "setEarBackVolume  exception: " + e.getMessage());
        }
        return 0;
    }

    @Override
    public int startHardwareEarBack() {
        if (this.mHwAudioKaraokeFeatureKit == null) {
            return 30004;
        }
        try {
            int ret = this.mHwAudioKaraokeFeatureKit.enableKaraokeFeature(true);
            if (ret != 0) {
                Logging.w(TAG, "startHardwareEarBack failed, ret: " + ret);
                return 30001;
            }
        }
        catch (Exception e) {
            Logging.e(TAG, "startHardwareEarBack  exception: " + e.getMessage());
        }
        return 0;
    }

    @Override
    public int stopHardwareEarBack() {
        if (this.mHwAudioKaraokeFeatureKit == null) {
            return 30004;
        }
        try {
            int ret = this.mHwAudioKaraokeFeatureKit.enableKaraokeFeature(false);
            if (ret != 0) {
                Logging.w(TAG, "stopHardwareEarBack failed, ret: " + ret);
                return 30001;
            }
        }
        catch (Exception e) {
            Logging.e(TAG, "stopHardwareEarBack  exception: " + e.getMessage());
        }
        return 0;
    }
}

