/*
 * Decompiled with CFR 0.152.
 */
package com.netease.yunxin.lite.mediaproject;

import android.content.Intent;
import android.media.projection.MediaProjection;
import android.media.projection.MediaProjectionManager;
import android.os.Build;
import com.netease.lava.webrtc.Logging;
import com.netease.lava.webrtc.voiceengine.WebRtcAudioLoopBack;
import com.netease.yunxin.lite.util.ContextUtils;
import com.netease.yunxin.lite.video.device.screencapture.ScreenCapturerAndroid;

public class MediaProjectionCallback
implements ScreenCapturerAndroid.ScreenCapturerIntentCallback,
WebRtcAudioLoopBack.WebRtcAudioLoopBackIntentCallback {
    private final String TAG = "MediaProjectionCallback";
    private MediaProjection mMediaProjection;
    private Intent mIntent;
    private int mIntentUseCount = 0;

    MediaProjectionCallback(Intent intent) {
        Logging.i("MediaProjectionCallback", "create  MediaProjectionCallback" + intent);
        this.mIntent = intent;
    }

    public void updateIntent(Intent intent) {
        Logging.i("MediaProjectionCallback", "updateIntent: " + intent);
        if (this.mIntent != intent) {
            this.mIntent = intent;
            this.mMediaProjection = null;
            this.mIntentUseCount = 0;
            Logging.i("MediaProjectionCallback", "updateIntent intent is change, update " + intent);
        }
    }

    @Override
    public MediaProjection onWebRtcAudioLoopBackNeedIntent() {
        Logging.i("MediaProjectionCallback", "onWebRtcAudioLoopBackNeedIntent");
        return this.getMediaProjection();
    }

    @Override
    public void stopAudioLoopBack() {
        Logging.i("MediaProjectionCallback", "stopAudioLoopBack");
        this.stopMediaProjection();
    }

    @Override
    public MediaProjection onScreenCapturerNeedIntent() {
        Logging.i("MediaProjectionCallback", "onScreenCapturerNeedIntent");
        return this.getMediaProjection();
    }

    @Override
    public void stopScreenCapture() {
        Logging.i("MediaProjectionCallback", "stopScreenCapture");
        this.stopMediaProjection();
    }

    private MediaProjection getMediaProjection() {
        ++this.mIntentUseCount;
        this.createMediaProjection();
        return this.mMediaProjection;
    }

    private void stopMediaProjection() {
        --this.mIntentUseCount;
        this.stopMediaProjectionIfNeed();
    }

    private void createMediaProjection() {
        if (Build.VERSION.SDK_INT >= 21 && this.mMediaProjection == null) {
            MediaProjectionManager mediaProjectionManager = (MediaProjectionManager)ContextUtils.getContext().getSystemService("media_projection");
            this.mMediaProjection = mediaProjectionManager.getMediaProjection(-1, this.mIntent);
        }
    }

    private void stopMediaProjectionIfNeed() {
        Logging.i("MediaProjectionCallback", "stopMediaProjectionIfNeed");
        if (this.mIntentUseCount <= 0 && this.mMediaProjection != null) {
            Logging.i("MediaProjectionCallback", "stopMediaProjectionIfNeed count<=0 so stop mediaProjection");
            if (Build.VERSION.SDK_INT >= 21) {
                this.mMediaProjection.stop();
            }
            this.mMediaProjection = null;
        }
    }
}

