/*
 * Decompiled with CFR 0.152.
 */
package com.netease.yunxin.lite.unity;

import android.content.Context;
import android.util.Log;
import com.netease.lava.webrtc.Logging;
import com.netease.yunxin.lite.annotation.Keep;
import com.netease.yunxin.lite.util.ContextUtils;
import com.netease.yunxin.lite.util.NativeLibLoader;

@Keep
public class UnityUtility {
    private static final String TAG = "UnityUtility";
    private static volatile boolean sInitialized = false;

    @Keep
    public static synchronized void initialize(Context context) {
        Log.i((String)TAG, (String)("initialize, context:" + context));
        if (context == null) {
            throw new NullPointerException("context is null");
        }
        if (sInitialized) {
            return;
        }
        ContextUtils.setContext(context);
        Log.i((String)TAG, (String)("Loading library nertc-c-sdk level:" + (Object)((Object)Logging.Severity.LS_INFO)));
        try {
            System.loadLibrary("nertc-c-sdk");
            Log.i((String)TAG, (String)"Loaded library nertc-c-sdk");
        }
        catch (UnsatisfiedLinkError error) {
            Log.e((String)TAG, (String)"Failed to load native library nertc-c-sdk");
        }
        NativeLibLoader.loadLibrary("NERtcFaceDetect");
        NativeLibLoader.loadLibrary("NERtcBeauty");
        NativeLibLoader.loadLibrary("NERtcPersonSegment");
        NativeLibLoader.loadLibrary("NERtcFaceEnhance");
        NativeLibLoader.loadLibrary("NERtcVideoDenoise");
        NativeLibLoader.loadLibrary("NERtcSuperResolution");
        NativeLibLoader.loadLibrary("NERtcnn");
        NativeLibLoader.loadLibrary("NERtcAiHowling");
        NativeLibLoader.loadLibrary("NERtcAiDenoise");
        NativeLibLoader.loadLibrary("NERtcAudio3D");
        Logging.enableLogToDebugOutput(Logging.Severity.LS_INFO);
        Log.i((String)TAG, (String)"initialized");
        sInitialized = true;
    }
}

