/*
 * Decompiled with CFR 0.152.
 */
package com.netease.yunxin.lite.util;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Environment;
import com.netease.yunxin.lite.util.FileUtil;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;

public class BeautyFileUtil {
    public static final String MODEL_NAME = "model.dat";
    public static final String LICENSE_NAME = "netease.lic";
    private static final String TAG = "BeautyFileUtil";

    public static ArrayList<String> copyStickerFiles(Context context) {
        String[] files = null;
        ArrayList<String> zipfiles = new ArrayList<String>();
        try {
            files = context.getAssets().list("");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String folderPath = null;
        File dataDir = context.getExternalFilesDir(null);
        if (dataDir != null) {
            folderPath = dataDir.getAbsolutePath();
        }
        for (int i = 0; i < files.length; ++i) {
            String str = files[i];
            if (!str.contains(".zip")) continue;
            BeautyFileUtil.copyFileIfNeed(context, str, false);
        }
        File file = new File(folderPath);
        File[] subFile = file.listFiles();
        for (int i = 0; i < subFile.length; ++i) {
            if (subFile[i].isDirectory()) continue;
            String filename = subFile[i].getAbsolutePath();
            String path = subFile[i].getPath();
            if (!filename.trim().toLowerCase().endsWith(".zip")) continue;
            zipfiles.add(filename);
        }
        return zipfiles;
    }

    public static boolean copyFileIfNeed(Context context, String fileName, boolean force) {
        String path = BeautyFileUtil.getFilePath(context, fileName);
        if (path == null) {
            return false;
        }
        File file = new File(path);
        if (!file.exists() || force) {
            try {
                int n;
                if (file.exists()) {
                    file.delete();
                }
                file.createNewFile();
                InputStream in = context.getApplicationContext().getAssets().open(fileName);
                if (in == null) {
                    return false;
                }
                FileOutputStream out = new FileOutputStream(file);
                byte[] buffer = new byte[4096];
                while ((n = in.read(buffer)) > 0) {
                    ((OutputStream)out).write(buffer, 0, n);
                }
                in.close();
                ((OutputStream)out).close();
            }
            catch (IOException e) {
                file.delete();
                return false;
            }
        }
        return true;
    }

    public static boolean copyFileIfNeed(Context context, String fileName, String className) {
        File file;
        String path = BeautyFileUtil.getFilePath(context, className + File.separator + fileName);
        if (path != null && !(file = new File(path)).exists()) {
            try {
                int n;
                if (file.exists()) {
                    file.delete();
                }
                file.createNewFile();
                InputStream in = context.getAssets().open(className + File.separator + fileName);
                if (in == null) {
                    return false;
                }
                FileOutputStream out = new FileOutputStream(file);
                byte[] buffer = new byte[4096];
                while ((n = in.read(buffer)) > 0) {
                    ((OutputStream)out).write(buffer, 0, n);
                }
                in.close();
                ((OutputStream)out).close();
            }
            catch (IOException e) {
                file.delete();
                return false;
            }
        }
        return true;
    }

    public static String getFilePath(Context context, String fileName) {
        String path = null;
        File dataDir = context.getApplicationContext().getExternalFilesDir(null);
        if (dataDir != null) {
            path = dataDir.getAbsolutePath() + File.separator + fileName;
        }
        return path;
    }

    public static File getOutputMediaFile() {
        File mediaStorageDir = new File(Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_DCIM), "Camera");
        if (!mediaStorageDir.exists() && !mediaStorageDir.mkdirs()) {
            return null;
        }
        String timeStamp = new SimpleDateFormat("yyyyMMdd_HHmmss", Locale.CHINESE).format(new Date());
        File mediaFile = new File(mediaStorageDir.getPath() + File.separator + "IMG_" + timeStamp + ".jpg");
        return mediaFile;
    }

    public static void copyModelFiles(Context context) {
        BeautyFileUtil.copyFileIfNeed(context, MODEL_NAME, false);
        BeautyFileUtil.copyFileIfNeed(context, LICENSE_NAME, false);
    }

    public static void copyStickerFiles(Context context, String index) {
        BeautyFileUtil.copyStickerZipFiles(context, index);
        BeautyFileUtil.copyStickerIconFiles(context, index);
    }

    public static void copyFilterFiles(Context context, String index) {
        BeautyFileUtil.copyFilterModelFiles(context, index);
        BeautyFileUtil.copyFilterIconFiles(context, index);
    }

    public static int copyAllFiles(Context context, String className, boolean force) {
        String[] files = null;
        try {
            files = context.getAssets().list(className);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (files == null) {
            return -1;
        }
        if (files.length > 0) {
            String folderPath;
            File folder;
            File dataDir = context.getExternalFilesDir(null);
            if (dataDir != null && !(folder = new File(folderPath = dataDir.getAbsolutePath() + File.separator + className)).exists()) {
                folder.mkdir();
            }
            for (String fileName : files) {
                BeautyFileUtil.copyAllFiles(context, className + File.separator + fileName, force);
            }
        } else {
            BeautyFileUtil.copyFileIfNeed(context, className, force);
        }
        return files.length;
    }

    public static String copyAssetDirFilesRetDir(Context context, String path) {
        String[] files;
        try {
            files = context.getAssets().list(path);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        if (files == null) {
            return null;
        }
        if (files.length > 0) {
            File folder;
            String folderPath = null;
            File dataDir = context.getExternalFilesDir(null);
            String dataDirPath = null;
            if (dataDir != null && !(folder = new File(folderPath = (dataDirPath = dataDir.getAbsolutePath()) + File.separator + path)).exists()) {
                folder.mkdir();
            }
            for (String fileName : files) {
                String tmpStr = path + File.separator + fileName;
                int n = BeautyFileUtil.copyAllFiles(context, tmpStr, false);
            }
            path = folderPath;
        }
        return path;
    }

    public static List<String> copyAllFilesRetDirs(Context context, String className) {
        String[] files;
        ArrayList<String> dirs = new ArrayList<String>();
        try {
            files = context.getAssets().list(className);
        }
        catch (Exception e) {
            e.printStackTrace();
            return dirs;
        }
        if (files.length > 0) {
            File folder;
            String folderPath = null;
            File dataDir = context.getExternalFilesDir(null);
            String dataDirPath = null;
            if (dataDir != null && !(folder = new File(folderPath = (dataDirPath = dataDir.getAbsolutePath()) + File.separator + className)).exists()) {
                folder.mkdir();
            }
            for (String fileName : files) {
                String tmpStr = className + File.separator + fileName;
                int num = BeautyFileUtil.copyAllFiles(context, tmpStr, false);
                if (num <= 0) continue;
                dirs.add(dataDirPath + File.separator + tmpStr);
            }
        } else {
            BeautyFileUtil.copyFileIfNeed(context, className, false);
        }
        return dirs;
    }

    public static List<String> copyStickerZipFiles(Context context, String className) {
        File folder;
        String[] files = null;
        ArrayList<String> modelFiles = new ArrayList<String>();
        try {
            files = context.getAssets().list(className);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String folderPath = null;
        File dataDir = context.getExternalFilesDir(null);
        if (dataDir != null && !(folder = new File(folderPath = dataDir.getAbsolutePath() + File.separator + className)).exists()) {
            folder.mkdir();
        }
        for (int i = 0; i < files.length; ++i) {
            String str = files[i];
            if (str.indexOf(".zip") == -1) continue;
            BeautyFileUtil.copyFileIfNeed(context, str, className);
        }
        File file = new File(folderPath);
        File[] subFile = file.listFiles();
        for (int i = 0; i < subFile.length; ++i) {
            if (subFile[i].isDirectory()) continue;
            String filename = subFile[i].getAbsolutePath();
            String path = subFile[i].getPath();
            if (!filename.trim().toLowerCase().endsWith(".zip")) continue;
            modelFiles.add(filename);
        }
        return modelFiles;
    }

    public static List<String> getStickerZipFilesFromSd(Context context, String className) {
        File folder;
        ArrayList<String> modelFiles = new ArrayList<String>();
        String folderPath = null;
        File dataDir = context.getExternalFilesDir(null);
        if (dataDir != null && !(folder = new File(folderPath = dataDir.getAbsolutePath() + File.separator + className)).exists()) {
            folder.mkdir();
        }
        File file = new File(folderPath);
        File[] subFile = file.listFiles();
        for (int i = 0; i < subFile.length; ++i) {
            if (subFile[i].isDirectory()) continue;
            String filename = subFile[i].getAbsolutePath();
            String path = subFile[i].getPath();
            if (!filename.trim().toLowerCase().endsWith(".zip")) continue;
            modelFiles.add(filename);
        }
        return modelFiles;
    }

    public static Map<String, Bitmap> copyStickerIconFiles(Context context, String className) {
        File[] subFile;
        Object folder;
        String[] files = null;
        TreeMap<String, Bitmap> iconFiles = new TreeMap<String, Bitmap>();
        try {
            files = context.getAssets().list(className);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String folderPath = null;
        File dataDir = context.getExternalFilesDir(null);
        if (dataDir != null && !((File)(folder = new File(folderPath = dataDir.getAbsolutePath() + File.separator + className))).exists()) {
            ((File)folder).mkdir();
        }
        for (String str : files) {
            if (str.indexOf(".png") == -1) continue;
            BeautyFileUtil.copyFileIfNeed(context, str, className);
        }
        File file = new File(folderPath);
        for (File value : subFile = file.listFiles()) {
            if (value.isDirectory()) continue;
            String filename = value.getAbsolutePath();
            String path = value.getPath();
            if (!filename.trim().toLowerCase().endsWith(".png") || filename.contains("mode_")) continue;
            String name = value.getName();
            iconFiles.put(FileUtil.getFileNameNoEx(name), BitmapFactory.decodeFile((String)filename));
        }
        return iconFiles;
    }

    public static Map<String, Bitmap> getStickerIconFilesFromSd(Context context, String className) {
        File[] subFile;
        File folder;
        TreeMap<String, Bitmap> iconFiles = new TreeMap<String, Bitmap>();
        String folderPath = null;
        File dataDir = context.getExternalFilesDir(null);
        if (dataDir != null && !(folder = new File(folderPath = dataDir.getAbsolutePath() + File.separator + className)).exists()) {
            folder.mkdir();
        }
        File file = new File(folderPath);
        for (File value : subFile = file.listFiles()) {
            if (value.isDirectory()) continue;
            String filename = value.getAbsolutePath();
            String path = value.getPath();
            if (!filename.trim().toLowerCase().endsWith(".png") || filename.indexOf("mode_") != -1) continue;
            String name = value.getName();
            iconFiles.put(FileUtil.getFileNameNoEx(name), BitmapFactory.decodeFile((String)filename));
        }
        return iconFiles;
    }

    public static List<String> getStickerNames(Context context, String className) {
        File folder;
        ArrayList<String> modelNames = new ArrayList<String>();
        String folderPath = null;
        File dataDir = context.getExternalFilesDir(null);
        if (dataDir != null && !(folder = new File(folderPath = dataDir.getAbsolutePath() + File.separator + className)).exists()) {
            folder.mkdir();
        }
        File file = new File(folderPath);
        File[] subFile = file.listFiles();
        for (int i = 0; i < subFile.length; ++i) {
            String filename;
            if (subFile[i].isDirectory() || !(filename = subFile[i].getAbsolutePath()).trim().toLowerCase().endsWith(".zip") || filename.contains("filter")) continue;
            String name = subFile[i].getName();
            modelNames.add(FileUtil.getFileNameNoEx(name));
        }
        return modelNames;
    }

    public static List<String> copyFilterModelFiles(Context context, String index) {
        File folder;
        String[] files = null;
        ArrayList<String> modelFiles = new ArrayList<String>();
        try {
            files = context.getAssets().list(index);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String folderPath = null;
        File dataDir = context.getExternalFilesDir(null);
        if (dataDir != null && !(folder = new File(folderPath = dataDir.getAbsolutePath() + File.separator + index)).exists()) {
            folder.mkdir();
        }
        for (int i = 0; i < files.length; ++i) {
            String str = files[i];
            if (str.indexOf(".model") == -1) continue;
            BeautyFileUtil.copyFileIfNeed(context, str, index);
        }
        File file = new File(folderPath);
        File[] subFile = file.listFiles();
        for (int i = 0; i < subFile.length; ++i) {
            if (subFile[i].isDirectory()) continue;
            String filename = subFile[i].getAbsolutePath();
            String path = subFile[i].getPath();
            if (!filename.trim().toLowerCase().endsWith(".model") || filename.indexOf("filter") == -1) continue;
            modelFiles.add(filename);
        }
        return modelFiles;
    }

    public static Map<String, Bitmap> copyFilterIconFiles(Context context, String index) {
        File folder;
        String[] files = null;
        TreeMap<String, Bitmap> iconFiles = new TreeMap<String, Bitmap>();
        try {
            files = context.getAssets().list(index);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String folderPath = null;
        File dataDir = context.getExternalFilesDir(null);
        if (dataDir != null && !(folder = new File(folderPath = dataDir.getAbsolutePath() + File.separator + index)).exists()) {
            folder.mkdir();
        }
        for (int i = 0; i < files.length; ++i) {
            String str = files[i];
            if (!str.contains(".png")) continue;
            BeautyFileUtil.copyFileIfNeed(context, str, index);
        }
        File file = new File(folderPath);
        File[] subFile = file.listFiles();
        for (int i = 0; i < subFile.length; ++i) {
            if (subFile[i].isDirectory()) continue;
            String filename = subFile[i].getAbsolutePath();
            String path = subFile[i].getPath();
            if (!filename.trim().toLowerCase().endsWith(".png")) continue;
            String name = subFile[i].getName();
            iconFiles.put(FileUtil.getFileNameNoEx(name), BitmapFactory.decodeFile((String)filename));
        }
        return iconFiles;
    }

    public static List<String> getFilterNames(Context context, String index) {
        File[] subFile;
        File folder;
        ArrayList<String> modelNames = new ArrayList<String>();
        String folderPath = null;
        File dataDir = context.getExternalFilesDir(null);
        if (dataDir != null && !(folder = new File(folderPath = dataDir.getAbsolutePath() + File.separator + index)).exists()) {
            folder.mkdir();
        }
        File file = new File(folderPath);
        for (File value : subFile = file.listFiles()) {
            String filename;
            if (value.isDirectory() || !(filename = value.getAbsolutePath()).trim().toLowerCase().endsWith(".png")) continue;
            String name = value.getName();
            modelNames.add(FileUtil.getFileNameNoEx(name));
        }
        return modelNames;
    }

    public static void closeQuietly(Closeable closeable) {
        if (closeable == null) {
            return;
        }
        try {
            closeable.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void deleteFiles(List<String> filePaths) {
        if (filePaths == null || filePaths.isEmpty()) {
            return;
        }
        for (String next : filePaths) {
            BeautyFileUtil.deleteFile(new File(next));
        }
    }

    public static void deleteFile(File file) {
        if (!file.exists()) {
            return;
        }
        if (file.isFile()) {
            file.delete();
            return;
        }
        String[] fileList = file.list();
        if (fileList == null || fileList.length == 0) {
            file.delete();
            return;
        }
        for (String name : fileList) {
            BeautyFileUtil.deleteFile(new File(file, name));
        }
    }
}

