/*
 * Decompiled with CFR 0.152.
 */
package com.netease.yunxin.lite.util;

import android.text.TextUtils;
import com.netease.lava.webrtc.CalledByNative;
import com.netease.lava.webrtc.CompatVideoCodecInfo;
import com.netease.lava.webrtc.EglBase;
import com.netease.lava.webrtc.HardwareVideoDecoderFactory;
import com.netease.lava.webrtc.HardwareVideoEncoderFactory;
import com.netease.lava.webrtc.Logging;
import com.netease.lava.webrtc.VideoDecoderFactory;
import com.netease.lava.webrtc.VideoEncoderFactory;
import com.netease.yunxin.lite.annotation.Keep;
import com.netease.yunxin.lite.video.VideoHwHelper;
import java.util.Arrays;

@Keep
class CodecHelper {
    private static final String TAG = "CodecHelper";
    private static final String[] HW_DECODE_BYTE_MODE_BLACKLIST = new String[]{"PDVM00", "DUB-LX1"};
    private static final String[] HW_DECODE_TEXTURE_MODE_BLACKLIST = new String[0];

    CodecHelper() {
    }

    @CalledByNative
    private static VideoEncoderFactory createEncoderFactory(EglBase.Context eglBaseContext, String codecName, int yuvColorFormat, int surfaceColorFormat, int Profile, int level, int initDropFrameCount, int keyFrameIntervalSec, int forceKeyFrameIntervalMs, int brAdjustSecond, int forceH264Encoder, int forceH265Encoder) {
        if (TextUtils.isEmpty((CharSequence)codecName)) {
            codecName = null;
        }
        CompatVideoCodecInfo encoderCompatInfo = new CompatVideoCodecInfo();
        encoderCompatInfo.setCodecName(codecName);
        encoderCompatInfo.setEnYUVColorFormat(yuvColorFormat);
        encoderCompatInfo.setEnSurfaceColorFormat(surfaceColorFormat);
        encoderCompatInfo.setProfile(Profile);
        encoderCompatInfo.setLevel(level);
        encoderCompatInfo.setInitDropFrameCount(initDropFrameCount);
        encoderCompatInfo.setKeyFrameIntervalSec(keyFrameIntervalSec);
        encoderCompatInfo.setForceKeyFrameIntervalMs(forceKeyFrameIntervalMs);
        encoderCompatInfo.setBrAdjustSecond(brAdjustSecond);
        encoderCompatInfo.setForceHardwareEncodeingForH264(forceH264Encoder);
        encoderCompatInfo.setForceHardwareEncodeingForH265(forceH265Encoder);
        Logging.i(TAG, "HW encoder compat:{codecName:" + codecName + ", yuvColor:" + yuvColorFormat + ",surfaceColor:" + surfaceColorFormat + ",profile:" + Profile + ",level:" + level + ",dropFrame:" + initDropFrameCount + ",keyFrameInterval:" + keyFrameIntervalSec + ",forceKeyFrameInterval:" + forceKeyFrameIntervalMs + ",brAdjustSecond:" + brAdjustSecond + ",forceH264Encoder:" + forceH264Encoder + ",forceH265Encoder:" + forceH265Encoder + "}");
        return new HardwareVideoEncoderFactory(eglBaseContext, encoderCompatInfo);
    }

    @CalledByNative
    private static VideoDecoderFactory createDecoderFactory(EglBase.Context eglBaseContext, String codecName, int decoderColorFormat, int initDropFrameCount, String videoCodecTypeName, boolean mtkVideoTalk, int textureDelayTime, int forceH264Decoder, int forceH265Decoder) {
        if (TextUtils.isEmpty((CharSequence)codecName)) {
            codecName = null;
        }
        if (TextUtils.isEmpty((CharSequence)videoCodecTypeName)) {
            videoCodecTypeName = null;
        }
        CompatVideoCodecInfo decoderCompatInfo = new CompatVideoCodecInfo();
        decoderCompatInfo.setCodecName(codecName);
        decoderCompatInfo.setDecoderColorFormat(decoderColorFormat);
        decoderCompatInfo.setInitDropFrameCount(initDropFrameCount);
        decoderCompatInfo.setVideoCodecTypeName(videoCodecTypeName);
        decoderCompatInfo.setTextureDelayTimeMs(textureDelayTime);
        decoderCompatInfo.setForceHardwareDecodeingForH264(forceH264Decoder);
        decoderCompatInfo.setForceHardwareDecodeingForH265(forceH265Decoder);
        Logging.i(TAG, "HW decoder compat:{codecName:" + codecName + ", color:" + decoderColorFormat + ", dropFrame:" + initDropFrameCount + ", codecType:" + videoCodecTypeName + ", isMtkVideoTalk:" + mtkVideoTalk + ", textureDelayTime:" + textureDelayTime + ",forceH264Decoder:" + forceH264Decoder + ",forceH265Decoder:" + forceH265Decoder + "}");
        return new HardwareVideoDecoderFactory(eglBaseContext, decoderCompatInfo);
    }

    @CalledByNative
    private static boolean hasH264HwEncoder() {
        return VideoHwHelper.hasH264HwEncoder();
    }

    @CalledByNative
    private static boolean hasH264HwDecoder() {
        return VideoHwHelper.hasH264HwDecoder();
    }

    @CalledByNative
    private static boolean isHwDecodeByteModeBlackList(String model) {
        if (Arrays.asList(HW_DECODE_BYTE_MODE_BLACKLIST).contains(model)) {
            Logging.i(TAG, "The Model: " + model + " in the local HW_DECODE_BYTE_MODE_BLACKLIST!");
            return true;
        }
        return false;
    }

    @CalledByNative
    private static boolean isHwDecodeTextureModeBlackList(String model) {
        if (Arrays.asList(HW_DECODE_TEXTURE_MODE_BLACKLIST).contains(model)) {
            Logging.i(TAG, "The Model: " + model + " in the local HW_DECODE_TEXTURE_MODE_BLACKLIST!");
            return true;
        }
        return false;
    }
}

