/*
 * Decompiled with CFR 0.152.
 */
package com.netease.yunxin.lite.util;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import java.util.Collection;

public class CommonUtils {
    public static boolean isValidHttpUrl(String url) {
        return !TextUtils.isEmpty((CharSequence)url) && (url.startsWith("http") || url.startsWith("https"));
    }

    public static long intToUnsignedLong(int value) {
        return (long)value & 0xFFFFFFFFL;
    }

    public static String getAppKeyFileName(String appKey) {
        if (appKey == null || appKey.trim().length() == 0) {
            return null;
        }
        return appKey.substring(0, appKey.length() / 5) + "_" + Math.abs(appKey.hashCode() / 3);
    }

    public static String getAppName(Context context) {
        String appName = null;
        PackageManager packageManager = context.getPackageManager();
        try {
            PackageInfo packageInfo = packageManager.getPackageInfo(context.getPackageName(), 0);
            appName = packageInfo != null ? context.getResources().getString(packageInfo.applicationInfo.labelRes) : null;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (appName == null) {
            try {
                appName = (String)packageManager.getApplicationLabel(packageManager.getApplicationInfo(context.getPackageName(), 0));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return appName != null ? appName : "un_know_app_name";
    }

    public static String getPkgName(Context context) {
        String packageName = null;
        try {
            PackageManager packageManager = context.getPackageManager();
            PackageInfo packageInfo = packageManager.getPackageInfo(context.getPackageName(), 0);
            packageName = packageInfo != null ? packageInfo.packageName : null;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return packageName != null ? packageName : "un_know_package_name";
    }

    public static Intent safeRegisterReceiver(Context context, BroadcastReceiver receiver, IntentFilter filter) {
        Handler handler = null;
        Looper currentLooper = Looper.myLooper();
        if (currentLooper != null) {
            handler = new Handler(currentLooper);
        }
        return context.registerReceiver(receiver, filter, null, handler);
    }

    public static boolean isStringListNotEmpty(Collection<String> collection) {
        return collection != null && collection.isEmpty();
    }

    public static String getHashCode(Object obj) {
        if (obj == null) {
            return "null";
        }
        return obj.getClass().getSimpleName() + "#" + Integer.toHexString(obj.hashCode());
    }
}

