/*
 * Decompiled with CFR 0.152.
 */
package com.netease.yunxin.lite.util;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.ActivityManager;
import android.app.Application;
import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.netease.lava.webrtc.CalledByNative;
import com.netease.lava.webrtc.Logging;
import com.netease.yunxin.lite.annotation.Keep;
import com.netease.yunxin.lite.video.VideoCompatHelper;
import java.lang.ref.WeakReference;

@Keep
public class ContextUtils {
    private static final String TAG = "ContextUtils";
    @SuppressLint(value={"StaticFieldLeak"})
    private static volatile Context gContext = null;
    private static boolean gDebug = false;
    private static volatile boolean useGlFinish = false;
    private static volatile boolean useAdaptThread = false;
    private static volatile boolean useCaptureFormatConvert = false;
    private static volatile boolean useGPUBaseProcess = false;
    private static volatile boolean isGPUCopyBlackList = false;
    private static volatile boolean useCaptureObserverNewOption = false;
    private static WeakReference<Activity> currentActivity = new WeakReference<Object>(null);
    private static final Application.ActivityLifecycleCallbacks activityLifecycleCallbacks = new Application.ActivityLifecycleCallbacks(){

        public void onActivityCreated(@NonNull Activity activity, @Nullable Bundle savedInstanceState) {
        }

        public void onActivityStarted(@NonNull Activity activity) {
        }

        public void onActivityResumed(@NonNull Activity activity) {
            Logging.i(ContextUtils.TAG, "onActivityResumed: " + activity);
            currentActivity = new WeakReference<Activity>(activity);
        }

        public void onActivityPaused(@NonNull Activity activity) {
        }

        public void onActivityStopped(@NonNull Activity activity) {
        }

        public void onActivitySaveInstanceState(@NonNull Activity activity, @NonNull Bundle outState) {
        }

        public void onActivityDestroyed(@NonNull Activity activity) {
        }
    };

    public static void setDebug(boolean debug) {
        gDebug = debug;
    }

    public static boolean getDebug() {
        return gDebug;
    }

    @CalledByNative
    public static Context getContext() {
        return gContext;
    }

    public static Context getCurrentContext() {
        Activity activity = (Activity)currentActivity.get();
        return activity != null ? activity : gContext;
    }

    @CalledByNative
    public static void setContext(Context context) {
        Logging.i(TAG, "setContext: " + context);
        if (context == null) {
            throw new IllegalArgumentException("context is null");
        }
        gContext = context.getApplicationContext();
        Logging.i(TAG, "application context: " + gContext);
        com.netease.lava.webrtc.ContextUtils.initialize(context.getApplicationContext());
        Application application = (Application)gContext;
        application.unregisterActivityLifecycleCallbacks(activityLifecycleCallbacks);
        application.registerActivityLifecycleCallbacks(activityLifecycleCallbacks);
    }

    @CalledByNative
    public static String getExternalFilesDir(String dir) {
        return gContext.getExternalFilesDir(dir).getAbsolutePath();
    }

    @CalledByNative
    public static String getPackageName() {
        return gContext.getPackageName();
    }

    @CalledByNative
    public static String getCompatLocalFileName(String appKey) {
        if (appKey == null || appKey.trim().length() == 0) {
            return null;
        }
        return appKey.substring(0, appKey.length() / 5) + "_" + Math.abs(appKey.hashCode() / 3);
    }

    @CalledByNative
    public static boolean isUseGlFinish() {
        return useGlFinish;
    }

    @CalledByNative
    public static void setUseGlFinish(boolean useGlFinish) {
        Logging.i(TAG, "setUseGlFinish " + useGlFinish);
        ContextUtils.useGlFinish = useGlFinish;
    }

    @CalledByNative
    public static boolean isUseCaptureFormatConvert() {
        return useCaptureFormatConvert;
    }

    @CalledByNative
    public static boolean isUseGPUBaseProcess() {
        return useGPUBaseProcess;
    }

    @CalledByNative
    public static void setUseCaptureFormatConvert(boolean useCaptureFormatConvert) {
        Logging.d(TAG, " useCaptureFormatConvert " + useCaptureFormatConvert);
        ContextUtils.useCaptureFormatConvert = useCaptureFormatConvert;
    }

    @CalledByNative
    public static void SetUseGPUBaseProcess(boolean useGPUBaseProcess) {
        Logging.d(TAG, "useGPUBaseProcess:" + useGPUBaseProcess);
        ContextUtils.useGPUBaseProcess = useGPUBaseProcess;
    }

    @CalledByNative
    public static int findBestFpsForCapture(String fpsCompat, int width, int height) {
        return VideoCompatHelper.findBestFpsForCapture(fpsCompat, width, height);
    }

    @CalledByNative
    public static int appIsRunForeground() {
        ActivityManager.RunningAppProcessInfo mAppProcessInfo = new ActivityManager.RunningAppProcessInfo();
        try {
            ActivityManager.getMyMemoryState((ActivityManager.RunningAppProcessInfo)mAppProcessInfo);
        }
        catch (Exception e) {
            return -1;
        }
        return mAppProcessInfo.importance == 100 || mAppProcessInfo.importance == 200 ? 1 : 0;
    }

    @CalledByNative
    public static boolean foregroundServiceState() {
        ActivityManager.RunningAppProcessInfo mAppProcessInfo = new ActivityManager.RunningAppProcessInfo();
        try {
            ActivityManager.getMyMemoryState((ActivityManager.RunningAppProcessInfo)mAppProcessInfo);
        }
        catch (Exception e) {
            return false;
        }
        if (Build.VERSION.SDK_INT < 23) {
            return false;
        }
        return mAppProcessInfo.importance == 125;
    }

    public static boolean isUseAdaptThread() {
        return useAdaptThread;
    }

    @CalledByNative
    public static void setUseAdaptThread(boolean useAdaptThread) {
        ContextUtils.useAdaptThread = useAdaptThread;
    }

    public static boolean isGPUCopyBlackList() {
        return isGPUCopyBlackList;
    }

    @CalledByNative
    public static void setGPUCopyBlackList(boolean isGPUCopyBlackList) {
        Logging.d(TAG, " isGPUCopyBlackList " + isGPUCopyBlackList);
        ContextUtils.isGPUCopyBlackList = isGPUCopyBlackList;
    }

    public static boolean isUseCaptureObserverNewOption() {
        return useCaptureObserverNewOption;
    }

    @CalledByNative
    public static void setUseCaptureObserverNewOption(boolean useCaptureObserverNewOption) {
        Logging.d(TAG, "useCaptureObserverNewOption:" + useCaptureObserverNewOption);
        ContextUtils.useCaptureObserverNewOption = useCaptureObserverNewOption;
    }
}

