/*
 * Decompiled with CFR 0.152.
 */
package com.netease.yunxin.lite.util;

import android.os.Handler;
import android.os.HandlerThread;
import android.telephony.PhoneStateListener;
import android.telephony.TelephonyManager;
import com.netease.lava.webrtc.CalledByNative;
import com.netease.lava.webrtc.ForegroundMonitor;
import com.netease.lava.webrtc.Logging;
import com.netease.yunxin.lite.annotation.Keep;
import com.netease.yunxin.lite.util.ContextUtils;
import com.netease.yunxin.lite.util.DeviceStateObserver;
import com.netease.yunxin.lite.util.LooperUtils;
import com.netease.yunxin.lite.util.SystemPermissionUtils;

@Keep
class DeviceStateMonitor {
    private static final String TAG = "DeviceStateMonitor";
    private static TelephonyManager mTelephonyManager;
    private static HandlerThread mThread;
    private static Handler mHandler;

    DeviceStateMonitor() {
    }

    @CalledByNative
    private static void startMonitor(DeviceStateObserver observer) {
        Logging.i(TAG, "startMonitor");
        if (SystemPermissionUtils.checkReadPhoneState(ContextUtils.getContext()) && mTelephonyManager == null) {
            mTelephonyManager = (TelephonyManager)ContextUtils.getContext().getSystemService("phone");
            mTelephonyManager.listen((PhoneStateListener)observer, 32);
        }
        if (mThread == null) {
            mThread = new HandlerThread(TAG);
            mThread.start();
            mHandler = new Handler(mThread.getLooper());
        }
        ForegroundMonitor.getInstance().startMonitor(mHandler);
        ForegroundMonitor.getInstance().addObserver(observer);
    }

    @CalledByNative
    private static void stopMonitor(DeviceStateObserver observer) {
        Logging.i(TAG, "stopMonitor");
        ForegroundMonitor.getInstance().removeObserver(observer);
        ForegroundMonitor.getInstance().stopMonitor();
        if (mThread != null) {
            LooperUtils.quitSafely(mHandler);
            mHandler = null;
            try {
                mThread.join(200L);
                mThread = null;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        if (mTelephonyManager != null && observer != null) {
            mTelephonyManager.listen((PhoneStateListener)observer, 0);
            mTelephonyManager = null;
        }
    }
}

