/*
 * Decompiled with CFR 0.152.
 */
package com.netease.yunxin.lite.util;

import android.telephony.PhoneStateListener;
import com.netease.lava.webrtc.CalledByNative;
import com.netease.lava.webrtc.ForegroundMonitor;
import com.netease.lava.webrtc.Logging;
import com.netease.yunxin.lite.annotation.Keep;
import com.netease.yunxin.lite.util.ThreadUtils;
import java.util.concurrent.locks.ReentrantReadWriteLock;

@Keep
class DeviceStateObserver
extends PhoneStateListener
implements ForegroundMonitor.Observer {
    private static final String TAG = "DeviceStateObserver";
    private final ReentrantReadWriteLock mReadWriteLock = new ReentrantReadWriteLock();
    private long mNativeObserver;

    @CalledByNative
    private static DeviceStateObserver create(long nativeObserver) {
        Logging.i(TAG, "create: " + Long.toHexString(nativeObserver));
        return ThreadUtils.runOnUiThreadBlocking(() -> new DeviceStateObserver(nativeObserver));
    }

    private DeviceStateObserver(long nativeObserver) {
        Logging.i(TAG, "constructor, native observer:0x" + Long.toHexString(nativeObserver));
        this.mNativeObserver = nativeObserver;
    }

    public void onCallStateChanged(int state, String incomingNumber) {
        Logging.i(TAG, "onCallStateChanged: " + state);
        super.onCallStateChanged(state, incomingNumber);
        int liteState = 0;
        switch (state) {
            case 1: {
                Logging.i(TAG, "PhoneState Listener , ringing : " + incomingNumber);
                liteState = 3;
                break;
            }
            case 2: {
                Logging.i(TAG, "PhoneState Listener , off hook : " + incomingNumber);
                liteState = 2;
                break;
            }
            case 0: {
                Logging.i(TAG, "PhoneState Listener , call idle: " + incomingNumber);
                liteState = 0;
                break;
            }
        }
        this.mReadWriteLock.readLock().lock();
        this.onCallStateChanged(this.mNativeObserver, liteState);
        this.mReadWriteLock.readLock().unlock();
    }

    @Override
    public void onForegroundChanged(boolean isForeground) {
        Logging.i(TAG, "onForegroundChanged: " + isForeground);
        this.mReadWriteLock.readLock().lock();
        this.onForegroundChanged(this.mNativeObserver, isForeground);
        this.mReadWriteLock.readLock().unlock();
    }

    @CalledByNative
    private void setNativeObserver(long nativeObserver) {
        Logging.i(TAG, "setNativeObserver:0x" + Long.toHexString(nativeObserver));
        this.mReadWriteLock.writeLock().lock();
        this.mNativeObserver = nativeObserver;
        this.mReadWriteLock.writeLock().unlock();
    }

    private native void onForegroundChanged(long var1, boolean var3);

    private native void onCallStateChanged(long var1, int var3);
}

