/*
 * Decompiled with CFR 0.152.
 */
package com.netease.yunxin.lite.util;

import android.opengl.EGLContext;
import android.opengl.GLES20;
import com.netease.lava.webrtc.CalledByNative;
import com.netease.lava.webrtc.EglBase;
import com.netease.lava.webrtc.EglBase10Impl;
import com.netease.lava.webrtc.EglBase14Impl;
import com.netease.lava.webrtc.Logging;
import com.netease.yunxin.lite.annotation.Keep;

@Keep
class EglHelper {
    private static final String TAG = "EglHelper";

    EglHelper() {
    }

    @CalledByNative
    private static EglBase.Context getEglBaseContext(Object eglContext) {
        if (eglContext instanceof EGLContext) {
            return new EglBase14Impl.Context((EGLContext)eglContext);
        }
        if (eglContext instanceof javax.microedition.khronos.egl.EGLContext) {
            return new EglBase10Impl.Context((javax.microedition.khronos.egl.EGLContext)eglContext);
        }
        if (eglContext instanceof EglBase) {
            return ((EglBase)eglContext).getEglBaseContext();
        }
        return null;
    }

    @CalledByNative
    private static EglBase createEglBase() {
        EglBase eglBase = null;
        try {
            eglBase = EglBase.create(EglBase.ConfigType.kConfigType_PLAIN);
        }
        catch (Exception e) {
            Logging.e(TAG, "Failed to create EglBase: " + e.getMessage());
        }
        return eglBase;
    }

    @CalledByNative
    private static EglBase createEglBaseWithPixelBuffer(EglBase.Context context) {
        EglBase eglBase = null;
        try {
            eglBase = EglBase.create(context, EglBase.ConfigType.kConfigType_PIXEL_BUFFER);
            eglBase.createDummyPbufferSurface();
            eglBase.makeCurrent();
        }
        catch (Exception e) {
            Logging.e(TAG, "Failed to create EglBase with context: " + e.getMessage());
        }
        return eglBase;
    }

    @CalledByNative
    private static long getNativeHandle(EglBase eglBase) {
        if (eglBase == null) {
            Logging.w(TAG, "eglBase is null");
            return 0L;
        }
        if (eglBase.getEglBaseContext() == null) {
            Logging.w(TAG, "eglBase.getEglBaseContext() is null");
            return 0L;
        }
        return eglBase.getEglBaseContext().getNativeEglContext();
    }

    @CalledByNative
    private static void release(EglBase eglBase) {
        if (eglBase != null) {
            eglBase.release();
        }
    }

    @CalledByNative
    private static void glFinish() {
        GLES20.glFinish();
    }
}

