/*
 * Decompiled with CFR 0.152.
 */
package com.netease.yunxin.lite.util;

import android.content.Context;
import android.net.Uri;
import android.os.Environment;
import android.os.ParcelFileDescriptor;
import android.text.TextUtils;
import android.util.Log;
import com.netease.yunxin.lite.util.CommonUtils;
import com.netease.yunxin.lite.util.Compatibility;
import com.netease.yunxin.lite.util.SystemPermissionUtils;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import java.util.Locale;

public class FileUtil {
    private static final String TAG = "FileUtil";

    public static boolean hasExtension(String filename) {
        int dot = filename.lastIndexOf(46);
        return dot > -1 && dot < filename.length() - 1;
    }

    public static String getExtensionName(String filename) {
        int dot;
        if (filename != null && filename.length() > 0 && (dot = filename.lastIndexOf(46)) > -1 && dot < filename.length() - 1) {
            return filename.substring(dot + 1);
        }
        return "";
    }

    public static String getFileNameFromPath(String filepath) {
        int sep;
        if (filepath != null && filepath.length() > 0 && (sep = filepath.lastIndexOf(47)) > -1 && sep < filepath.length() - 1) {
            return filepath.substring(sep + 1);
        }
        return filepath;
    }

    public static String getFileNameNoEx(String filename) {
        int dot;
        if (filename != null && filename.length() > 0 && (dot = filename.lastIndexOf(46)) > -1 && dot < filename.length()) {
            return filename.substring(0, dot);
        }
        return filename;
    }

    public static String formatFileSize(long size) {
        return FileUtil.formatFileSize(size, SizeUnit.Auto);
    }

    public static String formatFileSize(long size, SizeUnit unit) {
        double KB = 1024.0;
        double MB = 1048576.0;
        double GB = 1.073741824E9;
        double TB = 1.099511627776E12;
        if (unit == SizeUnit.Auto) {
            unit = (double)size < 1024.0 ? SizeUnit.Byte : ((double)size < 1048576.0 ? SizeUnit.KB : ((double)size < 1.073741824E9 ? SizeUnit.MB : ((double)size < 1.099511627776E12 ? SizeUnit.GB : SizeUnit.TB)));
        }
        switch (unit) {
            case KB: {
                return String.format(Locale.US, "%.2fKB", (double)size / 1024.0);
            }
            case MB: {
                return String.format(Locale.US, "%.2fMB", (double)size / 1048576.0);
            }
            case GB: {
                return String.format(Locale.US, "%.2fGB", (double)size / 1.073741824E9);
            }
            case TB: {
                return String.format(Locale.US, "%.2fPB", (double)size / 1.099511627776E12);
            }
        }
        return size + "B";
    }

    public static boolean createFilePath(File file, String filePath) {
        int index = filePath.indexOf("/");
        if (index == -1) {
            return false;
        }
        if (index == 0) {
            filePath = filePath.substring(index + 1);
            index = filePath.indexOf("/");
        }
        String path = filePath.substring(0, index);
        File fPath = file == null ? new File(path) : new File(file.getPath() + "/" + path);
        if (!fPath.exists() && !fPath.mkdir()) {
            return false;
        }
        if (index < filePath.length() - 1) {
            String exPath = filePath.substring(index + 1);
            FileUtil.createFilePath(fPath, exPath);
        }
        return true;
    }

    public static String getContentFileFDForNative(Context context, String urlString) {
        if (TextUtils.isEmpty((CharSequence)urlString) || context == null) {
            return urlString;
        }
        Uri uri = Uri.parse((String)urlString);
        if (TextUtils.equals((CharSequence)uri.getScheme(), (CharSequence)"file")) {
            return new File(uri.getPath()).getAbsolutePath();
        }
        if (!TextUtils.equals((CharSequence)uri.getScheme(), (CharSequence)"content")) {
            return urlString;
        }
        try {
            ParcelFileDescriptor fileDescriptor = context.getContentResolver().openFileDescriptor(uri, "r");
            return "/android_content_fd/" + fileDescriptor.detachFd();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return urlString;
        }
    }

    public static String ensureDirectoryByAppKey(String type, Context context, String appKey, boolean publicForAndroid12) {
        String mixAppKey;
        File dirFile;
        if (context == null || TextUtils.isEmpty((CharSequence)type)) {
            return null;
        }
        File typeDir = null;
        if (publicForAndroid12 && Compatibility.runningOnSnowConeOrHigher() && SystemPermissionUtils.checkWriteExternalStoragePermission(context) && Environment.getExternalStorageState().equals("mounted")) {
            String packageName = CommonUtils.getPkgName(context);
            File sdCardDir = new File(Environment.getExternalStorageDirectory(), packageName);
            typeDir = new File(new File(sdCardDir, "nertc"), type);
        }
        if (typeDir == null) {
            typeDir = context.getExternalFilesDir(type);
        }
        if (typeDir == null) {
            typeDir = context.getDir(type, 0);
            Log.e((String)TAG, (String)("Create typeDir at external dir failed , current path is : " + typeDir.getAbsolutePath()));
        }
        File file = dirFile = (mixAppKey = CommonUtils.getAppKeyFileName(appKey)) != null ? new File(typeDir, mixAppKey) : typeDir;
        if (!dirFile.exists()) {
            dirFile.mkdirs();
        }
        return dirFile.getAbsolutePath();
    }

    public static void closeQuietly(Closeable closeable) {
        if (closeable == null) {
            return;
        }
        try {
            closeable.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void deleteFiles(List<String> filePaths) {
        if (filePaths == null || filePaths.isEmpty()) {
            return;
        }
        for (String next : filePaths) {
            FileUtil.deleteFile(new File(next));
        }
    }

    public static void deleteFile(File file) {
        if (!file.exists()) {
            return;
        }
        if (file.isFile()) {
            file.delete();
            return;
        }
        String[] fileList = file.list();
        if (fileList == null || fileList.length == 0) {
            file.delete();
            return;
        }
        for (String name : fileList) {
            FileUtil.deleteFile(new File(file, name));
        }
    }

    public static enum SizeUnit {
        Byte,
        KB,
        MB,
        GB,
        TB,
        Auto;

    }
}

