/*
 * Decompiled with CFR 0.152.
 */
package com.netease.yunxin.lite.util;

import android.os.Handler;
import android.os.Looper;
import com.netease.lava.webrtc.CalledByNative;
import com.netease.yunxin.lite.annotation.Keep;
import java.util.concurrent.Semaphore;

@Keep
class MainThreadUtils {
    private static final Handler sHandler = new Handler(Looper.getMainLooper());

    MainThreadUtils() {
    }

    @CalledByNative
    private static boolean isMainThread() {
        return Looper.getMainLooper().getThread() == Thread.currentThread();
    }

    @CalledByNative
    private static void run(long context, boolean block) {
        if (Looper.getMainLooper().getThread() == Thread.currentThread()) {
            MainThreadUtils.nativeRun(context);
        } else {
            Task task = new Task(context);
            sHandler.post((Runnable)task);
            if (block) {
                task.waitDone();
            }
        }
    }

    private static native void nativeRun(long var0);

    private static class Task
    implements Runnable {
        private final Semaphore mSemaphore = new Semaphore(0);
        private long mNativeContext = 0L;

        private Task(long nativeContext) {
            this.mNativeContext = nativeContext;
        }

        @Override
        public void run() {
            MainThreadUtils.nativeRun(this.mNativeContext);
            this.mSemaphore.release();
        }

        private void waitDone() {
            this.mSemaphore.acquireUninterruptibly();
        }
    }
}

