/*
 * Decompiled with CFR 0.152.
 */
package com.netease.yunxin.lite.util;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.renderscript.Allocation;
import android.renderscript.Element;
import android.renderscript.RenderScript;
import android.renderscript.ScriptIntrinsicYuvToRGB;
import android.renderscript.Type;
import com.netease.lava.webrtc.CalledByNative;
import com.netease.lava.webrtc.Logging;
import com.netease.yunxin.lite.util.ContextUtils;
import com.netease.yunxin.lite.util.ThreadUtils;

public class NV21ToBitmap {
    private static RenderScript rs;
    private static ScriptIntrinsicYuvToRGB yuvToRgbIntrinsic;

    private static void init() {
        if (rs == null) {
            rs = RenderScript.create((Context)ContextUtils.getContext());
            yuvToRgbIntrinsic = ScriptIntrinsicYuvToRGB.create((RenderScript)rs, (Element)Element.U8_4((RenderScript)rs));
        }
    }

    @CalledByNative
    public static Bitmap nv21ToBitmap(byte[] nv21, int width, int height, int rotation) {
        try {
            if (rs == null) {
                ThreadUtils.runOnUiThreadBlocking(NV21ToBitmap::init);
            }
            Type.Builder yuvType = new Type.Builder(rs, Element.U8((RenderScript)rs)).setX(nv21.length);
            Allocation in = Allocation.createTyped((RenderScript)rs, (Type)yuvType.create(), (int)1);
            Type.Builder rgbaType = new Type.Builder(rs, Element.RGBA_8888((RenderScript)rs)).setX(width).setY(height);
            Allocation out = Allocation.createTyped((RenderScript)rs, (Type)rgbaType.create(), (int)1);
            in.copyFrom(nv21);
            yuvToRgbIntrinsic.setInput(in);
            yuvToRgbIntrinsic.forEach(out);
            Bitmap bmpout = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            out.copyTo(bmpout);
            if (rotation != 0) {
                Matrix matrix = new Matrix();
                matrix.setRotate((float)rotation);
                bmpout = Bitmap.createBitmap((Bitmap)bmpout, (int)0, (int)0, (int)width, (int)height, (Matrix)matrix, (boolean)false);
            }
            return bmpout;
        }
        catch (Exception e) {
            Logging.e("NV21ToBitmap", "nv21ToBitmap failed: " + e.getMessage());
            return null;
        }
    }

    public static void release() {
        try {
            if (rs != null) {
                rs.finish();
                rs.destroy();
                rs = null;
            }
        }
        catch (Exception e) {
            Logging.e("NV21ToBitmap", "release error: " + e.getMessage());
        }
    }
}

