/*
 * Decompiled with CFR 0.152.
 */
package com.netease.yunxin.lite.util;

import android.annotation.SuppressLint;
import android.os.Build;
import com.netease.lava.webrtc.Logging;
import com.netease.yunxin.lite.util.Compatibility;

public class NativeLibLoader {
    @SuppressLint(value={"NewApi"})
    public static void loadLibrary(String library) throws UnsatisfiedLinkError {
        block10: {
            try {
                System.loadLibrary(library);
                Logging.i("NativeLibLoader", "loadLibrary " + library + " done.");
            }
            catch (UnsatisfiedLinkError error1) {
                UnsatisfiedLinkError er2 = new UnsatisfiedLinkError();
                boolean loaded = false;
                String[] ABIs = null;
                if (Compatibility.runningOnLollipopOrHigher()) {
                    ABIs = Build.SUPPORTED_ABIS;
                }
                if (ABIs == null) {
                    ABIs = new String[]{Build.CPU_ABI};
                }
                for (String ABI : ABIs) {
                    try {
                        System.loadLibrary(library + "_" + ABI);
                        loaded = true;
                    }
                    catch (UnsatisfiedLinkError error2) {
                        er2 = error2;
                    }
                    if (loaded) break;
                }
                if (loaded) break block10;
                try {
                    System.loadLibrary(library + "_armeabi-v7a");
                }
                catch (UnsatisfiedLinkError error3) {
                    StringBuilder abis = new StringBuilder("Supported ABI[ ");
                    for (String ABI : ABIs) {
                        abis.append(ABI);
                        abis.append(" ");
                    }
                    abis.append("]");
                    String traceInfo = error1.getMessage() + "\n" + er2.getMessage() + "\n" + error3.getMessage() + "\n";
                    Logging.w("NativeLibLoader", "Can not load " + library + " ," + abis + "Please use {lib" + library + ".so or lib" + library + "_" + Build.CPU_ABI + ".so} \nLinkError: \n" + traceInfo);
                }
            }
        }
    }
}

