/*
 * Decompiled with CFR 0.152.
 */
package com.netease.yunxin.lite.util;

import android.util.Log;
import com.netease.lava.webrtc.CalledByNative;
import com.netease.lava.webrtc.Logging;
import com.netease.lava.webrtc.NetworkMonitor;
import com.netease.lava.webrtc.NetworkMonitorAutoDetect;
import com.netease.yunxin.lite.annotation.Keep;
import com.netease.yunxin.lite.util.ContextUtils;

@Keep
class NetworkMonitorWrapper {
    private static final String TAG = "NetworkMonitorWrapper";

    NetworkMonitorWrapper() {
    }

    static int convertConnectionType(NetworkMonitorAutoDetect.ConnectionType connectionType) {
        switch (connectionType) {
            case CONNECTION_ETHERNET: {
                return 1;
            }
            case CONNECTION_WIFI: {
                return 2;
            }
            case CONNECTION_2G: {
                return 3;
            }
            case CONNECTION_3G: {
                return 4;
            }
            case CONNECTION_4G: {
                return 5;
            }
            case CONNECTION_5G: {
                return 6;
            }
            case CONNECTION_NONE: {
                return 9;
            }
            case CONNECTION_BLUETOOTH: {
                return 8;
            }
        }
        return 0;
    }

    @CalledByNative
    private static int getCurrentConnectionType() {
        return NetworkMonitorWrapper.convertConnectionType(NetworkMonitor.getInstance().getCurrentConnectionType());
    }

    @CalledByNative
    private static void startMonitor(NetworkMonitor.NetworkObserver observer) {
        try {
            Logging.i(TAG, "startMonitor");
            NetworkMonitor.getInstance().addObserver(observer);
            NetworkMonitor.getInstance().startMonitoring(ContextUtils.getContext(), true);
        }
        catch (Exception e) {
            Logging.w(TAG, "initLava exception:" + Log.getStackTraceString((Throwable)e));
        }
    }

    @CalledByNative
    private static void stopMonitor(NetworkMonitor.NetworkObserver observer) {
        try {
            Logging.i(TAG, "stopMonitor");
            NetworkMonitor.getInstance().removeObserver(observer);
            NetworkMonitor.getInstance().stopMonitoring();
        }
        catch (Exception e) {
            Logging.w(TAG, "releaseInternal exception:" + Log.getStackTraceString((Throwable)e));
        }
    }
}

