/*
 * Decompiled with CFR 0.152.
 */
package com.netease.yunxin.lite.util;

import android.net.NetworkCapabilities;
import com.netease.lava.webrtc.CalledByNative;
import com.netease.lava.webrtc.Logging;
import com.netease.lava.webrtc.NetworkMonitor;
import com.netease.lava.webrtc.NetworkMonitorAutoDetect;
import com.netease.yunxin.lite.annotation.Keep;
import com.netease.yunxin.lite.util.Compatibility;
import com.netease.yunxin.lite.util.NetworkMonitorWrapper;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;

@Keep
class NetworkObserver
implements NetworkMonitor.NetworkObserver {
    private static final String TAG = "NetworkObserver";
    private final ReentrantReadWriteLock mReadWriteLock = new ReentrantReadWriteLock();
    private long mNativeObserver;

    @CalledByNative
    private NetworkObserver(long nativeObserver) {
        Logging.i(TAG, "constructor, native observer:0x" + Long.toHexString(nativeObserver));
        this.mNativeObserver = nativeObserver;
    }

    private static native void onConnectionTypeChanged(long var0, int var2);

    private static native void onNetworkCapabilitiesChanged(long var0, int var2, int var3, int var4);

    private static native void onNetworkCollect(long var0, Map<String, Long> var2, int var3);

    @CalledByNative
    private void setNativeObserver(long nativeObserver) {
        Logging.i(TAG, "setNativeObserver:0x" + Long.toHexString(nativeObserver));
        this.mReadWriteLock.writeLock().lock();
        this.mNativeObserver = nativeObserver;
        this.mReadWriteLock.writeLock().unlock();
    }

    @Override
    public void onConnectionTypeChanged(NetworkMonitorAutoDetect.ConnectionType connectionType) {
        Logging.i(TAG, "onConnectionTypeChanged:" + (Object)((Object)connectionType));
        this.mReadWriteLock.readLock().lock();
        NetworkObserver.onConnectionTypeChanged(this.mNativeObserver, NetworkMonitorWrapper.convertConnectionType(connectionType));
        this.mReadWriteLock.readLock().unlock();
    }

    @Override
    public void onNetworkCapabilitiesChanged(NetworkCapabilities networkCapabilities) {
        Logging.i(TAG, "onNetworkCapabilitiesChanged:" + networkCapabilities);
        if (!Compatibility.runningOnLollipopOrHigher()) {
            return;
        }
        int signalStrength = Integer.MIN_VALUE;
        int downBandwidthKbps = networkCapabilities.getLinkDownstreamBandwidthKbps();
        int upBandwidthKbps = networkCapabilities.getLinkUpstreamBandwidthKbps();
        if (Compatibility.runningOnQOrHigher()) {
            signalStrength = networkCapabilities.getSignalStrength();
        }
        this.mReadWriteLock.readLock().lock();
        NetworkObserver.onNetworkCapabilitiesChanged(this.mNativeObserver, signalStrength, downBandwidthKbps, upBandwidthKbps);
        this.mReadWriteLock.readLock().unlock();
    }

    @Override
    public void onNetworkCollect(NetworkMonitorAutoDetect.NetworkInformation[] networkInfos, int androidSdk) {
        HashMap<String, Long> ip_netid = new HashMap<String, Long>();
        for (int i = 0; i < networkInfos.length; ++i) {
            for (int j = 0; j < networkInfos[i].ipAddresses.length; ++j) {
                ip_netid.put(networkInfos[i].ipAddresses[j].hostAddress.getHostAddress(), networkInfos[i].handle);
            }
        }
        this.mReadWriteLock.readLock().lock();
        if (this.mNativeObserver != 0L) {
            NetworkObserver.onNetworkCollect(this.mNativeObserver, ip_netid, androidSdk);
        }
        this.mReadWriteLock.readLock().unlock();
    }
}

