/*
 * Decompiled with CFR 0.152.
 */
package com.netease.yunxin.lite.util;

import android.content.Context;
import android.util.Log;
import com.netease.lava.webrtc.CalledByNative;
import com.netease.lava.webrtc.Logging;
import com.netease.yunxin.lite.annotation.Keep;
import com.netease.yunxin.lite.util.CommonUtils;
import com.netease.yunxin.lite.util.FileUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.ObjectInputStream;
import java.util.Map;
import org.json.JSONObject;

@Keep
public class OldVersionCompatUtil {
    private static final String CONFIG_PATH = "nertc_config";
    private static final String CONFIG_FILE_NAME = "official_config";
    public static final String TAG_DEFAULT = "default";
    public static final String TAG_LBS_INFO = "lbs.channel.info";
    private static final String TAG = "OldVersionCompatUtil";
    private static Context sContext;

    public static void init(Context context) {
        if (context == null) {
            return;
        }
        sContext = context.getApplicationContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CalledByNative
    public static String getLBSInfo(String appKey) {
        ObjectInputStream ois;
        block6: {
            String string;
            File cacheDir = OldVersionCompatUtil.getConfigCacheDir(sContext, appKey);
            if (cacheDir == null) {
                return "";
            }
            File configFiles = new File(cacheDir, CONFIG_FILE_NAME);
            if (!configFiles.exists() || !configFiles.canRead()) {
                Logging.w(TAG, "getLBSInfo failed file:" + configFiles.getAbsolutePath());
                return "";
            }
            ois = null;
            try {
                String lbsInfoStr;
                ois = new ObjectInputStream(new FileInputStream(configFiles));
                int lastVersionCode = ois.readInt();
                String eTag = ois.readUTF();
                Map configs = (Map)ois.readObject();
                Map defaultConfigs = (Map)configs.get(TAG_DEFAULT);
                Object lbsInfo = defaultConfigs.get(TAG_LBS_INFO);
                String string2 = lbsInfoStr = lbsInfo == null ? null : (String)lbsInfo;
                if (lbsInfoStr == null) break block6;
                JSONObject jsonObject = new JSONObject(lbsInfoStr);
                jsonObject.put("app_key", (Object)appKey);
                string = jsonObject.toString();
            }
            catch (Exception e) {
                try {
                    Logging.i(TAG, "getLBSInfo failed :" + Log.getStackTraceString((Throwable)e));
                }
                catch (Throwable throwable) {
                    FileUtil.closeQuietly(ois);
                    throw throwable;
                }
                FileUtil.closeQuietly(ois);
            }
            FileUtil.closeQuietly(ois);
            return string;
        }
        FileUtil.closeQuietly(ois);
        return "";
    }

    private static File getConfigCacheDir(Context context, String appKey) {
        if (context == null || appKey == null) {
            return null;
        }
        File cacheParentDir = context.getExternalFilesDir(CONFIG_PATH);
        if (cacheParentDir == null) {
            cacheParentDir = context.getCacheDir();
        }
        return (appKey = CommonUtils.getAppKeyFileName(appKey)) != null ? new File(cacheParentDir, appKey) : cacheParentDir;
    }
}

