/*
 * Decompiled with CFR 0.152.
 */
package com.netease.yunxin.lite.util;

import android.app.ActivityManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.BatteryManager;
import android.os.Build;
import android.os.Debug;
import android.os.Handler;
import android.os.Looper;
import android.os.Process;
import android.os.SystemClock;
import com.netease.lava.webrtc.CalledByNative;
import com.netease.lava.webrtc.ContextUtils;
import com.netease.lava.webrtc.Logging;
import com.netease.yunxin.lite.annotation.Keep;
import com.netease.yunxin.lite.util.Compatibility;
import com.netease.yunxin.lite.util.FileUtil;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;

public class SystemInfoHelper {
    private static final String TAG = "SystemInfoHelper";
    private static long[] mPreTotalAndIdle;
    private static float mPreProcessCpuTime;
    private static long sMaxAppMemory;
    private static long sTotalMemory;
    private static BroadcastReceiver batteryReceiver;
    private static int batteryVoltage;
    private static int batteryTemperature;
    private static boolean isCharging;
    private static BatteryManager batteryManager;
    private static ActivityManager sActivityManager;
    private static int sMyPid;
    private static int[] sMemPid;
    private static String sProcPidStatPath;

    @Keep
    @CalledByNative
    public static void initial() {
        try {
            Logging.i(TAG, "RTCSystemInfoHelper initial.");
            sActivityManager = (ActivityManager)ContextUtils.getApplicationContext().getSystemService("activity");
            sMyPid = Process.myPid();
            sMemPid = new int[]{sMyPid};
            sProcPidStatPath = "/proc/" + sMyPid + "/stat";
            if (Compatibility.runningOnLollipopOrHigher()) {
                batteryManager = (BatteryManager)ContextUtils.getApplicationContext().getSystemService("batterymanager");
                batteryReceiver = new BroadcastReceiver(){

                    public void onReceive(Context context, Intent intent) {
                        try {
                            batteryVoltage = intent.getIntExtra("voltage", 0);
                            batteryTemperature = intent.getIntExtra("temperature", 0);
                            int status = intent.getIntExtra("status", -1);
                            isCharging = status == 2 || status == 5;
                        }
                        catch (Exception e) {
                            Logging.i(SystemInfoHelper.TAG, "Get battery info failed : " + e.getMessage());
                        }
                    }
                };
            }
            IntentFilter filter = new IntentFilter();
            filter.addAction("android.intent.action.BATTERY_CHANGED");
            SystemInfoHelper.safeRegisterReceiver(ContextUtils.getApplicationContext(), batteryReceiver, filter);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Keep
    @CalledByNative
    public static void release() {
        Logging.i(TAG, "RTCSystemInfoHelper release.");
        try {
            if (ContextUtils.getApplicationContext() != null && batteryReceiver != null) {
                ContextUtils.getApplicationContext().unregisterReceiver(batteryReceiver);
            }
            batteryReceiver = null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static Intent safeRegisterReceiver(Context context, BroadcastReceiver receiver, IntentFilter filter) {
        Handler handler = null;
        Looper currentLooper = Looper.myLooper();
        if (currentLooper != null) {
            handler = new Handler(currentLooper);
        }
        return context.registerReceiver(receiver, filter, null, handler);
    }

    @Keep
    @CalledByNative
    public static int[] getBatteryInfo() {
        try {
            if (Build.VERSION.SDK_INT < 21 || batteryManager == null) {
                return new int[]{0, 0, 0, 0, 0};
            }
            int capacity = batteryManager.getIntProperty(4);
            int batteryCurrent = batteryManager.getIntProperty(2);
            return new int[]{capacity, batteryCurrent, batteryVoltage, batteryTemperature, isCharging ? 1 : 0};
        }
        catch (Exception exception) {
            return new int[]{0, 0, 0, 0, 0};
        }
    }

    @Keep
    @CalledByNative
    public static boolean isSupported() {
        return Build.VERSION.SDK_INT < 26 && ContextUtils.getApplicationContext() != null;
    }

    @Keep
    @CalledByNative
    public static int[] getCpuRateNoSleep() {
        try {
            if (mPreTotalAndIdle == null) {
                float[] cpuRate = SystemInfoHelper.getCpuRate();
                mPreTotalAndIdle = SystemInfoHelper.getTotalCpuTime();
                mPreProcessCpuTime = SystemInfoHelper.getAppCpuTime();
                if (cpuRate != null) {
                    return new int[]{(int)cpuRate[0], (int)cpuRate[1]};
                }
                return new int[]{0, 0};
            }
            float totalCpuTime1 = mPreTotalAndIdle[0];
            float idleCpu1 = mPreTotalAndIdle[1];
            float processCpuTime1 = mPreProcessCpuTime;
            long[] totalAndIdle2 = SystemInfoHelper.getTotalCpuTime();
            if (totalAndIdle2 == null) {
                return new int[]{0, 0};
            }
            float totalCpuTime2 = totalAndIdle2[0];
            float idleCpu2 = totalAndIdle2[1];
            float processCpuTime2 = SystemInfoHelper.getAppCpuTime();
            float cpuAppRate = 100.0f * (processCpuTime2 - processCpuTime1) / (totalCpuTime2 - totalCpuTime1);
            float cpuTotalRate = 100.0f * (totalCpuTime2 - totalCpuTime1 - (idleCpu2 - idleCpu1)) / (totalCpuTime2 - totalCpuTime1);
            mPreTotalAndIdle = totalAndIdle2;
            mPreProcessCpuTime = processCpuTime2;
            return new int[]{(int)cpuAppRate, (int)cpuTotalRate};
        }
        catch (Throwable throwable) {
            return new int[]{0, 0};
        }
    }

    @Keep
    @CalledByNative
    public static int[] getAppMemorySize() {
        try {
            Debug.MemoryInfo memoryInfo = sActivityManager.getProcessMemoryInfo(sMemPid)[0];
            return new int[]{memoryInfo.getTotalPss(), memoryInfo.dalvikPss, memoryInfo.nativePss, memoryInfo.otherPss};
        }
        catch (Exception e) {
            return new int[]{0, 0, 0, 0};
        }
    }

    @Keep
    @CalledByNative
    public static long getFreeMemorySize() {
        try {
            ActivityManager.MemoryInfo outInfo = new ActivityManager.MemoryInfo();
            sActivityManager.getMemoryInfo(outInfo);
            long availMem = outInfo.availMem;
            return availMem / 1024L;
        }
        catch (Exception e) {
            return 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Keep
    @CalledByNative
    public static long getTotalMemory() {
        if (sTotalMemory > 0L) {
            return sTotalMemory;
        }
        String readTemp = "";
        String memTotal = "";
        FileReader fr = null;
        BufferedReader localBufferedReader = null;
        try {
            fr = new FileReader("/proc/meminfo");
            localBufferedReader = new BufferedReader(fr, 8192);
            while ((readTemp = localBufferedReader.readLine()) != null) {
                if (!readTemp.contains("MemTotal")) continue;
                String[] total = readTemp.split(":");
                memTotal = total[1].trim();
            }
            String[] memKb = memTotal.split(" ");
            memTotal = memKb[0].trim();
            sTotalMemory = Long.parseLong(memTotal);
        }
        catch (Exception exception) {
            FileUtil.closeQuietly(localBufferedReader);
            FileUtil.closeQuietly(fr);
            catch (Throwable throwable) {
                FileUtil.closeQuietly(localBufferedReader);
                FileUtil.closeQuietly(fr);
                throw throwable;
            }
        }
        FileUtil.closeQuietly(localBufferedReader);
        FileUtil.closeQuietly(fr);
        return sTotalMemory;
    }

    @Keep
    @CalledByNative
    public static long getAppMaxMemory() {
        try {
            if (sMaxAppMemory <= 0L) {
                sMaxAppMemory = Runtime.getRuntime().maxMemory() / 1024L;
            }
            return sMaxAppMemory;
        }
        catch (Exception e) {
            return 0L;
        }
    }

    private static float[] getCpuRate() {
        long[] totalAndIdle1 = SystemInfoHelper.getTotalCpuTime();
        if (totalAndIdle1 == null) {
            return null;
        }
        float totalCpuTime1 = totalAndIdle1[0];
        float idleCpu1 = totalAndIdle1[1];
        float processCpuTime1 = SystemInfoHelper.getAppCpuTime();
        SystemClock.sleep((long)360L);
        long[] totalAndIdle2 = SystemInfoHelper.getTotalCpuTime();
        if (totalAndIdle2 == null) {
            return null;
        }
        float totalCpuTime2 = totalAndIdle2[0];
        float idleCpu2 = totalAndIdle2[1];
        float processCpuTime2 = SystemInfoHelper.getAppCpuTime();
        float cpuAppRate = 100.0f * (processCpuTime2 - processCpuTime1) / (totalCpuTime2 - totalCpuTime1);
        float cpuTotalRate = 100.0f * (totalCpuTime2 - totalCpuTime1 - (idleCpu2 - idleCpu1)) / (totalCpuTime2 - totalCpuTime1);
        return new float[]{cpuAppRate, cpuTotalRate};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long[] getTotalCpuTime() {
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader(new FileInputStream("/proc/stat")), 1000);
            String load = reader.readLine();
            String[] cpuInfo = load.split(" ");
            long idleCpu = Long.parseLong(cpuInfo[5]);
            long totalCpu = Long.parseLong(cpuInfo[2]) + Long.parseLong(cpuInfo[3]) + Long.parseLong(cpuInfo[4]) + Long.parseLong(cpuInfo[6]) + Long.parseLong(cpuInfo[5]) + Long.parseLong(cpuInfo[7]) + Long.parseLong(cpuInfo[8]);
            long[] lArray = new long[]{totalCpu, idleCpu};
            FileUtil.closeQuietly(reader);
            return lArray;
        }
        catch (IOException ex) {
            long[] lArray = null;
            return lArray;
        }
        finally {
            FileUtil.closeQuietly(reader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long getAppCpuTime() {
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader(new FileInputStream(sProcPidStatPath)), 1000);
            String load = reader.readLine();
            String[] cpuInfo = load.split(" ");
            long l = Long.parseLong(cpuInfo[13]) + Long.parseLong(cpuInfo[14]) + Long.parseLong(cpuInfo[15]) + Long.parseLong(cpuInfo[16]);
            FileUtil.closeQuietly(reader);
            return l;
        }
        catch (IOException ex) {
            long l = 1L;
            return l;
        }
        finally {
            FileUtil.closeQuietly(reader);
        }
    }

    static {
        sMaxAppMemory = 0L;
        sTotalMemory = 0L;
    }
}

