/*
 * Decompiled with CFR 0.152.
 */
package com.netease.yunxin.lite.util;

import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import com.netease.lava.webrtc.CalledByNative;
import com.netease.lava.webrtc.device.AndroidDeviceInfo;
import com.netease.lava.webrtc.device.HardwareLevel;
import com.netease.yunxin.lite.annotation.Keep;
import com.netease.yunxin.lite.util.ContextUtils;
import com.netease.yunxin.lite.util.SharedPreferencesUtil;
import com.netease.yunxin.lite.util.StringUtils;
import com.netease.yunxin.lite.util.emulator.EmulatorCheckUtil;
import com.netease.yunxin.lite.util.emulator.HarmonyUtils;
import com.netease.yunxin.lite.video.VideoHwHelper;
import java.util.UUID;

@Keep
public class SystemInformation {
    private static String sDeviceId;
    private static String sOsExtraInfo;

    @CalledByNative
    public static String getProduct() {
        return Build.PRODUCT;
    }

    @CalledByNative
    public static String getDevice() {
        return Build.DEVICE;
    }

    @CalledByNative
    public static String getBoard() {
        return Build.BOARD;
    }

    @CalledByNative
    public static String getManufacturer() {
        return Build.MANUFACTURER;
    }

    @CalledByNative
    public static String getBrand() {
        return Build.BRAND;
    }

    @CalledByNative
    public static String getModel() {
        return Build.MODEL;
    }

    @CalledByNative
    public static String getHardware() {
        return Build.HARDWARE;
    }

    @CalledByNative
    public static String getAbi() {
        return AndroidDeviceInfo.getCPUABI();
    }

    @CalledByNative
    public static int getSDKVersion() {
        return Build.VERSION.SDK_INT;
    }

    @CalledByNative
    public static String getVersion() {
        return Build.VERSION.RELEASE;
    }

    @CalledByNative
    public static String getDeviceId() {
        if (StringUtils.isNotEmpty(sDeviceId)) {
            return sDeviceId;
        }
        String deviceId = SharedPreferencesUtil.getInstance().getString(ContextUtils.getContext(), "device_id", "");
        if (StringUtils.isEmpty(deviceId)) {
            deviceId = UUID.randomUUID().toString();
            SharedPreferencesUtil.getInstance().saveString(ContextUtils.getContext(), "device_id", deviceId);
        }
        sDeviceId = deviceId;
        return deviceId;
    }

    @CalledByNative
    public static String getCpuName() {
        return AndroidDeviceInfo.getDeviceCpuName();
    }

    @CalledByNative
    public static int getNumberOfCPUCores() {
        return AndroidDeviceInfo.getNumberOfCPUCores();
    }

    @CalledByNative
    public static String getPackageName() {
        return ContextUtils.getContext().getPackageName();
    }

    @CalledByNative
    public static String getAppName() {
        String appName = null;
        PackageManager packageManager = ContextUtils.getContext().getPackageManager();
        try {
            PackageInfo packageInfo = packageManager.getPackageInfo(ContextUtils.getContext().getPackageName(), 0);
            appName = packageInfo != null ? ContextUtils.getContext().getResources().getString(packageInfo.applicationInfo.labelRes) : null;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (appName == null) {
            try {
                appName = (String)packageManager.getApplicationLabel(packageManager.getApplicationInfo(ContextUtils.getContext().getPackageName(), 0));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return appName != null ? appName : "un_know_app_name";
    }

    @CalledByNative
    public static long getMemory() {
        return AndroidDeviceInfo.getTotalMemory(ContextUtils.getContext());
    }

    @CalledByNative
    public static int getCpuFreq() {
        return AndroidDeviceInfo.getCPUMaxFreqKHz();
    }

    @CalledByNative
    public static boolean isEmulator(int threshold) {
        return EmulatorCheckUtil.getSingleInstance().checkIsRunningInEmulator(ContextUtils.getContext(), threshold);
    }

    @CalledByNative
    public static boolean isSupportH264HWEncode() {
        return HardwareLevel.level() > 1 && VideoHwHelper.hasH264HwEncoder();
    }

    @CalledByNative
    public static boolean isSupportH264HWDecode() {
        return HardwareLevel.level() > 1 && VideoHwHelper.hasH264HwDecoder();
    }

    @CalledByNative
    public static String getOSExtraInfo() {
        if (sOsExtraInfo == null) {
            boolean isHarmonyOs = HarmonyUtils.isHarmonyOs();
            sOsExtraInfo = !isHarmonyOs ? "" : "is_harmony: " + isHarmonyOs + " , version: " + HarmonyUtils.getHarmonyVersion() + " , display_version: " + HarmonyUtils.getHarmonyDisplayVersion();
        }
        return sOsExtraInfo;
    }
}

