/*
 * Decompiled with CFR 0.152.
 */
package com.netease.yunxin.lite.util;

import android.content.Context;
import android.os.Process;
import com.netease.yunxin.lite.util.Compatibility;
import java.util.ArrayList;
import java.util.List;

public class SystemPermissionUtils {
    private static final ArrayList<String> PERMISSIONS = new ArrayList(16);
    private static final String BLUETOOTH_CONNECT = "android.permission.BLUETOOTH_CONNECT";

    public static boolean hasAudioOutputFeature(Context context) {
        return !Compatibility.runningOnLollipopOrHigher() || context.getPackageManager().hasSystemFeature("android.hardware.audio.output");
    }

    public static boolean hasMicrophoneFeature(Context context) {
        return context.getPackageManager().hasSystemFeature("android.hardware.microphone");
    }

    public static boolean checkAudioPermission(Context context) {
        return SystemPermissionUtils.checkPermission(context, "android.permission.RECORD_AUDIO");
    }

    public static boolean checkCameraPermission(Context context) {
        return SystemPermissionUtils.checkPermission(context, "android.permission.CAMERA");
    }

    public static boolean checkInternetPermission(Context context) {
        return SystemPermissionUtils.checkPermission(context, "android.permission.INTERNET");
    }

    public static boolean checkAccessNetworkStatePermission(Context context) {
        return SystemPermissionUtils.checkPermission(context, "android.permission.ACCESS_NETWORK_STATE");
    }

    public static boolean checkAccessWifiStatePermission(Context context) {
        return SystemPermissionUtils.checkPermission(context, "android.permission.ACCESS_WIFI_STATE");
    }

    public static boolean checkWriteExternalStoragePermission(Context context) {
        return SystemPermissionUtils.checkPermission(context, "android.permission.WRITE_EXTERNAL_STORAGE");
    }

    public static boolean checkWakeLockPermission(Context context) {
        return SystemPermissionUtils.checkPermission(context, "android.permission.WAKE_LOCK");
    }

    public static boolean checkBluetoothPermission(Context context) {
        return SystemPermissionUtils.checkPermission(context, "android.permission.BLUETOOTH");
    }

    public static boolean checkModifyAudioSettingsPermission(Context context) {
        return SystemPermissionUtils.checkPermission(context, "android.permission.MODIFY_AUDIO_SETTINGS");
    }

    public static boolean checkWriteSettingPermission(Context context) {
        return SystemPermissionUtils.checkPermission(context, "android.permission.WRITE_SETTINGS");
    }

    public static boolean checkBluetoothConnectPermission(Context context) {
        return SystemPermissionUtils.checkPermission(context, BLUETOOTH_CONNECT);
    }

    public static boolean checkChangeNetworkStatePermission(Context context) {
        return SystemPermissionUtils.checkPermission(context, "android.permission.CHANGE_NETWORK_STATE");
    }

    public static boolean checkReadPhoneState(Context context) {
        if (Compatibility.getTargetVersion() < 31) {
            return true;
        }
        return SystemPermissionUtils.checkPermission(context, "android.permission.READ_PHONE_STATE");
    }

    public static boolean checkBluetoothScoConnectPermission(Context context) {
        return Compatibility.runningOnSnowConeOrHigher() ? SystemPermissionUtils.checkBluetoothConnectPermission(context) : SystemPermissionUtils.checkBluetoothPermission(context);
    }

    private static boolean checkPermission(Context context, String permission2) {
        return context.checkPermission(permission2, Process.myPid(), Process.myUid()) == 0;
    }

    public static List<String> checkPermission(Context context) {
        ArrayList<String> list = new ArrayList<String>();
        for (String permission2 : PERMISSIONS) {
            if (SystemPermissionUtils.checkPermission(context, permission2)) continue;
            list.add(permission2);
        }
        return list;
    }

    static {
        PERMISSIONS.add("android.permission.RECORD_AUDIO");
        PERMISSIONS.add("android.permission.CAMERA");
        PERMISSIONS.add("android.permission.INTERNET");
        PERMISSIONS.add("android.permission.ACCESS_NETWORK_STATE");
        PERMISSIONS.add("android.permission.ACCESS_WIFI_STATE");
        PERMISSIONS.add("android.permission.WRITE_EXTERNAL_STORAGE");
        PERMISSIONS.add("android.permission.WAKE_LOCK");
        PERMISSIONS.add("android.permission.BLUETOOTH");
        PERMISSIONS.add("android.permission.MODIFY_AUDIO_SETTINGS");
        if (Compatibility.getTargetVersion() > 30) {
            PERMISSIONS.add("android.permission.READ_PHONE_STATE");
        }
        if (Compatibility.runningOnSnowConeOrHigher()) {
            PERMISSIONS.add(BLUETOOTH_CONNECT);
        }
    }
}

