/*
 * Decompiled with CFR 0.152.
 */
package com.netease.yunxin.lite.util;

import android.os.Handler;
import android.os.Looper;
import android.os.SystemClock;
import android.util.Log;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class ThreadUtils {
    private static final Object sLock = new Object();
    private static Handler sUiThreadHandler;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Handler getUiThreadHandler() {
        Object object = sLock;
        synchronized (object) {
            if (sUiThreadHandler == null) {
                sUiThreadHandler = new Handler(Looper.getMainLooper());
            }
            return sUiThreadHandler;
        }
    }

    public static void runOnUiThreadBlocking(Runnable r) {
        ThreadUtils.runOnThreadBlocking(ThreadUtils.getUiThreadHandler(), r);
    }

    public static void runOnUiThread(Runnable r) {
        if (ThreadUtils.runningOnUiThread()) {
            r.run();
        } else {
            ThreadUtils.getUiThreadHandler().post(r);
        }
    }

    public static void runOnUiThreadDelay(Runnable r, long delayMs) {
        ThreadUtils.getUiThreadHandler().postDelayed(r, delayMs);
    }

    public static <T> T runOnUiThreadBlocking(Callable<T> c) {
        return ThreadUtils.runOnThreadBlocking(ThreadUtils.getUiThreadHandler(), c);
    }

    private static boolean runningOnUiThread() {
        return ThreadUtils.getUiThreadHandler().getLooper() == Looper.myLooper();
    }

    public static String getThreadInfo() {
        return "@[name=" + Thread.currentThread().getName() + ", id=" + Thread.currentThread().getId() + "]";
    }

    public static void checkIsOnUiThread() {
        if (Thread.currentThread() != Looper.getMainLooper().getThread()) {
            Log.e((String)"ThreadUtils", (String)"Not on ui thread!");
        }
    }

    private static void executeUninterruptibly(BlockingOperation operation) {
        boolean wasInterrupted = false;
        while (true) {
            try {
                operation.run();
            }
            catch (InterruptedException e) {
                wasInterrupted = true;
                continue;
            }
            break;
        }
        if (wasInterrupted) {
            Thread.currentThread().interrupt();
        }
    }

    public static boolean joinUninterruptibly(Thread thread, long timeoutMs) {
        long startTimeMs = SystemClock.elapsedRealtime();
        long timeRemainingMs = timeoutMs;
        boolean wasInterrupted = false;
        while (timeRemainingMs > 0L) {
            try {
                thread.join(timeRemainingMs);
                break;
            }
            catch (InterruptedException e) {
                wasInterrupted = true;
                long elapsedTimeMs = SystemClock.elapsedRealtime() - startTimeMs;
                timeRemainingMs = timeoutMs - elapsedTimeMs;
            }
        }
        if (wasInterrupted) {
            Thread.currentThread().interrupt();
        }
        return !thread.isAlive();
    }

    public static void joinUninterruptibly(Thread thread) {
        ThreadUtils.executeUninterruptibly(thread::join);
    }

    public static void waitUninterruptibly(Object object) {
        ThreadUtils.executeUninterruptibly(object::wait);
    }

    public static void awaitUninterruptibly(CountDownLatch latch) {
        ThreadUtils.executeUninterruptibly(latch::await);
    }

    public static boolean awaitUninterruptibly(CountDownLatch barrier, long timeoutMs) {
        long startTimeMs = SystemClock.elapsedRealtime();
        long timeRemainingMs = timeoutMs;
        boolean wasInterrupted = false;
        boolean result = false;
        while (true) {
            try {
                result = barrier.await(timeRemainingMs, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                long elapsedTimeMs;
                wasInterrupted = true;
                if ((timeRemainingMs = timeoutMs - (elapsedTimeMs = SystemClock.elapsedRealtime() - startTimeMs)) > 0L) continue;
            }
            break;
        }
        if (wasInterrupted) {
            Thread.currentThread().interrupt();
        }
        return result;
    }

    public static <V> V runOnThreadBlocking(Handler handler, Callable<V> callable) {
        if (handler.getLooper().getThread() == Thread.currentThread()) {
            try {
                return callable.call();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        class Result {
            public V value;

            Result() {
            }
        }
        Result result = new Result();
        class CaughtException {
            Exception e;

            CaughtException() {
            }
        }
        CaughtException caughtException = new CaughtException();
        CountDownLatch barrier = new CountDownLatch(1);
        handler.post(() -> {
            try {
                result.value = callable.call();
            }
            catch (Exception e) {
                caughtException.e = e;
            }
            barrier.countDown();
        });
        ThreadUtils.awaitUninterruptibly(barrier);
        if (caughtException.e != null) {
            RuntimeException runtimeException = new RuntimeException(caughtException.e);
            runtimeException.setStackTrace(ThreadUtils.concatStackTraces(caughtException.e.getStackTrace(), runtimeException.getStackTrace()));
            throw runtimeException;
        }
        return result.value;
    }

    public static void runOnThreadBlocking(Handler handler, Runnable runner) {
        ThreadUtils.runOnThreadBlocking(handler, () -> {
            runner.run();
            return null;
        });
    }

    public static void runOnThread(Handler handler, Runnable runner) {
        if (handler.getLooper().getThread() == Thread.currentThread()) {
            try {
                runner.run();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        } else {
            handler.post(runner);
        }
    }

    public static void runOnThreadDelay(Handler handler, Runnable runner, long delayMills) {
        if (delayMills <= 0L) {
            ThreadUtils.runOnThread(handler, runner);
        } else {
            handler.postDelayed(runner, delayMills);
        }
    }

    public static void removeRunnableOnThread(Handler handler, Runnable runner) {
        handler.removeCallbacks(runner);
    }

    private static StackTraceElement[] concatStackTraces(StackTraceElement[] inner, StackTraceElement[] outer) {
        StackTraceElement[] combined = new StackTraceElement[inner.length + outer.length];
        System.arraycopy(inner, 0, combined, 0, inner.length);
        System.arraycopy(outer, 0, combined, inner.length, outer.length);
        return combined;
    }

    static interface BlockingOperation {
        public void run() throws InterruptedException;
    }
}

