/*
 * Decompiled with CFR 0.152.
 */
package com.netease.yunxin.lite.util;

import android.content.Context;
import android.graphics.Point;
import android.graphics.Rect;
import android.view.WindowManager;
import com.netease.lava.webrtc.Size;

public class VideoUtils {
    private static final int ALIGNMENT_DEFAULT = 2;
    private static int ALIGNMENT = 2;

    public static Size scaleSizeWithAlignment(int inputW, int inputH, int maxW, int maxH) {
        int targetShort;
        int targetLong;
        float scaleShort;
        boolean standLong;
        if (inputW * inputH * maxW * maxH == 0) {
            return new Size(inputW, inputH);
        }
        int inputLenShort = Math.min(inputW, inputH);
        int inputLenLong = Math.max(inputW, inputH);
        int requestLenShort = Math.min(maxW, maxH);
        int requestLenLong = Math.max(maxW, maxH);
        float scaleLong = (float)inputLenLong * 1.0f / (float)requestLenLong;
        boolean bl = standLong = scaleLong > (scaleShort = (float)inputLenShort * 1.0f / (float)requestLenShort);
        if (standLong) {
            targetLong = VideoUtils.alignment(requestLenLong);
            targetShort = VideoUtils.alignment((float)requestLenLong * 1.0f * (float)inputLenShort / (float)inputLenLong);
        } else {
            targetLong = VideoUtils.alignment((float)requestLenShort * 1.0f * (float)inputLenLong / (float)inputLenShort);
            targetShort = VideoUtils.alignment(requestLenShort);
        }
        return inputW > inputH ? new Size(targetLong, targetShort) : new Size(targetShort, targetLong);
    }

    public static Rect getDisplaySize(Context context) {
        WindowManager wm = (WindowManager)context.getSystemService("window");
        Point point = new Point();
        wm.getDefaultDisplay().getSize(point);
        int displayW = point.x;
        int displayH = point.y;
        Rect screenRect = new Rect(0, 0, displayW, displayH);
        return screenRect;
    }

    public static int alignment(double i) {
        return ALIGNMENT * (int)Math.floor(i / (double)ALIGNMENT);
    }
}

