/*
 * Decompiled with CFR 0.152.
 */
package com.netease.yunxin.lite.util.catcher.extra;

import android.annotation.SuppressLint;
import android.app.ActivityManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Build;
import android.os.Environment;
import android.os.Handler;
import android.os.Looper;
import android.os.StatFs;
import android.text.TextUtils;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.security.MessageDigest;
import java.util.Locale;
import java.util.regex.Pattern;

public class BaseUtil {
    private static final char[] M_HEX_CODES = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final int[] M_SHIFTS = new int[]{60, 56, 52, 48, 44, 40, 36, 32, 28, 24, 20, 16, 12, 8, 4, 0};
    private static long sTotalMemory = -1L;

    public static String md5(String value) {
        if (value == null || value.trim().length() < 1) {
            return null;
        }
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            byte[] digest = md5.digest(value.getBytes("UTF-8"));
            return BaseUtil.toHex(digest);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String disk() {
        long[] info = BaseUtil.getSdCardMemory();
        long total = info[0];
        long avail = info[1];
        if (total <= 0L) {
            return "--";
        }
        float ratio = avail * 100L / total;
        return String.format(Locale.US, "%.01f%% [%s]", Float.valueOf(ratio), BaseUtil.getSizeWithUnit(total));
    }

    public static String ram(Context context) {
        long total = BaseUtil.getTotalMemory();
        long avail = BaseUtil.getAvailMemory(context);
        if (total <= 0L) {
            return "--";
        }
        float ratio = avail * 100L / total;
        return String.format(Locale.US, "%.01f%% [%s]", Float.valueOf(ratio), BaseUtil.getSizeWithUnit(total));
    }

    public static String battery(Context context) {
        IntentFilter filter = new IntentFilter("android.intent.action.BATTERY_CHANGED");
        Handler handler = Looper.myLooper() != null ? new Handler(Looper.myLooper()) : null;
        Intent intent = context.registerReceiver(null, filter, null, handler);
        if (intent != null) {
            int level = intent.getIntExtra("level", -1);
            int scale = intent.getIntExtra("scale", -1);
            if (scale != -1) {
                return String.format(Locale.US, "%d%%", level * 100 / scale);
            }
        }
        return "--";
    }

    public static boolean isRooted() {
        boolean emulator = BaseUtil.runningOnEmulator();
        String tags = Build.TAGS;
        if (!emulator && tags != null && tags.contains("test-keys")) {
            return true;
        }
        if (new File("/system/app/Superuser.apk").exists()) {
            return true;
        }
        return !emulator && new File("/system/xbin/su").exists();
    }

    public static void close(Closeable closeable) {
        if (closeable == null) {
            return;
        }
        try {
            closeable.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static synchronized long getTotalMemory() {
        if (sTotalMemory != -1L) {
            return sTotalMemory;
        }
        long total = 0L;
        try {
            String str = BaseUtil.parseFile(new File("/proc/meminfo"), "MemTotal");
            if (!TextUtils.isEmpty((CharSequence)str)) {
                total = (str = str.toUpperCase(Locale.US)).endsWith("KB") ? BaseUtil.getSize(str, "KB", 1024) : (str.endsWith("MB") ? BaseUtil.getSize(str, "MB", 0x100000) : (str.endsWith("GB") ? BaseUtil.getSize(str, "GB", 0x40000000) : -1L));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        sTotalMemory = total;
        return sTotalMemory;
    }

    private static String toHex(byte[] value) {
        StringBuilder retVal = new StringBuilder();
        int digitNum = 2;
        byte[] byArray = value;
        int n = byArray.length;
        for (int i = 0; i < n; ++i) {
            long byteL = byArray[i];
            for (int j = 0; j < digitNum; ++j) {
                int index = (int)(byteL >> M_SHIFTS[j + (16 - digitNum)] & 0xFL);
                retVal.append(M_HEX_CODES[index]);
            }
        }
        return retVal.toString();
    }

    private static long getAvailMemory(Context context) {
        ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
        if (activityManager == null) {
            return -1L;
        }
        ActivityManager.MemoryInfo memoryInfo = new ActivityManager.MemoryInfo();
        activityManager.getMemoryInfo(memoryInfo);
        return memoryInfo.availMem;
    }

    @SuppressLint(value={"NewApi"})
    private static long[] getSdCardMemory() {
        long[] sdCardInfo = new long[2];
        if (!"mounted".equals(Environment.getExternalStorageState())) {
            return sdCardInfo;
        }
        File sdcardDir = Environment.getExternalStorageDirectory();
        StatFs sf = new StatFs(sdcardDir.getPath());
        if (Build.VERSION.SDK_INT >= 18) {
            long bSize = sf.getBlockSizeLong();
            long bCount = sf.getBlockCountLong();
            long availBlocks = sf.getAvailableBlocksLong();
            sdCardInfo[0] = bSize * bCount;
            sdCardInfo[1] = bSize * availBlocks;
        } else {
            long bSize = sf.getBlockSize();
            long bCount = sf.getBlockCount();
            long availBlocks = sf.getAvailableBlocks();
            sdCardInfo[0] = bSize * bCount;
            sdCardInfo[1] = bSize * availBlocks;
        }
        return sdCardInfo;
    }

    private static String getSizeWithUnit(long size) {
        if (size >= 0x40000000L) {
            float i = size / 0x40000000L;
            return String.format(Locale.US, "%.02f GB", Float.valueOf(i));
        }
        if (size >= 0x100000L) {
            float i = size / 0x100000L;
            return String.format(Locale.US, "%.02f MB", Float.valueOf(i));
        }
        float i = size / 1024L;
        return String.format(Locale.US, "%.02f KB", Float.valueOf(i));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String parseFile(File file, String filter) {
        String str = null;
        if (!file.exists()) {
            return null;
        }
        BufferedReader bufferedReader = null;
        try {
            String line;
            bufferedReader = new BufferedReader(new FileReader(file), 1024);
            Pattern pattern = Pattern.compile("\\s*:\\s*");
            while ((line = bufferedReader.readLine()) != null) {
                String[] ret = pattern.split(line, 2);
                if (ret == null || ret.length <= 1 || !ret[0].equals(filter)) continue;
                str = ret[1];
                break;
            }
            BaseUtil.close(bufferedReader);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            BaseUtil.close(bufferedReader);
        }
        return str;
    }

    private static long getSize(String size, String unit, int factor) {
        return Long.parseLong(size.split(unit)[0].trim()) * (long)factor;
    }

    public static Intent registerReceiver(Context context, BroadcastReceiver receiver, IntentFilter filter) {
        Handler handler = null;
        Looper currentLooper = Looper.myLooper();
        if (currentLooper != null) {
            handler = new Handler(currentLooper);
        }
        return context.registerReceiver(receiver, filter, null, handler);
    }

    private static boolean runningOnEmulator() {
        if (!TextUtils.isEmpty((CharSequence)Build.MODEL) && Build.MODEL.toLowerCase().contains("sdk")) {
            return true;
        }
        if (!TextUtils.isEmpty((CharSequence)Build.MANUFACTURER) && Build.MANUFACTURER.toLowerCase().contains("unknown")) {
            return true;
        }
        return !TextUtils.isEmpty((CharSequence)Build.DEVICE) && Build.DEVICE.toLowerCase().contains("generic");
    }
}

