/*
 * Decompiled with CFR 0.152.
 */
package com.netease.yunxin.lite.util.catcher.extra;

import android.content.Context;
import android.os.Build;
import android.os.Environment;
import android.text.TextUtils;
import com.netease.yunxin.lite.util.catcher.extra.BaseUtil;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.json.JSONObject;

public class CatcherUtil {
    public static String dateFormat(String pattern) {
        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
        Date date = new Date();
        return sdf.format(date);
    }

    public static String createBaseLog(String stackTrace, Context context) {
        LinkedHashMap<String, String> info = new LinkedHashMap<String, String>();
        info.put("manufacturer : ", Build.MANUFACTURER);
        info.put("board : ", Build.BOARD);
        info.put("model : ", Build.MODEL);
        info.put("version : ", String.valueOf(Build.VERSION.SDK_INT));
        info.put("display : ", Build.DISPLAY);
        info.put("rooted : ", BaseUtil.isRooted() ? "yes" : "no");
        info.put("battery : ", BaseUtil.battery(context));
        info.put("ram avail : ", BaseUtil.ram(context));
        info.put("disk avail : ", BaseUtil.disk());
        info.put("time : ", CatcherUtil.dateFormat("yyyy-MM-dd HH:mm:ss"));
        String separator = System.getProperty("line.separator");
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("************************* base header *************************");
        stringBuilder.append(separator);
        for (Map.Entry entry : info.entrySet()) {
            stringBuilder.append((String)entry.getKey()).append((String)entry.getValue());
            stringBuilder.append(separator);
        }
        stringBuilder.append(separator);
        stringBuilder.append(separator);
        stringBuilder.append("************************* trace info *************************");
        stringBuilder.append(separator);
        stringBuilder.append(stackTrace);
        stringBuilder.append(separator);
        stringBuilder.append(separator);
        stringBuilder.append(separator);
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File createLogFileWithHeader(String logDir, String baseLog, String filename, HashMap<String, String> extraHeader) {
        if (!Environment.getExternalStorageState().equals("mounted")) {
            return null;
        }
        BufferedWriter bufferedWriter = null;
        try {
            File file = new File(logDir, filename);
            File pFile = file.getParentFile();
            if (!pFile.exists()) {
                pFile.mkdirs();
            }
            if (file.exists()) {
                file.delete();
            }
            file.createNewFile();
            bufferedWriter = new BufferedWriter(new FileWriter(file, true));
            String header = CatcherUtil.extraHeader(extraHeader);
            bufferedWriter.append(header);
            bufferedWriter.append(baseLog);
            bufferedWriter.flush();
            File file2 = file;
            BaseUtil.close(bufferedWriter);
            return file2;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            BaseUtil.close(bufferedWriter);
        }
        return null;
    }

    public static String getMD5(String stackTrace) {
        if (TextUtils.isEmpty((CharSequence)stackTrace)) {
            return null;
        }
        String removeNumber = stackTrace.replaceAll("\\([^\\(]*\\)", "");
        return BaseUtil.md5(removeNumber);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getStackTrace(Throwable ex) {
        StringWriter writer = null;
        PrintWriter printWriter = null;
        String stackTrace = "";
        try {
            writer = new StringWriter();
            printWriter = new PrintWriter(writer);
            ex.printStackTrace(printWriter);
            for (Throwable cause = ex.getCause(); cause != null; cause = cause.getCause()) {
                cause.printStackTrace(printWriter);
            }
            stackTrace = ((Object)writer).toString();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (writer != null) {
                try {
                    ((Writer)writer).close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (printWriter != null) {
                printWriter.close();
            }
        }
        return stackTrace;
    }

    private static String extraHeader(HashMap<String, String> info) {
        if (info == null || info.isEmpty()) {
            return "";
        }
        JSONObject jsonObject = new JSONObject(info);
        StringBuilder headerBuilder = new StringBuilder();
        headerBuilder.append(jsonObject);
        String separator = System.getProperty("line.separator");
        headerBuilder.append(separator);
        headerBuilder.append(separator);
        return headerBuilder.toString();
    }

    public static long parseStrToLong(String timeStr) {
        try {
            return Long.parseLong(timeStr);
        }
        catch (Exception e) {
            return 0L;
        }
    }
}

