/*
 * Decompiled with CFR 0.152.
 */
package com.netease.yunxin.lite.util.catcher.extra;

import android.content.Context;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.text.TextUtils;
import android.util.Log;
import com.netease.yunxin.lite.util.catcher.extra.BaseUtil;
import com.netease.yunxin.lite.util.catcher.extra.CatcherUtil;
import com.netease.yunxin.lite.util.catcher.extra.YXCatcherLog;
import com.netease.yunxin.lite.util.catcher.sdk.YXCatcherComponent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import org.json.JSONObject;

public final class YXExceptionHandler
implements Thread.UncaughtExceptionHandler {
    private static final String CRASH_FILE_DIR_PREFIX = "yx_catcher_log_";
    private static final String FRESH_CRASH_LOG_INFIX = "_yx_fresh_crash_";
    private static final String DIRTY_CRASH_LOG_INFIX = "_yx_dirty_crash_";
    private static final String LOG_FILE_PREFIX = ".log";
    private static final String TAG = "YXExceptionHandler";
    private static YXExceptionHandler instance;
    private Context context;
    private HashMap<String, YXCatcherComponent> yxCrashComponentMap = new HashMap();
    private Thread.UncaughtExceptionHandler defaultUncaughtExceptionHandler;
    private Handler backgroundHandler;

    public static synchronized void setup(YXCatcherComponent catcherComponent) {
        if (instance == null) {
            instance = new YXExceptionHandler(catcherComponent.getContext());
            YXCatcherLog.i(TAG, "create instance");
        }
        instance.addComponent(catcherComponent);
        YXCatcherLog.i(TAG, "setup , sdkType : " + catcherComponent.getSdkType());
    }

    public static synchronized void release(String sdkType) {
        if (instance == null) {
            return;
        }
        if (instance.removeComponent(sdkType)) {
            instance = null;
            YXCatcherLog.i(TAG, "destroy instance");
        }
        YXCatcherLog.i(TAG, "release , sdkType : " + sdkType);
    }

    public static synchronized void processJNIException(String sdkType, String stackTrace) {
        if (instance == null) {
            return;
        }
        instance.runOnWorkThread(() -> {
            ArrayList<YXCatcherComponent> hitComponents = new ArrayList<YXCatcherComponent>();
            YXCatcherComponent component = YXExceptionHandler.instance.yxCrashComponentMap.get(sdkType);
            if (component != null) {
                hitComponents.add(component);
            }
            if (hitComponents.isEmpty()) {
                return;
            }
            instance.processException(hitComponents, stackTrace);
        });
    }

    private YXExceptionHandler(Context context) {
        this.context = context;
        this.defaultUncaughtExceptionHandler = Thread.getDefaultUncaughtExceptionHandler();
        Thread.setDefaultUncaughtExceptionHandler(this);
    }

    private void addComponent(YXCatcherComponent catcherComponent) {
        this.yxCrashComponentMap.put(catcherComponent.getSdkType(), catcherComponent);
        this.runOnWorkThread(() -> this.uploadLastFail(catcherComponent));
    }

    private boolean removeComponent(String sdkType) {
        this.yxCrashComponentMap.remove(sdkType);
        boolean reset = this.yxCrashComponentMap.isEmpty();
        if (reset) {
            if (this.defaultUncaughtExceptionHandler != null) {
                Thread.setDefaultUncaughtExceptionHandler(YXExceptionHandler.instance.defaultUncaughtExceptionHandler);
            }
            if (this.backgroundHandler != null) {
                if (Build.VERSION.SDK_INT >= 18) {
                    this.backgroundHandler.getLooper().quitSafely();
                } else {
                    this.backgroundHandler.getLooper().quit();
                }
                this.backgroundHandler = null;
            }
        }
        return reset;
    }

    private String getCrashDir(String sdkType) {
        String crashType = CRASH_FILE_DIR_PREFIX + sdkType;
        File crashLogDir = this.context.getExternalFilesDir(crashType);
        if (crashLogDir == null || -1 == this.context.getPackageManager().checkPermission("android.permission.WRITE_EXTERNAL_STORAGE", this.context.getPackageName())) {
            crashLogDir = this.context.getDir(crashType, 0);
        }
        crashLogDir.mkdirs();
        return crashLogDir.getAbsolutePath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void uploadLastFail(YXCatcherComponent catcherComponent) {
        ArrayList<File> crashLogFiles;
        block17: {
            YXCatcherComponent.CrashHandler crashHandler;
            ArrayList<String> md5List;
            block15: {
                String crashLogDir = this.getCrashDir(catcherComponent.getSdkType());
                File file = new File(crashLogDir);
                File[] crashFiles = file.listFiles();
                if (crashFiles == null || crashFiles.length == 0) {
                    return;
                }
                ArrayList<String> crashLogList = new ArrayList<String>();
                for (File crashLogFile : crashFiles) {
                    if (crashLogFile.isDirectory()) continue;
                    if (crashLogFile.getName().contains(FRESH_CRASH_LOG_INFIX)) {
                        crashLogList.add(crashLogFile.getAbsolutePath());
                    }
                    if (!crashLogFile.getName().contains(DIRTY_CRASH_LOG_INFIX)) continue;
                    crashLogFile.delete();
                }
                if (crashLogList.isEmpty()) {
                    return;
                }
                md5List = new ArrayList<String>(crashLogList.size());
                crashLogFiles = new ArrayList<File>(crashLogList.size());
                ArrayList<Long> crashTime = new ArrayList<Long>(crashLogList.size());
                for (String logPath : crashLogList) {
                    int md5EndIndex;
                    File freshLogFile = new File(logPath);
                    if (freshLogFile.length() == 0L) {
                        YXCatcherLog.e(TAG, "uploadLastFail , but crash log len = 0 , path :  " + logPath);
                        freshLogFile.delete();
                        continue;
                    }
                    String name = freshLogFile.getName();
                    if (TextUtils.isEmpty((CharSequence)name) || (md5EndIndex = name.lastIndexOf(FRESH_CRASH_LOG_INFIX)) < 0) continue;
                    String md5 = name.substring(0, md5EndIndex);
                    File dirtyFile = new File(freshLogFile.getParent(), name.replace(FRESH_CRASH_LOG_INFIX, DIRTY_CRASH_LOG_INFIX));
                    freshLogFile.renameTo(dirtyFile);
                    int timeEndIndex = name.lastIndexOf(LOG_FILE_PREFIX);
                    if (timeEndIndex < 0) continue;
                    String timeStr = name.substring(md5EndIndex + FRESH_CRASH_LOG_INFIX.length(), timeEndIndex);
                    long time = CatcherUtil.parseStrToLong(timeStr);
                    md5List.add(md5);
                    crashLogFiles.add(dirtyFile);
                    crashTime.add(time);
                }
                YXCatcherComponent.CrashCallback crashCallback = catcherComponent.getCrashCallback();
                crashHandler = catcherComponent.getCrashHandler();
                if (crashCallback == null) break block15;
                for (int i = 0; i < md5List.size(); ++i) {
                    HashMap<String, String> extraInfo = new HashMap<String, String>();
                    BufferedReader reader = null;
                    try {
                        reader = new BufferedReader(new FileReader((File)crashLogFiles.get(0)));
                        String extraInfoJson = reader.readLine();
                        JSONObject object = new JSONObject(extraInfoJson);
                        Iterator iterator = object.keys();
                        while (iterator.hasNext()) {
                            String key = (String)iterator.next();
                            String value = object.optString(key);
                            if (key == null || value == null) continue;
                            extraInfo.put(key, value);
                        }
                    }
                    catch (Exception exception) {
                        BaseUtil.close(reader);
                        catch (Throwable throwable) {
                            BaseUtil.close(reader);
                            throw throwable;
                        }
                    }
                    BaseUtil.close(reader);
                    crashCallback.onCrash((String)md5List.get(i), (File)crashLogFiles.get(0), catcherComponent.getLogDir(), (Long)crashTime.get(i), extraInfo, true);
                }
                break block17;
            }
            if (crashHandler != null) {
                crashHandler.onOldCrash(md5List, crashLogFiles, catcherComponent.getLogDir());
            }
        }
        if (catcherComponent.isAutoDeleteCrashLog()) {
            for (File crashLog : crashLogFiles) {
                crashLog.delete();
            }
        }
    }

    @Override
    public void uncaughtException(Thread thread, Throwable ex) {
        this.runOnWorkThread(() -> {
            try {
                ArrayList<YXCatcherComponent> hitComponents = this.findComponentsByTag(ex);
                this.processException(hitComponents, ex);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                YXCatcherLog.e(TAG, "exception : " + Log.getStackTraceString((Throwable)throwable));
            }
        });
        this.defaultUncaughtException(thread, ex);
        YXCatcherLog.e(TAG, "uncaught exception : " + Log.getStackTraceString((Throwable)ex));
    }

    private void ensureHandler() {
        if (this.backgroundHandler != null) {
            return;
        }
        HandlerThread thread = new HandlerThread("yx_catcher_handler_thread");
        thread.start();
        this.backgroundHandler = new Handler(thread.getLooper());
    }

    private void runOnWorkThread(Runnable runnable) {
        this.ensureHandler();
        this.backgroundHandler.post(runnable);
    }

    private ArrayList<YXCatcherComponent> findComponentsByTag(Throwable throwable) {
        Collection<YXCatcherComponent> crashComponents = this.yxCrashComponentMap.values();
        ArrayList<YXCatcherComponent> hitComponents = new ArrayList<YXCatcherComponent>();
        String traceString = Log.getStackTraceString((Throwable)throwable);
        block0: for (YXCatcherComponent catcherComponent : crashComponents) {
            ArrayList<String> crashTags = catcherComponent.getCrashTags();
            if (crashTags == null || crashTags.isEmpty()) {
                hitComponents.add(catcherComponent);
                continue;
            }
            for (String tag : crashTags) {
                if (!traceString.contains(tag)) continue;
                hitComponents.add(catcherComponent);
                continue block0;
            }
        }
        return hitComponents;
    }

    private void processException(ArrayList<YXCatcherComponent> hitComponents, Throwable ex) {
        String stackTrace = CatcherUtil.getStackTrace(ex);
        this.processException(hitComponents, stackTrace);
    }

    private void processException(ArrayList<YXCatcherComponent> hitComponents, String stackTrace) {
        if (hitComponents == null || hitComponents.isEmpty()) {
            return;
        }
        String md5 = CatcherUtil.getMD5(stackTrace);
        if (TextUtils.isEmpty((CharSequence)md5)) {
            return;
        }
        long time = System.currentTimeMillis();
        String fileName = md5 + FRESH_CRASH_LOG_INFIX + time + LOG_FILE_PREFIX;
        String baseLog = CatcherUtil.createBaseLog(stackTrace, this.context);
        for (int index = 0; index < hitComponents.size(); ++index) {
            YXCatcherComponent component = hitComponents.get(index);
            String crashLogDir = this.getCrashDir(component.getSdkType());
            File freshCrashLog = CatcherUtil.createLogFileWithHeader(crashLogDir, baseLog, fileName, component.getCrashLogHeader());
            if (freshCrashLog == null) continue;
            YXCatcherComponent.CrashCallback crashCallback = component.getCrashCallback();
            YXCatcherComponent.CrashHandler crashHandler = component.getCrashHandler();
            if (crashCallback != null) {
                crashCallback.onCrash(md5, freshCrashLog, component.getLogDir(), time, component.getCrashLogHeader(), false);
            } else if (crashHandler != null) {
                crashHandler.onCrash(md5, freshCrashLog, component.getLogDir());
            }
            if (!component.isAutoDeleteCrashLog()) continue;
            freshCrashLog.delete();
        }
    }

    private void defaultUncaughtException(Thread thread, Throwable ex) {
        if (this.defaultUncaughtExceptionHandler != null) {
            this.defaultUncaughtExceptionHandler.uncaughtException(thread, ex);
        }
    }
}

