/*
 * Decompiled with CFR 0.152.
 */
package com.netease.yunxin.lite.util.catcher.sdk;

import android.content.Context;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class YXCatcherComponent {
    private Context context;
    private String sdkType;
    private ArrayList<String> crashTags;
    private CrashHandler crashHandler;
    private CrashCallback crashCallback;
    private HashMap<String, String> crashLogHeader = new HashMap();
    private boolean autoDeleteCrashLog = false;
    private String logDir;

    private YXCatcherComponent(Context context, String sdkType, ArrayList<String> crashTags, CrashHandler crashHandler) {
        this.context = context;
        this.sdkType = sdkType;
        this.crashTags = crashTags;
        this.crashHandler = crashHandler;
    }

    private YXCatcherComponent(Context context, String sdkType, ArrayList<String> crashTags, CrashCallback crashCallback) {
        this.context = context;
        this.sdkType = sdkType;
        this.crashTags = crashTags;
        this.crashCallback = crashCallback;
    }

    private YXCatcherComponent logDir(String logDir) {
        this.logDir = logDir;
        return this;
    }

    private YXCatcherComponent crashLogHeader(HashMap<String, String> crashLogHeader) {
        if (crashLogHeader != null) {
            this.crashLogHeader.putAll(crashLogHeader);
        }
        return this;
    }

    private YXCatcherComponent autoDeleteCrashLog(boolean autoDeleteCrashLog) {
        this.autoDeleteCrashLog = autoDeleteCrashLog;
        return this;
    }

    public Context getContext() {
        return this.context;
    }

    public String getSdkType() {
        return this.sdkType;
    }

    public ArrayList<String> getCrashTags() {
        return this.crashTags;
    }

    public CrashHandler getCrashHandler() {
        return this.crashHandler;
    }

    public CrashCallback getCrashCallback() {
        return this.crashCallback;
    }

    public HashMap<String, String> getCrashLogHeader() {
        return this.crashLogHeader;
    }

    public boolean isAutoDeleteCrashLog() {
        return this.autoDeleteCrashLog;
    }

    public String getLogDir() {
        return this.logDir;
    }

    public static interface CrashCallback {
        public void onCrash(String var1, File var2, String var3, long var4, HashMap<String, String> var6, boolean var7);
    }

    @Deprecated
    public static interface CrashHandler {
        public void onOldCrash(List<String> var1, List<File> var2, String var3);

        public void onCrash(String var1, File var2, String var3);
    }

    public static interface LogCallback {
        public void log(int var1, String var2, String var3);
    }

    public static class Builder {
        private Context context;
        private String sdkType;
        private ArrayList<String> crashTags;
        private CrashHandler crashHandler;
        private CrashCallback crashCallback;
        private HashMap<String, String> crashLogHeader;
        private boolean autoDeleteCrashLog = false;
        private String logDir;
        private LogCallback logCallback;

        public Builder(Context context, String sdkType, ArrayList<String> crashTags, CrashHandler crashHandler) {
            this.context = context.getApplicationContext();
            this.sdkType = sdkType;
            this.crashTags = crashTags;
            this.crashHandler = crashHandler;
        }

        public Builder(Context context, String sdkType, ArrayList<String> crashTags, CrashCallback crashCallback) {
            this.context = context.getApplicationContext();
            this.sdkType = sdkType;
            this.crashTags = crashTags;
            this.crashCallback = crashCallback;
        }

        public Builder crashLogHeader(HashMap<String, String> crashLogHeader) {
            this.crashLogHeader = crashLogHeader;
            return this;
        }

        public Builder autoDeleteCrashLog(boolean autoDeleteCrashLog) {
            this.autoDeleteCrashLog = autoDeleteCrashLog;
            return this;
        }

        public Builder logDir(String logDir) {
            this.logDir = logDir;
            return this;
        }

        public YXCatcherComponent build() {
            if (this.crashCallback != null) {
                return new YXCatcherComponent(this.context, this.sdkType, this.crashTags, this.crashCallback).crashLogHeader(this.crashLogHeader).autoDeleteCrashLog(this.autoDeleteCrashLog).logDir(this.logDir);
            }
            return new YXCatcherComponent(this.context, this.sdkType, this.crashTags, this.crashHandler).crashLogHeader(this.crashLogHeader).autoDeleteCrashLog(this.autoDeleteCrashLog).logDir(this.logDir);
        }
    }
}

