/*
 * Decompiled with CFR 0.152.
 */
package com.netease.yunxin.lite.util.emulator;

import android.content.Context;
import android.content.SharedPreferences;
import android.text.TextUtils;
import com.netease.lava.webrtc.Logging;
import com.netease.yunxin.lite.util.ContextUtils;
import com.netease.yunxin.lite.util.emulator.CommandUtil;

public class EmulatorCheckUtil {
    private static final String TAG = "EmulatorCheckUtil";
    private final String Emulator = "IsEmulator";
    private final String strTrue = "true";
    private final String strFalse = "false";
    private SharedPreferences mSharedPreferences = ContextUtils.getContext().getSharedPreferences("NERTC_SDK_DEVICE", 0);
    private volatile int mCheckResult = -1;
    private int emulatorThreshold = 3;

    private EmulatorCheckUtil() {
        String isEmulatorStr = this.mSharedPreferences.getString("IsEmulator", null);
        if (TextUtils.isEmpty((CharSequence)isEmulatorStr)) {
            new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Class<EmulatorCheckUtil> clazz = EmulatorCheckUtil.class;
                    synchronized (EmulatorCheckUtil.class) {
                        boolean isEmulator = EmulatorCheckUtil.this.readSysPropertyImpl(ContextUtils.getContext()) || EmulatorCheckUtil.this.checkSysProperty();
                        Logging.i(EmulatorCheckUtil.TAG, "isEmulator = " + isEmulator);
                        EmulatorCheckUtil.this.saveCheckResult(isEmulator);
                        EmulatorCheckUtil.this.saveSharedPreferences(isEmulator);
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return;
                    }
                }
            }.start();
        } else {
            boolean isEmulator = "true".equals(isEmulatorStr);
            this.saveCheckResult(isEmulator);
        }
    }

    public static EmulatorCheckUtil getSingleInstance() {
        return SingletonHolder.INSTANCE;
    }

    private void saveSharedPreferences(boolean isEmulator) {
        if (this.mSharedPreferences == null) {
            this.mSharedPreferences = ContextUtils.getContext().getSharedPreferences("NERTC_SDK_DEVICE", 0);
        }
        SharedPreferences.Editor editor = this.mSharedPreferences.edit();
        editor.putString("IsEmulator", isEmulator ? "true" : "false");
        editor.apply();
    }

    public void setThreshold(int threshold) {
        this.emulatorThreshold = threshold;
    }

    private void saveCheckResult(boolean isEmulator) {
        this.mCheckResult = isEmulator ? 1 : 2;
    }

    public boolean checkSysProperty() {
        try {
            String strQemu = this.getProperty("ro.kernel.qemu");
            if ("1".equals(strQemu)) {
                Logging.i(TAG, "check emulator find qemu");
                return true;
            }
            String device = this.getProperty("ro.product.device");
            if (!TextUtils.isEmpty((CharSequence)device) && device.toLowerCase().contains("generic")) {
                Logging.i(TAG, "check emulator find Build.generic");
                return true;
            }
            String abi = this.getProperty("ro.product.cpu.abi");
            if (!TextUtils.isEmpty((CharSequence)abi) && (abi.contains("x86") || abi.contains("x86_64"))) {
                Logging.i(TAG, "check emulator find ABI.x86");
                return true;
            }
            String cpuInfo = CommandUtil.getSingleInstance().exec("cat /proc/cpuinfo");
            if (!TextUtils.isEmpty((CharSequence)cpuInfo) && (cpuInfo.toLowerCase().contains("intel") || cpuInfo.toLowerCase().contains("amd"))) {
                Logging.i(TAG, "check emulator find intel|amd");
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkIsRunningInEmulator(Context context, int threshold) {
        Class<EmulatorCheckUtil> clazz = EmulatorCheckUtil.class;
        synchronized (EmulatorCheckUtil.class) {
            if (this.mCheckResult != -1 && this.emulatorThreshold == threshold) {
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return this.mCheckResult == 1;
            }
            this.emulatorThreshold = threshold;
            Logging.i(TAG, "checkIsRunningInEmulator: cache not used, start check threshold:" + threshold);
            boolean isEmulator = this.readSysPropertyImpl(context) || this.checkSysProperty();
            this.saveCheckResult(isEmulator);
            this.saveSharedPreferences(isEmulator);
            Logging.i(TAG, "checkIsRunningInEmulator: end");
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return isEmulator;
        }
    }

    private boolean readSysPropertyImpl(Context context) {
        boolean supportBluetooth;
        boolean supportCamera;
        if (context == null) {
            return false;
        }
        int suspectCount = 0;
        CheckResult hardwareResult = this.checkFeaturesByHardware();
        switch (hardwareResult.result) {
            case 0: {
                ++suspectCount;
                break;
            }
            case 1: {
                Logging.i(TAG, "findEmulator hardware = " + hardwareResult.value);
                return true;
            }
        }
        CheckResult flavorResult = this.checkFeaturesByFlavor();
        switch (flavorResult.result) {
            case 0: {
                ++suspectCount;
                break;
            }
            case 1: {
                Logging.i(TAG, "findEmulator flavor = " + flavorResult.value);
                return true;
            }
        }
        CheckResult modelResult = this.checkFeaturesByModel();
        switch (modelResult.result) {
            case 0: {
                ++suspectCount;
                break;
            }
            case 1: {
                Logging.i(TAG, "findEmulator model = " + modelResult.value);
                return true;
            }
        }
        CheckResult manufacturerResult = this.checkFeaturesByManufacturer();
        switch (manufacturerResult.result) {
            case 0: {
                ++suspectCount;
                break;
            }
            case 1: {
                Logging.i(TAG, "findEmulator manufacturer = " + manufacturerResult.value);
                return true;
            }
        }
        CheckResult boardResult = this.checkFeaturesByBoard();
        switch (boardResult.result) {
            case 0: {
                ++suspectCount;
                break;
            }
            case 1: {
                Logging.i(TAG, "findEmulator board = " + boardResult.value);
                return true;
            }
        }
        CheckResult platformResult = this.checkFeaturesByPlatform();
        switch (platformResult.result) {
            case 0: {
                ++suspectCount;
                break;
            }
            case 1: {
                Logging.i(TAG, "findEmulator platform = " + platformResult.value);
                return true;
            }
        }
        CheckResult baseBandResult = this.checkFeaturesByBaseBand();
        switch (baseBandResult.result) {
            case 0: {
                suspectCount += 2;
                break;
            }
            case 1: {
                Logging.i(TAG, "findEmulator baseBand = " + baseBandResult.value);
                return true;
            }
        }
        boolean supportCameraFlash = this.supportCameraFlash(context);
        if (!supportCameraFlash) {
            ++suspectCount;
        }
        if (!(supportCamera = this.supportCamera(context))) {
            ++suspectCount;
        }
        if (!(supportBluetooth = this.supportBluetooth(context))) {
            ++suspectCount;
        }
        CheckResult cgroupResult = this.checkFeaturesByCgroup();
        if (cgroupResult.result == 0) {
            ++suspectCount;
        }
        StringBuffer stringBuffer = new StringBuffer("Test start").append("\r\n").append("hardware = ").append(hardwareResult.value).append("\r\n").append("flavor = ").append(flavorResult.value).append("\r\n").append("model = ").append(modelResult.value).append("\r\n").append("manufacturer = ").append(manufacturerResult.value).append("\r\n").append("board = ").append(boardResult.value).append("\r\n").append("platform = ").append(platformResult.value).append("\r\n").append("baseBand = ").append(baseBandResult.value).append("\r\n").append("supportCamera = ").append(supportCamera).append("\r\n").append("supportCameraFlash = ").append(supportCameraFlash).append("\r\n").append("supportBluetooth = ").append(supportBluetooth).append("\r\n").append("cgroupResult = ").append(cgroupResult.value).append("\r\n").append("suspectCount = ").append(suspectCount);
        Logging.i(TAG, "findEmulator Test start  " + stringBuffer.toString());
        return suspectCount > this.emulatorThreshold;
    }

    private int getUserAppNum(String userApps) {
        if (TextUtils.isEmpty((CharSequence)userApps)) {
            return 0;
        }
        String[] result = userApps.split("package:");
        return result.length;
    }

    private String getProperty(String propName) {
        String property = CommandUtil.getSingleInstance().getProperty(propName);
        return TextUtils.isEmpty((CharSequence)property) ? null : property;
    }

    private CheckResult checkFeaturesByHardware() {
        int result;
        String tempValue;
        String hardware = this.getProperty("ro.hardware");
        if (null == hardware) {
            return new CheckResult(0, null);
        }
        switch (tempValue = hardware.toLowerCase()) {
            case "ttvm": 
            case "nox": 
            case "cancro": 
            case "intel": 
            case "vbox": 
            case "vbox86": 
            case "android_x86": {
                result = 1;
                break;
            }
            default: {
                result = 2;
            }
        }
        return new CheckResult(result, hardware);
    }

    private CheckResult checkFeaturesByFlavor() {
        String flavor = this.getProperty("ro.build.flavor");
        if (null == flavor) {
            return new CheckResult(0, null);
        }
        String tempValue = flavor.toLowerCase();
        int result = tempValue.contains("vbox") ? 1 : (tempValue.contains("sdk_gphone") ? 1 : 2);
        return new CheckResult(result, flavor);
    }

    private CheckResult checkFeaturesByModel() {
        String model = this.getProperty("ro.product.model");
        if (null == model) {
            return new CheckResult(0, null);
        }
        String tempValue = model.toLowerCase();
        int result = tempValue.contains("google_sdk") ? 1 : (tempValue.contains("emulator") ? 1 : (tempValue.contains("android sdk built for x86") ? 1 : 2));
        return new CheckResult(result, model);
    }

    private CheckResult checkFeaturesByManufacturer() {
        String manufacturer = this.getProperty("ro.product.manufacturer");
        if (null == manufacturer) {
            return new CheckResult(0, null);
        }
        String tempValue = manufacturer.toLowerCase();
        int result = tempValue.contains("genymotion") ? 1 : (tempValue.contains("netease") ? 1 : 2);
        return new CheckResult(result, manufacturer);
    }

    private CheckResult checkFeaturesByBoard() {
        String board = this.getProperty("ro.product.board");
        if (null == board) {
            return new CheckResult(0, null);
        }
        String tempValue = board.toLowerCase();
        int result = tempValue.contains("android") ? 1 : (tempValue.contains("goldfish") ? 1 : 2);
        return new CheckResult(result, board);
    }

    private CheckResult checkFeaturesByPlatform() {
        String platform = this.getProperty("ro.board.platform");
        if (null == platform) {
            return new CheckResult(0, null);
        }
        String tempValue = platform.toLowerCase();
        int result = tempValue.contains("android") ? 1 : 2;
        return new CheckResult(result, platform);
    }

    private CheckResult checkFeaturesByBaseBand() {
        String baseBandVersion = this.getProperty("gsm.version.baseband");
        if (null == baseBandVersion) {
            return new CheckResult(0, null);
        }
        int result = baseBandVersion.contains("1.0.0.0") ? 1 : 2;
        return new CheckResult(result, baseBandVersion);
    }

    private boolean supportCamera(Context context) {
        return context.getPackageManager().hasSystemFeature("android.hardware.camera");
    }

    private boolean supportCameraFlash(Context context) {
        return context.getPackageManager().hasSystemFeature("android.hardware.camera.flash");
    }

    private boolean supportBluetooth(Context context) {
        return context.getPackageManager().hasSystemFeature("android.hardware.bluetooth");
    }

    private CheckResult checkFeaturesByCgroup() {
        String filter = CommandUtil.getSingleInstance().exec("cat /proc/self/cgroup");
        if (null == filter) {
            return new CheckResult(0, null);
        }
        return new CheckResult(2, filter);
    }

    private static class SingletonHolder {
        private static final EmulatorCheckUtil INSTANCE = new EmulatorCheckUtil();

        private SingletonHolder() {
        }
    }

    public static class CheckResult {
        static final int RESULT_IDLE = -1;
        static final int RESULT_MAYBE_EMULATOR = 0;
        static final int RESULT_EMULATOR = 1;
        static final int RESULT_UNKNOWN = 2;
        public int result;
        public String value;

        CheckResult(int result, String value) {
            this.result = result;
            this.value = value;
        }
    }
}

