/*
 * Decompiled with CFR 0.152.
 */
package com.netease.yunxin.lite.util.emulator;

import android.os.Build;
import android.text.TextUtils;
import android.util.Log;
import com.netease.lava.webrtc.Logging;
import java.lang.reflect.Method;

public class HarmonyUtils {
    private static final String TAG = "HarmonyUtils";

    public static boolean isHarmonyOs() {
        try {
            Class<?> buildExClass = Class.forName("com.huawei.system.BuildEx");
            Object osBrand = buildExClass.getMethod("getOsBrand", new Class[0]).invoke(buildExClass, new Object[0]);
            return "Harmony".equalsIgnoreCase(osBrand.toString());
        }
        catch (Throwable x) {
            return false;
        }
    }

    public static String getHarmonyVersion() {
        return HarmonyUtils.getProp("hw_sc.build.platform.version", "");
    }

    public static String getHarmonyDisplayVersion() {
        return Build.DISPLAY;
    }

    private static String getProp(String property, String defaultValue) {
        try {
            Class<?> spClz = Class.forName("android.os.SystemProperties");
            Method method = spClz.getDeclaredMethod("get", String.class);
            String value = (String)method.invoke(spClz, property);
            if (TextUtils.isEmpty((CharSequence)value)) {
                return defaultValue;
            }
            return value;
        }
        catch (Throwable e) {
            Logging.e(TAG, "getProp: " + Log.getStackTraceString((Throwable)e));
            return defaultValue;
        }
    }
}

