/*
 * Decompiled with CFR 0.152.
 */
package com.netease.yunxin.lite.util.http;

import android.annotation.SuppressLint;
import android.text.TextUtils;
import android.util.Log;
import com.netease.lava.webrtc.CalledByNative;
import com.netease.lava.webrtc.Logging;
import com.netease.yunxin.lite.annotation.Keep;
import com.netease.yunxin.lite.util.ArrayUtils;
import com.netease.yunxin.lite.util.Compatibility;
import com.netease.yunxin.lite.util.http.HttpStackResponse;
import com.netease.yunxin.lite.util.http.MultipartWriter;
import com.netease.yunxin.lite.util.http.NamedThreadFactory;
import com.netease.yunxin.lite.util.http.PreLollipopTLSSocketFactory;
import com.netease.yunxin.lite.util.http.TlsSniSocketFactory;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.zip.GZIPOutputStream;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import org.json.JSONObject;

public class HttpStack {
    private static final String TAG = "HttpStack";
    private static String[] sHighPriorityPath = new String[]{"/nrtc/getChannelInfos.action", "/api/v1/domains", "/api/v1/client_config", "/httpdns/v2/d"};
    private static RejectedExecutionHandler sRejectedHandler = new RejectedExecutionHandler(){

        @Override
        public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
            Logging.w(HttpStack.TAG, "rejectedExecution: " + r.toString() + ", executor:" + executor.toString());
        }
    };
    private static final ThreadPoolExecutor sNormalExecutor = new ThreadPoolExecutor(3, 3, 5L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new NamedThreadFactory(false, "http_stack"), sRejectedHandler);
    private static final ThreadPoolExecutor sHighPriorityExecutor = new ThreadPoolExecutor(2, 48, 5L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new NamedThreadFactory(true, "http_stack"), sRejectedHandler);

    private static void closeQuietly(Closeable closeable) {
        if (closeable == null) {
            return;
        }
        try {
            closeable.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static HttpURLConnection createConnection(URL url) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setInstanceFollowRedirects(HttpURLConnection.getFollowRedirects());
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static HttpURLConnection openConnection(URL url, String method, Map<String, String> headers, byte[] body, int timeoutMs) throws IOException {
        HttpURLConnection connection = HttpStack.createConnection(url);
        connection.setRequestMethod(method);
        connection.setConnectTimeout(timeoutMs);
        connection.setReadTimeout(timeoutMs);
        connection.setUseCaches(false);
        connection.setDoInput(true);
        HttpStack.configHttps(connection, null);
        if (headers != null) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                connection.setRequestProperty(entry.getKey(), entry.getValue());
            }
        }
        if (!ArrayUtils.isEmpty(body)) {
            OutputStream originOs = null;
            GZIPOutputStream os = null;
            try {
                connection.setDoOutput(true);
                originOs = connection.getOutputStream();
                try {
                    if (headers != null && "gzip".equals(headers.get("Content-Encoding"))) {
                        os = new GZIPOutputStream(new BufferedOutputStream(originOs));
                        ((OutputStream)os).write(body);
                        ((OutputStream)os).flush();
                    } else if (originOs != null) {
                        originOs.write(body);
                        originOs.flush();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            finally {
                HttpStack.closeQuietly(os);
                HttpStack.closeQuietly(originOs);
            }
        }
        return connection;
    }

    private static HttpURLConnection openConnection(URL url, String method, Map<String, String> headers, int timeoutMs) throws IOException {
        HttpURLConnection connection = HttpStack.createConnection(url);
        connection.setRequestMethod(method);
        connection.setConnectTimeout(timeoutMs);
        connection.setReadTimeout(timeoutMs);
        connection.setUseCaches(false);
        connection.setDoInput(true);
        HttpStack.configHttps(connection, null);
        if (headers != null) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                connection.setRequestProperty(entry.getKey(), entry.getValue());
            }
        }
        return connection;
    }

    @Keep
    @CalledByNative
    public static HttpStackResponse doPostSNI(String path, Map<String, String> headers, byte[] body, int timeoutMs, String ip, String host) {
        FutureTask<HttpStackResponse> futureTask = new FutureTask<HttpStackResponse>(() -> HttpStack.doHttpMethod(path, headers, body, timeoutMs, ip, host, "POST"));
        HttpStackResponse response = null;
        try {
            HttpStack.getExecutor(path).submit(futureTask);
            response = futureTask.get(timeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            Logging.e(TAG, "http post error: " + e.getMessage());
            if (response != null) {
                Log.e((String)TAG, (String)("http post error header: " + response.headers));
            } else {
                response = new HttpStackResponse();
            }
            response.code = HttpStack.convertExceptionToErrorCode(e);
        }
        return response;
    }

    @Keep
    @CalledByNative
    public static HttpStackResponse doGetSNI(String path, Map<String, String> headers, byte[] body, int timeoutMs, String ip, String host) {
        FutureTask<HttpStackResponse> futureTask = new FutureTask<HttpStackResponse>(() -> HttpStack.doHttpMethod(path, headers, body, timeoutMs, ip, host, "GET"));
        HttpStackResponse response = null;
        try {
            HttpStack.getExecutor(path).submit(futureTask);
            response = futureTask.get(timeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            Logging.e(TAG, "http get error: " + e.getMessage());
            if (response != null) {
                Log.e((String)TAG, (String)("http post error header: " + response.headers));
            } else {
                response = new HttpStackResponse();
            }
            response.code = HttpStack.convertExceptionToErrorCode(e);
        }
        return response;
    }

    @Keep
    @CalledByNative
    public static HttpStackResponse doGet(final String path, final Map<String, String> headers, final byte[] body, final int timeoutMs) {
        FutureTask<HttpStackResponse> futureTask = new FutureTask<HttpStackResponse>(new Callable<HttpStackResponse>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public HttpStackResponse call() throws Exception {
                HttpStackResponse response = null;
                HttpURLConnection urlConnection = null;
                try {
                    URL requestedUrl = new URL(path);
                    urlConnection = HttpStack.openConnection(requestedUrl, "GET", headers, body, timeoutMs);
                    int responseCode = urlConnection.getResponseCode();
                    long lastModified = urlConnection.getLastModified();
                    response = new HttpStackResponse();
                    response.code = responseCode;
                    response.lastModified = lastModified;
                    Map<String, List<String>> headerlists = urlConnection.getHeaderFields();
                    Set<String> keys = headerlists.keySet();
                    JSONObject jsonObject = new JSONObject();
                    for (String key : keys) {
                        String val = urlConnection.getHeaderField(key);
                        jsonObject.put(key != null ? key : "httpversion", (Object)val);
                    }
                    response.headers = jsonObject.toString();
                    response.result = HttpStack.readFully(urlConnection.getInputStream());
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    Logging.e(HttpStack.TAG, "http get error: " + ex.getMessage());
                    if (response != null) {
                        Log.e((String)HttpStack.TAG, (String)("http get error header: " + response.headers));
                    } else {
                        response = new HttpStackResponse();
                    }
                    response.code = HttpStack.convertExceptionToErrorCode(ex);
                }
                finally {
                    if (urlConnection != null) {
                        urlConnection.disconnect();
                    }
                }
                return response;
            }
        });
        HttpStackResponse response = null;
        try {
            HttpStack.getExecutor(path).submit(futureTask);
            response = futureTask.get(timeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            Logging.e(TAG, "http get error: " + e.getMessage());
            if (response != null) {
                Log.e((String)TAG, (String)("http post error header: " + response.headers));
            } else {
                response = new HttpStackResponse();
            }
            response.code = HttpStack.convertExceptionToErrorCode(e);
        }
        return response;
    }

    public static HttpStackResponse doPost(String url) {
        return HttpStack.doPost(url, null, null, 3000);
    }

    public static HttpStackResponse doPost(String url, String body) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/x-www-form-urlencoded;charset=utf-8");
        return HttpStack.doPost(url, headers, body.getBytes(), 3000);
    }

    @Keep
    @CalledByNative
    public static HttpStackResponse doPost(final String url, final Map<String, String> headers, final byte[] body, final int timeoutMs) {
        FutureTask<HttpStackResponse> futureTask = new FutureTask<HttpStackResponse>(new Callable<HttpStackResponse>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public HttpStackResponse call() throws Exception {
                HttpStackResponse response = null;
                HttpURLConnection urlConnection = null;
                int httpResponseCode = -1;
                try {
                    URL requestedUrl = new URL(url);
                    urlConnection = HttpStack.openConnection(requestedUrl, "POST", headers, body, timeoutMs);
                    httpResponseCode = urlConnection.getResponseCode();
                    long lastModified = urlConnection.getLastModified();
                    response = new HttpStackResponse();
                    response.code = httpResponseCode;
                    response.lastModified = lastModified;
                    Map<String, List<String>> headerLists = urlConnection.getHeaderFields();
                    Set<String> keys = headerLists.keySet();
                    JSONObject jsonObject = new JSONObject();
                    for (String key : keys) {
                        String val = urlConnection.getHeaderField(key);
                        jsonObject.put(key != null ? key : "httpversion", (Object)val);
                    }
                    response.headers = jsonObject.toString();
                    response.result = HttpStack.readFully(urlConnection.getInputStream());
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    Logging.e(HttpStack.TAG, "http post error: " + ex.getMessage());
                    if (response != null) {
                        Log.e((String)HttpStack.TAG, (String)("http post error header: " + response.headers));
                    } else {
                        response = new HttpStackResponse();
                    }
                    if (httpResponseCode == -1) {
                        response.code = HttpStack.convertExceptionToErrorCode(ex);
                    }
                }
                finally {
                    if (urlConnection != null) {
                        urlConnection.disconnect();
                    }
                }
                return response;
            }
        });
        HttpStackResponse response = null;
        try {
            HttpStack.getExecutor(url).submit(futureTask);
            response = futureTask.get(timeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            Logging.e(TAG, "http post error: " + e.getMessage());
            if (response != null) {
                Log.e((String)TAG, (String)("http post error header: " + response.headers));
            } else {
                response = new HttpStackResponse();
            }
            response.code = HttpStack.convertExceptionToErrorCode(e);
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpStackResponse multipartPost(String url, String BOUNDARY, String LINE_FEED, Map<String, String> headers, MultipartWriter writer) {
        HttpStackResponse response = null;
        OutputStream outputStream = null;
        PrintWriter printWriter = null;
        HttpURLConnection conn = null;
        try {
            URL requestedUrl = new URL(url);
            conn = HttpStack.openConnection(requestedUrl, "POST", headers, 3000);
            conn.setDoOutput(true);
            outputStream = conn.getOutputStream();
            printWriter = headers != null && "gzip".equals(headers.get("Content-Encoding")) ? new PrintWriter(new GZIPOutputStream(outputStream)) : new PrintWriter(outputStream);
            writer.addPart(printWriter, outputStream);
            printWriter.append(LINE_FEED);
            printWriter.append("--").append(BOUNDARY).append("--").append(LINE_FEED);
            printWriter.flush();
            int responseCode = conn.getResponseCode();
            long lastModified = conn.getLastModified();
            response = new HttpStackResponse();
            response.code = responseCode;
            response.result = HttpStack.readFully(conn.getInputStream());
            response.lastModified = lastModified;
        }
        catch (IOException e) {
            e.printStackTrace();
            if (response != null) {
                Log.e((String)TAG, (String)("http post error header: " + response.headers));
            } else {
                response = new HttpStackResponse();
            }
            response.code = HttpStack.convertExceptionToErrorCode(e);
        }
        finally {
            if (printWriter != null) {
                printWriter.close();
            }
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (conn != null) {
                conn.disconnect();
            }
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] readFully(InputStream inputStream) throws IOException {
        byte[] byArray;
        if (inputStream == null) {
            return new byte[0];
        }
        BufferedInputStream bufferedInputStream = null;
        try {
            int available;
            bufferedInputStream = new BufferedInputStream(inputStream);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            while ((available = bufferedInputStream.read(buffer)) >= 0) {
                byteArrayOutputStream.write(buffer, 0, available);
            }
            byArray = byteArrayOutputStream.toByteArray();
        }
        catch (Throwable throwable) {
            HttpStack.closeQuietly(bufferedInputStream);
            throw throwable;
        }
        HttpStack.closeQuietly(bufferedInputStream);
        return byArray;
    }

    private static void configHttps(HttpURLConnection urlConnection, String verifyHost) {
        if (!Compatibility.runningOnLollipopMR1OrHigher()) {
            HttpStack.configHttpsOnPreLollipop(urlConnection, verifyHost);
            return;
        }
        if (!(urlConnection instanceof HttpsURLConnection)) {
            return;
        }
        HttpsURLConnection conn = (HttpsURLConnection)urlConnection;
        try {
            SSLContext sslcontext = SSLContext.getInstance("TLS");
            sslcontext.init(null, null, null);
            conn.setSSLSocketFactory(sslcontext.getSocketFactory());
            HostnameVerifier hostnameVerifier = (hostname, session) -> {
                HostnameVerifier defaultHostVerifier = HttpsURLConnection.getDefaultHostnameVerifier();
                if (TextUtils.isEmpty((CharSequence)verifyHost)) {
                    return defaultHostVerifier.verify(hostname, session);
                }
                return verifyHost.equals(hostname) || defaultHostVerifier.verify(verifyHost, session);
            };
            conn.setHostnameVerifier(hostnameVerifier);
        }
        catch (Exception e) {
            e.printStackTrace();
            Logging.e(TAG, "configHttps error:" + Log.getStackTraceString((Throwable)e));
        }
    }

    private static void configHttpsOnPreLollipop(HttpURLConnection urlConnection, final String verifyHost) {
        if (!(urlConnection instanceof HttpsURLConnection)) {
            return;
        }
        if (Compatibility.runningOnLollipopMR1OrHigher()) {
            return;
        }
        HttpsURLConnection conn = (HttpsURLConnection)urlConnection;
        try {
            conn.setSSLSocketFactory(new PreLollipopTLSSocketFactory());
            HostnameVerifier hostnameVerifier = new HostnameVerifier(){

                @Override
                public boolean verify(String hostname, SSLSession session) {
                    HostnameVerifier defaultHostVerifier = HttpsURLConnection.getDefaultHostnameVerifier();
                    if (TextUtils.isEmpty((CharSequence)verifyHost)) {
                        return defaultHostVerifier.verify(hostname, session);
                    }
                    return verifyHost.equals(hostname) || defaultHostVerifier.verify(verifyHost, session);
                }
            };
            conn.setHostnameVerifier(hostnameVerifier);
        }
        catch (Exception exc) {
            Logging.e(TAG, "Error while setting TLS 1.2" + Log.getStackTraceString((Throwable)exc));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static HttpStackResponse doHttpMethod(String path, Map<String, String> headers, byte[] body, int timeoutMs, String ip, String host, String method) {
        HttpURLConnection connection = null;
        HttpStackResponse response = null;
        if (path == null || path.isEmpty() || host == null || host.isEmpty()) {
            Logging.e(TAG, "illegal argument");
            Log.e((String)TAG, (String)("illegal argument, path:" + path + ", ip:" + ip + ", host:" + host));
            return null;
        }
        int httpResponseCode = -1;
        try {
            URL url = new URL(path);
            if (!"https".equals(url.getProtocol())) {
                Logging.e(TAG, "doPost failed");
                Log.e((String)TAG, (String)("doPost failed, " + url.getProtocol() + " is not https"));
                HttpStackResponse httpStackResponse = null;
                return httpStackResponse;
            }
            if (ip != null && !ip.isEmpty() && url.getPort() == -1) {
                Logging.i(TAG, "replace host:" + url.getHost() + " to ip:" + ip);
                String newUrl = path.replaceFirst(url.getHost(), ip);
                connection = (HttpsURLConnection)new URL(newUrl).openConnection();
            }
            connection = (HttpsURLConnection)url.openConnection();
            connection.setRequestProperty("Host", host);
            connection.setRequestMethod(method);
            connection.setConnectTimeout(timeoutMs);
            connection.setReadTimeout(timeoutMs);
            connection.setUseCaches(false);
            connection.setDoInput(true);
            connection.setInstanceFollowRedirects(false);
            if (headers != null) {
                for (Map.Entry entry : headers.entrySet()) {
                    connection.setRequestProperty((String)entry.getKey(), (String)entry.getValue());
                }
            }
            TlsSniSocketFactory sslSocketFactory = new TlsSniSocketFactory((HttpsURLConnection)connection);
            ((HttpsURLConnection)connection).setSSLSocketFactory(sslSocketFactory);
            HttpURLConnection httpURLConnection = connection;
            ((HttpsURLConnection)connection).setHostnameVerifier(new HostnameVerifier((HttpsURLConnection)httpURLConnection){
                final /* synthetic */ HttpsURLConnection val$finalConnection;
                {
                    this.val$finalConnection = httpsURLConnection;
                }

                @Override
                @SuppressLint(value={"BadHostnameVerifier"})
                public boolean verify(String hostname, SSLSession session) {
                    boolean verified;
                    String host = this.val$finalConnection.getRequestProperty("Host");
                    if (null == host) {
                        host = this.val$finalConnection.getURL().getHost();
                    }
                    if (!(verified = HttpsURLConnection.getDefaultHostnameVerifier().verify(host, session))) {
                        Logging.w(HttpStack.TAG, "host name verify failed");
                    }
                    return verified;
                }
            });
            if (!ArrayUtils.isEmpty(body)) {
                connection.setDoOutput(true);
                OutputStream os = connection.getOutputStream();
                if (headers != null && "gzip".equals(headers.get("Content-Encoding"))) {
                    os = new GZIPOutputStream(new BufferedOutputStream(os));
                }
                os.write(body);
                os.flush();
                HttpStack.closeQuietly(os);
            }
            if (HttpStack.needRedirect(httpResponseCode = connection.getResponseCode())) {
                String location = connection.getHeaderField("Location");
                if (location == null) {
                    location = connection.getHeaderField("location");
                }
                if (!location.startsWith("http://") && !location.startsWith("https://")) {
                    URL originalUrl = new URL(path);
                    location = originalUrl.getProtocol() + "://" + originalUrl.getHost() + location;
                }
                HttpStackResponse httpStackResponse = HttpStack.doPostSNI(location, headers, body, timeoutMs, null, host);
                return httpStackResponse;
            }
            long lastModified = connection.getLastModified();
            response = new HttpStackResponse();
            response.code = httpResponseCode;
            response.lastModified = lastModified;
            Map<String, List<String>> headerLists = connection.getHeaderFields();
            Set<String> keys = headerLists.keySet();
            JSONObject jsonObject = new JSONObject();
            for (String key : keys) {
                String val = connection.getHeaderField(key);
                jsonObject.put(key != null ? key : "httpversion", (Object)val);
            }
            response.headers = jsonObject.toString();
            response.result = HttpStack.readFully(connection.getInputStream());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Logging.e(TAG, "http post error: " + exception.getMessage());
            if (response != null) {
                Log.e((String)TAG, (String)("http post error header: " + response.headers));
            } else {
                response = new HttpStackResponse();
            }
            if (httpResponseCode == -1) {
                response.code = HttpStack.convertExceptionToErrorCode(exception);
            }
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
        return response;
    }

    private static ThreadPoolExecutor getExecutor(String path) {
        if (TextUtils.isEmpty((CharSequence)path)) {
            return sNormalExecutor;
        }
        for (String highPriorityPath : sHighPriorityPath) {
            if (!path.contains(highPriorityPath)) continue;
            return sHighPriorityExecutor;
        }
        return sNormalExecutor;
    }

    private static boolean needRedirect(int code) {
        return code >= 300 && code < 400;
    }

    private static int convertExceptionToErrorCode(Exception e) {
        if (e instanceof ConnectException) {
            return 10003;
        }
        if (e instanceof UnknownHostException) {
            return 10002;
        }
        if (e instanceof SocketTimeoutException) {
            return 10001;
        }
        if (e instanceof MalformedURLException) {
            return 10000;
        }
        if (e instanceof TimeoutException) {
            return 10001;
        }
        return 10003;
    }
}

