/*
 * Decompiled with CFR 0.152.
 */
package com.netease.yunxin.lite.util.http;

import android.net.SSLCertificateSocketFactory;
import android.util.Log;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public class TlsSniSocketFactory
extends SSLSocketFactory {
    private static final String TAG = "TlsSniSocketFactory";
    private final HttpsURLConnection mHttpsURLConnection;

    public TlsSniSocketFactory(HttpsURLConnection httpsURLConnection) {
        this.mHttpsURLConnection = httpsURLConnection;
    }

    @Override
    public Socket createSocket() throws IOException {
        return null;
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException {
        return null;
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException {
        return null;
    }

    @Override
    public Socket createSocket(InetAddress host, int port) throws IOException {
        return null;
    }

    @Override
    public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
        return null;
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return new String[0];
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return new String[0];
    }

    @Override
    public Socket createSocket(Socket plainSocket, String host, int port, boolean autoClose) throws IOException {
        String peerHost = this.mHttpsURLConnection.getRequestProperty("Host");
        if (peerHost == null) {
            peerHost = host;
        }
        Log.i((String)TAG, (String)("customized createSocket. host: " + peerHost));
        InetAddress address = plainSocket.getInetAddress();
        if (autoClose) {
            plainSocket.close();
        }
        SSLCertificateSocketFactory sslSocketFactory = (SSLCertificateSocketFactory)SSLCertificateSocketFactory.getDefault((int)0);
        SSLSocket ssl = (SSLSocket)sslSocketFactory.createSocket(address, port);
        ssl.setEnabledProtocols(ssl.getSupportedProtocols());
        Log.i((String)TAG, (String)"Setting SNI hostname");
        sslSocketFactory.setHostname((Socket)ssl, peerHost);
        SSLSession session = ssl.getSession();
        if (!HttpsURLConnection.getDefaultHostnameVerifier().verify(peerHost, session)) {
            Log.w((String)TAG, (String)("Cannot verify hostname: " + peerHost));
            throw new SSLPeerUnverifiedException("Cannot verify hostname: " + peerHost);
        }
        Log.i((String)TAG, (String)("Established " + session.getProtocol() + " connection with " + session.getPeerHost() + " using " + session.getCipherSuite()));
        return ssl;
    }
}

